/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.storedproc.StoredProcedureSnapshotGenerator;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.MariaDBDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;
import liquibase.util.StringUtil;

public class MySQLStoredProcedureSnapshotGenerator
extends StoredProcedureSnapshotGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof MySQLDatabase) {
            int n2 = super.getPriority(clazz, database);
            if (n2 > 0) {
                return 50;
            }
            return n2;
        }
        return -1;
    }

    @Override
    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[]{StoredProcedureSnapshotGenerator.class};
    }

    @Override
    public StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database database, StoredDatabaseLogic<?> storedDatabaseLogic) {
        Object object = this.getSnapshotObjectSql(storedDatabaseLogic, database);
        object = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database).queryForList(new RawSqlStatement((String)object));
        object = this.castToListOfMaps(object);
        StringBuilder stringBuilder = new StringBuilder();
        new StringBuilder();
        String string = null;
        Boolean bl2 = null;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Map)object.next();
            if (string == null) {
                string = (String)object2.get("PROCEDURE");
            }
            if (stringBuilder.length() != 0) continue;
            if ((object2 = (String)object2.get("CREATE PROCEDURE")) != null) {
                object2 = ((String)object2).replaceAll("CREATE DEFINER=(.*) PROCEDURE ", "CREATE PROCEDURE ");
            } else {
                object2 = " [CANNOT READ OBJECT BODY]";
                String string2 = null;
                if (database instanceof MariaDBDatabase) {
                    string2 = "\nThe current MariaDB user does not have permissions to access Stored Logic object bodies needed for this Liquibase command.\nPlease search the changelog for '[CANNOT READ OBJECT BODY]' to locate inaccessible objects. Learn more about altering permissions with suggested MariaDB GRANTs at https://docs.liquibase.com/workflows/liquibase-pro/mariadbgrants.html\n";
                } else if (database instanceof MySQLDatabase) {
                    string2 = "\nThe current MySQL user does not have permissions to access Stored Logic object bodies needed for this Liquibase command.\nPlease search the changelog for '[CANNOT READ OBJECT BODY]' to locate inaccessible objects. This is potentially due to a known\nMySQL bug https://bugs.mysql.com/bug.php?id=22763. Learn more about altering permissions with suggested MySQL GRANTs at\nhttps://docs.liquibase.com/workflows/liquibase-pro/mysqlgrants.html\n";
                }
                if (string2 != null) {
                    Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(string2)));
                    Scope.getCurrentScope().getLog(this.getClass()).warning(string2);
                }
            }
            stringBuilder.append(((String)object2).replaceFirst("\\r?\\n$", "")).append("\n");
        }
        stringBuilder = new StringBuilder(StringUtil.trimToEmpty(StringUtil.trimToEmpty(stringBuilder.toString().replaceAll("\r\n", "\n").replaceAll("\r", "\n"))));
        return ((StoredProcedure)((StoredProcedure)this.createReturnObject().setSchema(storedDatabaseLogic.getSchema()).setName(string)).setValid(bl2)).setBody(stringBuilder.toString());
    }

    public StoredDatabaseLogic performSnapshotAndBuildStoredObject2(Database database, StoredDatabaseLogic<?> storedDatabaseLogic) {
        Object object = this.getSnapshotObjectSql(storedDatabaseLogic, database);
        object = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database).queryForList(new RawSqlStatement((String)object));
        object = this.castToListOfMaps(object);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = null;
        Boolean bl2 = null;
        object = object.iterator();
        while (object.hasNext()) {
            Map map = (Map)object.next();
            if (string == null) {
                string = (String)map.get("OBJECT_NAME");
            }
            if (bl2 == null) {
                bl2 = "VALID".equals(map.get("STATUS"));
            }
            String string2 = (String)map.get("DATA_TYPE");
            Object object2 = (String)map.get("PARAMETER_MODE");
            Object object3 = (String)map.get("PARAMETER_NAME");
            if (object3 != null) {
                if (stringBuilder2.length() > 0) {
                    stringBuilder2.append(", ");
                }
                if (object2 != null) {
                    stringBuilder2.append((String)object2);
                    stringBuilder2.append(" ");
                }
                stringBuilder2.append((String)object3);
                stringBuilder2.append(" ");
                stringBuilder2.append(string2.toUpperCase());
                string2 = map.get("CHAR_LENGTH");
                object2 = (Number)map.get("NUMERIC_PRECISION");
                object3 = (Number)map.get("NUMERIC_SCALE");
                if (string2 != null) {
                    stringBuilder2.append("( ");
                    stringBuilder2.append((Object)string2);
                    stringBuilder2.append(" )");
                } else if (object2 != null) {
                    stringBuilder2.append("( ");
                    stringBuilder2.append(object2);
                    if (object3 != null) {
                        stringBuilder2.append(", ");
                        stringBuilder2.append(object3);
                    }
                    stringBuilder2.append(" )");
                }
            }
            if (stringBuilder.length() != 0) continue;
            string2 = (String)map.get("OBJECT_BODY");
            if (string2 == null) {
                string2 = " [CANNOT READ OBJECT BODY]";
                object2 = null;
                if (database instanceof MariaDBDatabase) {
                    object2 = "\nThe current MariaDB user does not have permissions to access Stored Logic object bodies needed for this Liquibase command.\nPlease search the changelog for '[CANNOT READ OBJECT BODY]' to locate inaccessible objects. Learn more about altering permissions with suggested MariaDB GRANTs at https://docs.liquibase.com/workflows/liquibase-pro/mariadbgrants.html\n";
                } else if (database instanceof MySQLDatabase) {
                    object2 = "\nThe current MySQL user does not have permissions to access Stored Logic object bodies needed for this Liquibase command.\nPlease search the changelog for '[CANNOT READ OBJECT BODY]' to locate inaccessible objects. This is potentially due to a known\nMySQL bug https://bugs.mysql.com/bug.php?id=22763. Learn more about altering permissions with suggested MySQL GRANTs at\nhttps://docs.liquibase.com/workflows/liquibase-pro/mysqlgrants.html\n";
                }
                if (object2 != null) {
                    Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object2)));
                    Scope.getCurrentScope().getLog(this.getClass()).warning((String)object2);
                }
            }
            stringBuilder.append(string2.replaceFirst("\\r?\\n$", "")).append("\n");
        }
        stringBuilder = new StringBuilder(StringUtil.trimToEmpty(StringUtil.trimToEmpty(stringBuilder.toString().replaceAll("\r\n", "\n").replaceAll("\r", "\n"))));
        object = " ( " + stringBuilder2.toString() + " )";
        stringBuilder.insert(0, "CREATE PROCEDURE " + string + (String)object + "\n\n");
        return ((StoredProcedure)((StoredProcedure)this.createReturnObject().setSchema(storedDatabaseLogic.getSchema()).setName(string)).setValid(bl2)).setBody(stringBuilder.toString());
    }
}

