/*
 * Decompiled with CFR 0.152.
 */
package liquibase.statement;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import liquibase.Scope;
import liquibase.change.ColumnConfig;
import liquibase.change.core.LoadDataChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.PreparedStatementFactory;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.listener.SqlListener;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.ExecutablePreparedStatement;
import liquibase.util.FilenameUtil;
import liquibase.util.JdbcUtil;
import liquibase.util.StreamUtil;

public abstract class ExecutablePreparedStatementBase
implements ExecutablePreparedStatement {
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected Database database;
    private String catalogName;
    private String schemaName;
    private String tableName;
    private List<? extends ColumnConfig> columns;
    private ChangeSet changeSet;
    private Set<Closeable> closeables;
    private ResourceAccessor resourceAccessor;
    private static PreparedStatement lastPreparedStatement;
    private static String lastPreparedStatementSql;
    private static Method executeWithFlagsMethod;

    protected ExecutablePreparedStatementBase(Database database, String catalogName, String schemaName, String tableName, List<? extends ColumnConfig> columns, ChangeSet changeSet, ResourceAccessor resourceAccessor) {
        this.database = database;
        this.changeSet = changeSet;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columns = columns;
        this.changeSet = changeSet;
        this.closeables = new HashSet<Closeable>();
        this.resourceAccessor = resourceAccessor;
    }

    private static InputStream createStream(InputStream in2) {
        return in2 instanceof BufferedInputStream ? in2 : new BufferedInputStream(in2);
    }

    @Override
    public void execute(PreparedStatementFactory factory) throws DatabaseException {
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        ArrayList<ColumnConfig> cols = new ArrayList<ColumnConfig>(this.getColumns().size());
        String sql = this.generateSql(cols);
        for (SqlListener listener : Scope.getCurrentScope().getListeners(SqlListener.class)) {
            listener.writeSqlWillRun(sql);
        }
        log.fine("Number of columns = " + cols.size());
        PreparedStatement stmt = this.getCachedStatement(sql);
        if (stmt == null) {
            lastPreparedStatement = stmt = factory.create(sql);
            lastPreparedStatementSql = sql;
        } else {
            try {
                stmt.clearParameters();
            }
            catch (SQLException e2) {
                log.fine("Error clearing parameters on prepared statement: " + e2.getMessage(), e2);
            }
        }
        try {
            this.attachParams(cols, stmt);
            this.executePreparedStatement(stmt);
        }
        catch (SQLException e3) {
            throw new DatabaseException(e3);
        }
        finally {
            for (Closeable closeable : this.closeables) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected PreparedStatement getCachedStatement(String sql) {
        if (lastPreparedStatement == null || lastPreparedStatementSql == null) {
            return null;
        }
        boolean statementIsValid = true;
        if (lastPreparedStatementSql.equals(sql)) {
            try {
                Connection connection;
                if (lastPreparedStatement.isClosed()) {
                    statementIsValid = false;
                }
                if (statementIsValid && ((connection = lastPreparedStatement.getConnection()) == null || connection.isClosed())) {
                    statementIsValid = false;
                }
            }
            catch (SQLException e2) {
                statementIsValid = false;
            }
        } else {
            statementIsValid = false;
        }
        if (!statementIsValid) {
            JdbcUtil.closeStatement(lastPreparedStatement);
            lastPreparedStatement = null;
            lastPreparedStatementSql = null;
        }
        return lastPreparedStatement;
    }

    protected void executePreparedStatement(PreparedStatement stmt) throws SQLException {
        if (this.database instanceof PostgresDatabase) {
            try {
                if (executeWithFlagsMethod == null) {
                    executeWithFlagsMethod = stmt.getClass().getMethod("executeWithFlags", Integer.TYPE);
                    executeWithFlagsMethod.setAccessible(true);
                }
                executeWithFlagsMethod.invoke((Object)stmt, 1);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
                stmt.execute();
            }
        } else {
            stmt.execute();
        }
    }

    protected void attachParams(List<? extends ColumnConfig> cols, PreparedStatement stmt) throws SQLException, DatabaseException {
        int i2 = 1;
        for (ColumnConfig columnConfig : cols) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Applying column parameter = " + i2 + " for column " + columnConfig.getName());
            this.applyColumnParameter(stmt, i2, columnConfig);
            ++i2;
        }
    }

    protected abstract String generateSql(List<ColumnConfig> var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyColumnParameter(PreparedStatement stmt, int i2, ColumnConfig col) throws SQLException, DatabaseException {
        Logger LOG = Scope.getCurrentScope().getLog(this.getClass());
        if (col.getValue() != null) {
            LOG.fine("value is string/UUID/blob = " + col.getValue());
            if (col.getType() != null && col.getType().equalsIgnoreCase(LoadDataChange.LOAD_DATA_TYPE.UUID.name())) {
                stmt.setObject(i2, UUID.fromString(col.getValue()));
                return;
            }
            if (col.getType() != null && col.getType().equalsIgnoreCase(LoadDataChange.LOAD_DATA_TYPE.OTHER.name())) {
                stmt.setObject(i2, (Object)col.getValue(), 1111);
                return;
            }
            if (LoadDataChange.LOAD_DATA_TYPE.BLOB.name().equalsIgnoreCase(col.getType())) {
                stmt.setBlob(i2, new ByteArrayInputStream(Base64.getDecoder().decode(col.getValue())));
                return;
            }
            if (LoadDataChange.LOAD_DATA_TYPE.CLOB.name().equalsIgnoreCase(col.getType())) {
                try {
                    if (this.database instanceof PostgresDatabase || this.database instanceof SQLiteDatabase) {
                        stmt.setString(i2, col.getValue());
                        return;
                    }
                    Clob clobValue = stmt.getConnection().createClob();
                    clobValue.setString(1L, col.getValue());
                    stmt.setClob(i2, clobValue);
                    return;
                }
                catch (SQLFeatureNotSupportedException e2) {
                    stmt.setString(i2, col.getValue());
                }
                return;
            }
            stmt.setString(i2, col.getValue());
            return;
        }
        if (col.getValueBoolean() != null) {
            LOG.fine("value is boolean = " + col.getValueBoolean());
            stmt.setBoolean(i2, col.getValueBoolean());
            return;
        } else if (col.getValueNumeric() != null) {
            LOG.fine("value is numeric = " + col.getValueNumeric());
            Number number = col.getValueNumeric();
            if (number instanceof ColumnConfig.ValueNumeric) {
                ColumnConfig.ValueNumeric valueNumeric = (ColumnConfig.ValueNumeric)number;
                number = valueNumeric.getDelegate();
            }
            if (number instanceof Long) {
                stmt.setLong(i2, number.longValue());
                return;
            } else if (number instanceof Integer) {
                stmt.setInt(i2, number.intValue());
                return;
            } else if (number instanceof Double) {
                stmt.setDouble(i2, number.doubleValue());
                return;
            } else if (number instanceof Float) {
                stmt.setFloat(i2, number.floatValue());
                return;
            } else if (number instanceof BigDecimal) {
                stmt.setBigDecimal(i2, (BigDecimal)number);
                return;
            } else {
                if (!(number instanceof BigInteger)) throw new UnexpectedLiquibaseException(String.format(coreBundle.getString("jdbc.bind.parameter.unknown.numeric.value.type"), col.getName(), col.getValueNumeric().toString(), col.getValueNumeric().getClass().getName()));
                stmt.setInt(i2, number.intValue());
            }
            return;
        } else if (col.getValueDate() != null) {
            LOG.fine("value is date = " + col.getValueDate());
            if (col.getValueDate() instanceof Timestamp) {
                stmt.setTimestamp(i2, (Timestamp)col.getValueDate());
                return;
            } else if (col.getValueDate() instanceof Time) {
                stmt.setTime(i2, (Time)col.getValueDate());
                return;
            } else {
                stmt.setDate(i2, new Date(col.getValueDate().getTime()));
            }
            return;
        } else if (col.getValueBlobFile() != null) {
            LOG.fine("value is blob = " + col.getValueBlobFile());
            try {
                LOBContent<InputStream> lob = this.toBinaryStream(col.getValueBlobFile());
                if (((LOBContent)lob).length <= Integer.MAX_VALUE) {
                    stmt.setBlob(i2, (InputStream)((LOBContent)lob).content, (int)((LOBContent)lob).length);
                    return;
                }
                stmt.setBlob(i2, (InputStream)((LOBContent)lob).content, ((LOBContent)lob).length);
                return;
            }
            catch (IOException | LiquibaseException e3) {
                throw new DatabaseException(e3.getMessage(), e3);
            }
        } else if (col.getValueClobFile() != null) {
            try {
                LOG.fine("value is clob = " + col.getValueClobFile());
                LOBContent<Reader> lob = this.toCharacterStream(col.getValueClobFile(), col.getEncoding());
                if (((LOBContent)lob).length <= Integer.MAX_VALUE) {
                    stmt.setCharacterStream(i2, (Reader)((LOBContent)lob).content, (int)((LOBContent)lob).length);
                    return;
                }
                stmt.setCharacterStream(i2, (Reader)((LOBContent)lob).content, ((LOBContent)lob).length);
                return;
            }
            catch (IOException | LiquibaseException e4) {
                throw new DatabaseException(e4.getMessage(), e4);
            }
        } else {
            LOG.fine("value is explicit null");
            if (col.getType() == null) {
                stmt.setNull(i2, 0);
                return;
            }
            if (col.getType().toLowerCase().contains("datetime")) {
                stmt.setNull(i2, 93);
                return;
            } else {
                String[] aliases;
                boolean isSet = false;
                LiquibaseDataType dataType = DataTypeFactory.getInstance().fromDescription(col.getType(), this.database);
                for (String alias : aliases = dataType.getAliases()) {
                    if (!alias.contains("java.sql.Types")) continue;
                    String name = alias.replaceAll("java.sql.Types.", "");
                    try {
                        JDBCType jdbcType = Enum.valueOf(JDBCType.class, name);
                        stmt.setNull(i2, jdbcType.getVendorTypeNumber());
                        return;
                    }
                    catch (Exception exception) {}
                    break;
                }
                if (isSet) return;
                LOG.info(String.format("Using java.sql.Types.NULL to set null value for type %s", dataType.getName()));
                stmt.setNull(i2, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LOBContent<InputStream> toBinaryStream(String valueLobFile) throws LiquibaseException, IOException {
        InputStream in2 = this.getResourceAsStream(valueLobFile);
        if (in2 == null) {
            throw new DatabaseException("BLOB resource not found: " + valueLobFile);
        }
        try {
            if (in2 instanceof FileInputStream) {
                InputStream bufferedInput = ExecutablePreparedStatementBase.createStream(in2);
                LOBContent<InputStream> lOBContent = new LOBContent<InputStream>(bufferedInput, ((FileInputStream)in2).getChannel().size());
                return lOBContent;
            }
            in2 = ExecutablePreparedStatementBase.createStream(in2);
            int IN_MEMORY_THRESHOLD = 100000;
            if (in2.markSupported()) {
                in2.mark(100000);
            }
            long length = this.getContentLength(in2);
            if (in2.markSupported() && length <= 100000L) {
                in2.reset();
            } else {
                try {
                    in2.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                in2 = this.getResourceAsStream(valueLobFile);
                in2 = ExecutablePreparedStatementBase.createStream(in2);
            }
            LOBContent<InputStream> lOBContent = new LOBContent<InputStream>(in2, length);
            return lOBContent;
        }
        finally {
            if (in2 != null) {
                this.closeables.add(in2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LOBContent<Reader> toCharacterStream(String valueLobFile, String encoding) throws IOException, LiquibaseException {
        InputStream in2 = this.getResourceAsStream(valueLobFile);
        if (in2 == null) {
            throw new DatabaseException("CLOB resource not found: " + valueLobFile);
        }
        int IN_MEMORY_THRESHOLD = 100000;
        Reader reader = null;
        try {
            reader = StreamUtil.readStreamWithReader(in2, encoding);
            if (reader.markSupported()) {
                reader.mark(100000);
            }
            long length = this.getContentLength(reader);
            if (reader.markSupported() && length <= 100000L) {
                reader.reset();
            } else {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                in2 = this.getResourceAsStream(valueLobFile);
                reader = StreamUtil.readStreamWithReader(in2, encoding);
            }
            LOBContent<Reader> lOBContent = new LOBContent<Reader>(reader, length);
            return lOBContent;
        }
        finally {
            if (reader != null) {
                this.closeables.add(reader);
            }
            if (in2 != null) {
                this.closeables.add(in2);
            }
        }
    }

    private InputStream getResourceAsStream(String valueLobFile) throws IOException, LiquibaseException {
        String fileName = this.getFileName(valueLobFile);
        return this.resourceAccessor.openStream(null, fileName);
    }

    private String getFileName(String fileName) {
        String relativeBaseFileName = this.changeSet.getChangeLog().getPhysicalFilePath();
        return FilenameUtil.concat(FilenameUtil.getDirectory(relativeBaseFileName), fileName);
    }

    @Override
    public boolean skipOnUnsupported() {
        return false;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<? extends ColumnConfig> getColumns() {
        return this.columns;
    }

    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    public ResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    protected long getContentLength(InputStream in2) throws IOException {
        long length = 0L;
        byte[] buf = new byte[4096];
        int bytesRead = in2.read(buf);
        while (bytesRead > 0) {
            length += (long)bytesRead;
            bytesRead = in2.read(buf);
        }
        return length;
    }

    protected long getContentLength(Reader reader) throws IOException {
        long length = 0L;
        char[] buf = new char[2048];
        int charsRead = reader.read(buf);
        while (charsRead > 0) {
            length += (long)charsRead;
            charsRead = reader.read(buf);
        }
        return length;
    }

    private class LOBContent<T> {
        private final T content;
        private final long length;

        LOBContent(T content, long length) {
            this.content = content;
            this.length = length;
        }
    }
}

