/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import liquibase.exception.LiquibaseException;
import liquibase.util.StringUtil;

public class TableOutput {
    public static void formatOutput(List<List<String>> table, List<Integer> maxWidths, boolean leftJustifiedRows, Writer writer) throws LiquibaseException {
        TableOutput.formatOutput((String[][])table.stream().map(u2 -> u2.toArray(new String[0])).toArray(x$0 -> new String[x$0][]), maxWidths, leftJustifiedRows, writer);
    }

    public static void formatOutput(List<List<String>> table, int[] maxWidths, boolean leftJustifiedRows, Writer writer) throws LiquibaseException {
        TableOutput.formatOutput((String[][])table.stream().map(u2 -> u2.toArray(new String[0])).toArray(x$0 -> new String[x$0][]), maxWidths, leftJustifiedRows, writer);
    }

    public static void formatOutput(String[][] table, int[] maxWidths, boolean leftJustifiedRows, Writer writer) throws LiquibaseException {
        TableOutput.formatOutput(table, IntStream.of(maxWidths).boxed().collect(Collectors.toList()), leftJustifiedRows, writer);
    }

    public static void formatOutput(String[][] table, List<Integer> maxWidths, boolean leftJustifiedRows, Writer writer) throws LiquibaseException {
        int defaultMaxWidth = 30;
        if (table[0].length != maxWidths.size()) {
            throw new RuntimeException("Table and maximum widths arrays must be the same length");
        }
        for (int i2 = 0; i2 < maxWidths.size(); ++i2) {
            if (maxWidths.get(i2) != 0) continue;
            maxWidths.set(i2, defaultMaxWidth);
        }
        StringBuilder outputLines = new StringBuilder();
        ArrayList tableList = new ArrayList(Arrays.asList(table));
        ArrayList<String[]> finalTableList = new ArrayList<String[]>();
        for (String[] row : tableList) {
            for (int i3 = 0; i3 < row.length; ++i3) {
                row[i3] = TableOutput.padColumn(row[i3], maxWidths.get(i3));
            }
            boolean isMultiLine = false;
            int multiLine = 0;
            do {
                isMultiLine = false;
                String[] newRow = new String[row.length];
                for (int i4 = 0; i4 < row.length; ++i4) {
                    if (row[i4] == null || row[i4].length() < maxWidths.get(i4)) {
                        newRow[i4] = multiLine == 0 ? row[i4] : "";
                        continue;
                    }
                    if (row[i4].length() > multiLine * maxWidths.get(i4)) {
                        int end = Math.min(row[i4].length(), multiLine * maxWidths.get(i4) + maxWidths.get(i4));
                        newRow[i4] = row[i4].substring(multiLine * maxWidths.get(i4), end);
                        isMultiLine = true;
                        continue;
                    }
                    newRow[i4] = "";
                }
                finalTableList.add(newRow);
                if (!isMultiLine) continue;
                ++multiLine;
            } while (isMultiLine);
        }
        String[][] finalTable = new String[finalTableList.size()][((String[])finalTableList.get(0)).length];
        for (int i5 = 0; i5 < finalTable.length; ++i5) {
            finalTable[i5] = (String[])finalTableList.get(i5);
        }
        HashMap<Integer, Integer> columnLengths = new HashMap<Integer, Integer>();
        Arrays.stream(finalTable).forEach(a2 -> {
            for (int i2 = 0; i2 < ((String[])a2).length; ++i2) {
                columnLengths.putIfAbsent(i2, 0);
                if (a2[i2] == null || (Integer)columnLengths.get(i2) >= a2[i2].length()) continue;
                columnLengths.put(i2, a2[i2].length());
            }
        });
        StringBuilder formatString = new StringBuilder();
        String flag = leftJustifiedRows ? "-" : "";
        columnLengths.forEach((key, value) -> formatString.append("| %" + flag + value + "s "));
        formatString.append("|\n");
        String line = columnLengths.entrySet().stream().reduce("", (ln2, b2) -> {
            StringBuilder tempLine = new StringBuilder("+-");
            for (int i2 = 0; i2 < (Integer)b2.getValue(); ++i2) {
                tempLine.append("-");
            }
            tempLine.append("-");
            return ln2 + tempLine;
        }, (a2, b2) -> a2 + b2);
        line = line + "+\n";
        outputLines.append(line);
        boolean firstLine = true;
        for (String[] strings : finalTable) {
            if (TableOutput.allEmptyStrings(strings)) {
                outputLines.append(line);
            } else {
                outputLines.append(String.format(formatString.toString(), strings));
            }
            if (!firstLine) continue;
            outputLines.append(line);
            firstLine = false;
        }
        try {
            writer.append(outputLines.toString());
            writer.flush();
        }
        catch (IOException ioe) {
            throw new LiquibaseException(ioe);
        }
    }

    private static boolean allEmptyStrings(String[] strings) {
        return Arrays.stream(strings).allMatch(StringUtil::isEmpty);
    }

    private static String padColumn(String col, int maxWidth) {
        if (!(col != null && col.length() > maxWidth || col == null || col.contains(System.lineSeparator()))) {
            return col;
        }
        String[] parts = col.split(" ");
        int runningWidth = 0;
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            String[] lineSplitParts = part.split(System.lineSeparator());
            if (lineSplitParts.length > 1) {
                for (int i2 = 0; i2 < lineSplitParts.length; ++i2) {
                    String lineSplitPart = lineSplitParts[i2];
                    runningWidth = TableOutput.doAppend(runningWidth, lineSplitPart, maxWidth, result);
                    if (i2 == lineSplitParts.length - 1) continue;
                    runningWidth = TableOutput.fillLineWithSpaces(runningWidth, maxWidth, result);
                }
                continue;
            }
            runningWidth = TableOutput.doAppend(runningWidth, part, maxWidth, result);
        }
        return result.toString();
    }

    private static int doAppend(int runningWidth, String part, int maxWidth, StringBuilder result) {
        int spaceWidth;
        if (runningWidth > maxWidth) {
            runningWidth %= maxWidth;
        }
        int n2 = spaceWidth = runningWidth > 0 ? 1 : 0;
        if (runningWidth + (part.length() + spaceWidth) > maxWidth) {
            runningWidth = TableOutput.fillLineWithSpaces(runningWidth, maxWidth, result);
        }
        if (runningWidth > 0) {
            result.append(" ");
            ++runningWidth;
        }
        result.append(part);
        return runningWidth += part.length();
    }

    private static int fillLineWithSpaces(int runningWidth, int maxWidth, StringBuilder result) {
        for (int i2 = 0; i2 < maxWidth - runningWidth; ++i2) {
            result.append(" ");
        }
        return 0;
    }
}

