/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandFactory;
import liquibase.command.CommandResults;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandStep;
import liquibase.configuration.AbstractMapConfigurationValueProvider;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.CommandExecutionException;
import liquibase.util.StringUtil;

public class CommandScope {
    private final CommandDefinition commandDefinition;
    private final SortedMap<String, Object> argumentValues = new TreeMap<String, Object>();
    private final CommandScopeValueProvider commandScopeValueProvider = new CommandScopeValueProvider();
    private final String completeConfigPrefix;
    private final String shortConfigPrefix;
    private OutputStream outputStream;

    public CommandScope(String ... commandName) throws CommandExecutionException {
        this.setOutput(System.out);
        CommandFactory commandFactory = Scope.getCurrentScope().getSingleton(CommandFactory.class);
        this.commandDefinition = commandFactory.getCommandDefinition(commandName);
        this.completeConfigPrefix = "liquibase.command." + StringUtil.join(Arrays.asList(this.getCommand().getName()), ".");
        this.shortConfigPrefix = "liquibase.command";
    }

    public CommandDefinition getCommand() {
        return this.commandDefinition;
    }

    public String getCompleteConfigPrefix() {
        return this.completeConfigPrefix;
    }

    public CommandScope addArgumentValue(String argument, Object value) {
        this.argumentValues.put(argument, value);
        return this;
    }

    public <T> CommandScope addArgumentValue(CommandArgumentDefinition<T> argument, T value) {
        this.argumentValues.put(argument.getName(), value);
        return this;
    }

    public <T> ConfiguredValue<T> getConfiguredValue(CommandArgumentDefinition<T> argument) {
        ConfigurationDefinition<T> noCommandConfigDef;
        ConfiguredValue<T> noCommandNameProvidedValue;
        ConfigurationDefinition<T> configDef = this.createConfigurationDefinition(argument, true);
        ConfiguredValue<T> providedValue = configDef.getCurrentConfiguredValue();
        if ((!providedValue.found() || providedValue.wasDefaultValueUsed()) && (noCommandNameProvidedValue = (noCommandConfigDef = this.createConfigurationDefinition(argument, false)).getCurrentConfiguredValue()).found() && !noCommandNameProvidedValue.wasDefaultValueUsed()) {
            configDef = noCommandConfigDef;
            providedValue = noCommandNameProvidedValue;
        }
        providedValue.override(this.commandScopeValueProvider.getProvidedValue(configDef.getKey(), argument.getName()));
        return providedValue;
    }

    public <T> T getArgumentValue(CommandArgumentDefinition<T> argument) {
        T value = this.getConfiguredValue(argument).getValue();
        return argument.getValueConverter().convert(value);
    }

    public CommandScope setOutput(OutputStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public CommandResults execute() throws CommandExecutionException {
        CommandResultsBuilder resultsBuilder = new CommandResultsBuilder(this, this.outputStream);
        for (ConfigurationValueProvider configurationValueProvider : Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class).getProviders()) {
            configurationValueProvider.validate(this);
        }
        for (CommandArgumentDefinition commandArgumentDefinition : this.commandDefinition.getArguments().values()) {
            commandArgumentDefinition.validate(this);
        }
        List<CommandStep> pipeline = this.commandDefinition.getPipeline();
        Scope.getCurrentScope().getLog(this.getClass()).fine("Pipeline for command '" + StringUtil.join(this.commandDefinition.getName(), " ") + ": " + StringUtil.join(pipeline, " then ", obj -> obj.getClass().getName()));
        for (CommandStep step : pipeline) {
            step.validate(this);
        }
        try {
            for (CommandStep command : pipeline) {
                command.run(resultsBuilder);
            }
        }
        catch (Exception exception) {
            if (exception instanceof CommandExecutionException) {
                throw (CommandExecutionException)exception;
            }
            throw new CommandExecutionException(exception);
        }
        finally {
            try {
                if (this.outputStream != null) {
                    this.outputStream.flush();
                }
            }
            catch (Exception e) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Error flushing command output stream: " + e.getMessage(), e);
            }
        }
        return resultsBuilder.build();
    }

    private <T> ConfigurationDefinition<T> createConfigurationDefinition(CommandArgumentDefinition<T> argument, boolean includeCommandName) {
        String key = includeCommandName ? this.completeConfigPrefix : this.shortConfigPrefix;
        return new ConfigurationDefinition.Builder(key).define(argument.getName(), argument.getDataType()).setDefaultValue(argument.getDefaultValue()).setDescription(argument.getDescription()).setValueHandler(argument.getValueConverter()).setValueObfuscator(argument.getValueObfuscator()).buildTemporary();
    }

    private class CommandScopeValueProvider
    extends AbstractMapConfigurationValueProvider {
        private CommandScopeValueProvider() {
        }

        @Override
        public int getPrecedence() {
            return -1;
        }

        @Override
        protected Map<?, ?> getMap() {
            return CommandScope.this.argumentValues;
        }

        @Override
        protected String getSourceDescription() {
            return "Command argument";
        }
    }
}

