/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.CatalogAndSchema;
import liquibase.Contexts;
import liquibase.GlobalConfiguration;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.UpdateSummaryEnum;
import liquibase.change.CheckSum;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.ChangeSetStatus;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AfterTagChangeSetFilter;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.CountChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.ExecutedAfterChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.filter.NotRanChangeSetFilter;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.changelog.filter.UpToTagChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeLogSyncListener;
import liquibase.changelog.visitor.ChangeLogSyncVisitor;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.DBDocVisitor;
import liquibase.changelog.visitor.DefaultChangeExecListener;
import liquibase.changelog.visitor.ExpectedChangesVisitor;
import liquibase.changelog.visitor.ListVisitor;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.changelog.visitor.StatusVisitor;
import liquibase.changelog.visitor.UpdateVisitor;
import liquibase.command.CommandResults;
import liquibase.command.CommandScope;
import liquibase.command.core.CalculateChecksumCommandStep;
import liquibase.command.core.DbUrlConnectionCommandStep;
import liquibase.command.core.InternalDropAllCommandStep;
import liquibase.command.core.TagCommandStep;
import liquibase.command.core.TagExistsCommandStep;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.hub.HubConfiguration;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.HubUpdater;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.listener.HubChangeExecListener;
import liquibase.hub.model.Connection;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.Operation;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;
import liquibase.logging.core.BufferedLogService;
import liquibase.logging.core.CompositeLogService;
import liquibase.logging.mdc.MdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsRolledback;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;
import liquibase.util.TableOutput;

public class Liquibase
implements AutoCloseable {
    private static final Logger LOG = Scope.getCurrentScope().getLog(Liquibase.class);
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    public static final String MSG_COULD_NOT_RELEASE_LOCK = coreBundle.getString("could.not.release.lock");
    protected Database database;
    private DatabaseChangeLog databaseChangeLog;
    private String changeLogFile;
    private final ResourceAccessor resourceAccessor;
    private final ChangeLogParameters changeLogParameters;
    private ChangeExecListener changeExecListener;
    private ChangeLogSyncListener changeLogSyncListener;
    private final DefaultChangeExecListener defaultChangeExecListener = new DefaultChangeExecListener(new ChangeExecListener[0]);
    private UUID hubConnectionId;
    private Map<String, Boolean> upToDateFastCheck = new HashMap<String, Boolean>();

    public Liquibase(String changeLogFile, ResourceAccessor resourceAccessor, DatabaseConnection conn) throws LiquibaseException {
        this(changeLogFile, resourceAccessor, DatabaseFactory.getInstance().findCorrectDatabaseImplementation(conn));
    }

    public Liquibase(String changeLogFile, ResourceAccessor resourceAccessor, Database database) {
        if (changeLogFile != null) {
            this.changeLogFile = changeLogFile.replace('\\', '/');
        }
        this.resourceAccessor = resourceAccessor;
        this.changeLogParameters = new ChangeLogParameters(database);
        this.database = database;
    }

    public Liquibase(DatabaseChangeLog changeLog, ResourceAccessor resourceAccessor, Database database) {
        this.databaseChangeLog = changeLog;
        if (changeLog != null) {
            this.changeLogFile = changeLog.getPhysicalFilePath();
        }
        if (this.changeLogFile != null) {
            this.changeLogFile = this.changeLogFile.replace('\\', '/');
        }
        this.resourceAccessor = resourceAccessor;
        this.database = database;
        this.changeLogParameters = new ChangeLogParameters(database);
    }

    public UUID getHubConnectionId() {
        return this.hubConnectionId;
    }

    public void setHubConnectionId(UUID hubConnectionId) {
        this.hubConnectionId = hubConnectionId;
    }

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public Logger getLog() {
        return LOG;
    }

    public ChangeLogParameters getChangeLogParameters() {
        return this.changeLogParameters;
    }

    public Database getDatabase() {
        return this.database;
    }

    public ResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    public void update() throws LiquibaseException {
        this.update(new Contexts());
    }

    public void update(String contexts) throws LiquibaseException {
        this.update(new Contexts(contexts));
    }

    public void update(Contexts contexts) throws LiquibaseException {
        this.update(contexts, new LabelExpression());
    }

    public void update(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.update(contexts, labelExpression, true);
    }

    public void update(Contexts contexts, LabelExpression labelExpression, boolean checkLiquibaseTables) throws LiquibaseException {
        this.runInScope(() -> {
            if (this.isUpToDateFastCheck(contexts, labelExpression)) {
                Scope.getCurrentScope().getUI().sendMessage("Database is up to date, no changesets to execute");
                return;
            }
            LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
            lockService.waitForLock();
            Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", this.database.getConnection().getURL(), false);
            this.changeLogParameters.setContexts(contexts);
            this.changeLogParameters.setLabels(labelExpression);
            this.addCommandFiltersMdc(labelExpression, contexts);
            Operation updateOperation = null;
            BufferedLogService bufferLog = new BufferedLogService();
            HubUpdater hubUpdater = null;
            try {
                DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
                if (checkLiquibaseTables) {
                    this.checkLiquibaseTables(true, changeLog, contexts, labelExpression);
                }
                changeLog.validate(this.database, contexts, labelExpression);
                hubUpdater = new HubUpdater(new Date(), changeLog, this.database);
                hubUpdater.register(this.changeLogFile);
                this.generateDeploymentId();
                ChangeLogIterator changeLogIterator = this.getStandardChangelogIterator(contexts, labelExpression, changeLog);
                StatusVisitor statusVisitor = new StatusVisitor(this.database);
                ChangeLogIterator shouldRunIterator = this.getStandardChangelogIterator(contexts, labelExpression, true, changeLog);
                shouldRunIterator.run(statusVisitor, new RuntimeEnvironment(this.database, contexts, labelExpression));
                Connection connection = this.getConnection(changeLog);
                if (connection != null) {
                    updateOperation = hubUpdater.preUpdateHub("UPDATE", "update", connection, this.changeLogFile, contexts, labelExpression, changeLogIterator);
                }
                HubChangeExecListener hubChangeExecListener = new HubChangeExecListener(updateOperation, this.changeExecListener);
                ChangeLogIterator runChangeLogIterator = this.getStandardChangelogIterator(contexts, labelExpression, changeLog);
                CompositeLogService compositeLogService = new CompositeLogService(true, bufferLog);
                Scope.child(Scope.Attr.logService.name(), (Object)compositeLogService, () -> {
                    UpdateVisitor updateVisitor = this.createUpdateVisitor(connection != null ? hubChangeExecListener : this.changeExecListener);
                    runChangeLogIterator.run(updateVisitor, new RuntimeEnvironment(this.database, contexts, labelExpression));
                });
                this.showUpdateSummary(changeLog, statusVisitor);
                hubUpdater.postUpdateHub(updateOperation, bufferLog);
                this.logDeploymentOutcomeMdc(true);
            }
            catch (Throwable e) {
                this.logDeploymentOutcomeMdc(false);
                if (hubUpdater != null) {
                    hubUpdater.postUpdateHubExceptionHandling(updateOperation, bufferLog, e.getMessage());
                }
                throw e;
            }
            finally {
                this.database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
                try {
                    lockService.releaseLock();
                }
                catch (LockException e) {
                    LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e);
                }
                this.resetServices();
                this.setChangeExecListener(null);
            }
        });
    }

    private void showUpdateSummary(DatabaseChangeLog changeLog, StatusVisitor statusVisitor) throws LiquibaseException, IOException {
        UpdateSummaryEnum showSummary;
        String showSummaryString = (String)((Object)Scope.getCurrentScope().get("showSummary", String.class));
        UpdateSummaryEnum updateSummaryEnum = showSummary = showSummaryString != null ? UpdateSummaryEnum.valueOf(showSummaryString) : UpdateSummaryEnum.OFF;
        if (showSummary == UpdateSummaryEnum.OFF) {
            return;
        }
        List<ChangeSetStatus> denied = statusVisitor.getChangeSetsToSkip();
        List<ChangeSet> skippedChangeSets = changeLog.getSkippedChangeSets();
        List<ChangeSetStatus> filterDenied = denied.stream().filter(status -> status.getFilterResults().stream().anyMatch(result -> result.getFilter() != ShouldRunChangeSetFilter.class && result.getFilter() != UpToTagChangeSetFilter.class && result.getFilter() != CountChangeSetFilter.class)).collect(Collectors.toList());
        this.showSummary(changeLog, statusVisitor, skippedChangeSets, filterDenied);
        if (showSummary == UpdateSummaryEnum.SUMMARY || skippedChangeSets.isEmpty() && denied.isEmpty()) {
            return;
        }
        this.showDetailTable(skippedChangeSets, filterDenied);
    }

    private void showDetailTable(List<ChangeSet> skippedChangeSets, List<ChangeSetStatus> filterDenied) throws IOException, LiquibaseException {
        ArrayList<String> columnHeaders = new ArrayList<String>();
        columnHeaders.add("Changeset Info");
        columnHeaders.add("Reason Skipped");
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        table.add(columnHeaders);
        ArrayList<ChangeSetStatus> finalList = new ArrayList<ChangeSetStatus>(filterDenied);
        skippedChangeSets.forEach(skippedChangeSet -> {
            String dbmsList = String.format("'%s'", StringUtil.join(skippedChangeSet.getDbmsSet(), ", "));
            String mismatchMessage = String.format("mismatched DBMS value of %s", dbmsList);
            ChangeSetStatus changeSetStatus = new ChangeSetStatus((ChangeSet)skippedChangeSet);
            ChangeSetFilterResult filterResult = new ChangeSetFilterResult(false, mismatchMessage, null);
            changeSetStatus.setFilterResults(Collections.singleton(filterResult));
            finalList.add(changeSetStatus);
        });
        finalList.sort(new Comparator<ChangeSetStatus>(){

            @Override
            public int compare(ChangeSetStatus o1, ChangeSetStatus o2) {
                ChangeSet c1 = o1.getChangeSet();
                ChangeSet c2 = o2.getChangeSet();
                int order1 = Liquibase.this.determineOrderInChangelog(c1);
                int order2 = Liquibase.this.determineOrderInChangelog(c2);
                if (order1 == -1 || order2 == -1) {
                    return -1;
                }
                return Integer.compare(order1, order2);
            }
        });
        for (ChangeSetStatus st : finalList) {
            st.getFilterResults().forEach(consumer -> {
                String skippedMessage = String.format("   '%s' : %s", st.getChangeSet().toString(), consumer.getMessage());
                Scope.getCurrentScope().getLog(this.getClass()).info(skippedMessage);
                ArrayList<String> outputRow = new ArrayList<String>();
                outputRow.add(st.getChangeSet().toString());
                outputRow.add(consumer.getMessage());
                table.add(outputRow);
            });
        }
        ArrayList<Integer> widths = new ArrayList<Integer>();
        widths.add(60);
        widths.add(40);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Writer writer = Liquibase.createOutputWriter(outputStream);
        TableOutput.formatOutput(table, widths, true, writer);
        String outputTableString = ((Object)outputStream).toString();
        Scope.getCurrentScope().getUI().sendMessage(outputTableString);
    }

    private int determineOrderInChangelog(ChangeSet changeSetToMatch) {
        DatabaseChangeLog changeLog = changeSetToMatch.getChangeLog();
        int order = 0;
        for (ChangeSet changeSet : changeLog.getChangeSets()) {
            if (changeSet == changeSetToMatch) {
                return order;
            }
            ++order;
        }
        return -1;
    }

    private void showSummary(DatabaseChangeLog changeLog, StatusVisitor statusVisitor, List<ChangeSet> skippedChangeSets, List<ChangeSetStatus> filterDenied) {
        Scope.getCurrentScope().getUI().sendMessage("");
        int totalInChangelog = changeLog.getChangeSets().size() + skippedChangeSets.size();
        int skipped = skippedChangeSets.size();
        int filtered = filterDenied.size();
        int totalAccepted = statusVisitor.getChangeSetsToRun().size();
        int totalPreviouslyRun = totalInChangelog - filtered - skipped - totalAccepted;
        String message = "UPDATE SUMMARY";
        Scope.getCurrentScope().getLog(this.getClass()).info(message);
        Scope.getCurrentScope().getUI().sendMessage(message);
        message = String.format("Run:                     %6d", totalAccepted);
        Scope.getCurrentScope().getLog(this.getClass()).info(message);
        Scope.getCurrentScope().getUI().sendMessage(message);
        message = String.format("Previously run:          %6d", totalPreviouslyRun);
        Scope.getCurrentScope().getLog(this.getClass()).info(message);
        Scope.getCurrentScope().getUI().sendMessage(message);
        message = String.format("DBMS mismatch:           %6d", skipped);
        Scope.getCurrentScope().getLog(this.getClass()).info(message);
        Scope.getCurrentScope().getUI().sendMessage(message);
        message = String.format("Not in filter:           %6d", filtered);
        Scope.getCurrentScope().getLog(this.getClass()).info(message);
        Scope.getCurrentScope().getUI().sendMessage(message);
        message = "-------------------------------";
        Scope.getCurrentScope().getLog(this.getClass()).info(message);
        Scope.getCurrentScope().getUI().sendMessage(message);
        message = String.format("Total change sets:       %6d%n", totalInChangelog);
        Scope.getCurrentScope().getLog(this.getClass()).info(message);
        Scope.getCurrentScope().getUI().sendMessage(message);
    }

    private static Writer createOutputWriter(OutputStream outputStream) throws IOException {
        String charsetName = GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        return new OutputStreamWriter(outputStream, charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUpToDateFastCheck(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        String cacheKey = contexts + "/" + labelExpression;
        if (!this.upToDateFastCheck.containsKey(cacheKey)) {
            try {
                if (this.listUnrunChangeSets(contexts, labelExpression, false).isEmpty()) {
                    LOG.fine("Fast check found no un-run changesets");
                    this.upToDateFastCheck.put(cacheKey, true);
                } else {
                    this.upToDateFastCheck.put(cacheKey, false);
                }
            }
            catch (DatabaseException e) {
                LOG.info("Error querying Liquibase tables, disabling fast check for this execution. Reason: " + e.getMessage());
                this.upToDateFastCheck.put(cacheKey, false);
            }
            finally {
                ChangeLogHistoryService changeLogService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
                changeLogService.reset();
            }
        }
        return this.upToDateFastCheck.get(cacheKey);
    }

    public Connection getConnection(DatabaseChangeLog changeLog) throws LiquibaseHubException {
        Connection connection;
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        if (executor instanceof LoggingExecutor) {
            return null;
        }
        HubUpdater hubUpdater = new HubUpdater(new Date(), changeLog, this.database);
        String changeLogId = changeLog.getChangeLogId();
        if (hubUpdater.hubIsNotAvailable(changeLogId)) {
            if (StringUtil.isNotEmpty(HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValue()) && changeLogId == null) {
                String message = "An API key was configured, but no changelog ID exists.\nNo operations will be reported. Register this changelog with Liquibase Hub to generate free deployment reports.\nLearn more at https://hub.liquibase.com.";
                Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
                Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            }
            return null;
        }
        if (StringUtil.isEmpty(HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValue()) && changeLogId != null) {
            String message = "The changelog ID '" + changeLogId + "' was found, but no API Key exists.\nNo operations will be reported. Simply add a liquibase.hub.apiKey setting to generate free deployment reports.\nLearn more at https://hub.liquibase.com.";
            Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
            Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            return null;
        }
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        if (this.getHubConnectionId() == null) {
            HubChangeLog hubChangeLog = hubService.getHubChangeLog(UUID.fromString(changeLogId), "*");
            if (hubChangeLog == null) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Retrieving Hub Change Log failed for Changelog ID: " + changeLogId);
                return null;
            }
            if (hubChangeLog.isDeleted()) {
                String message = "\nThe operation did not complete and will not be reported to Hub because the\nregistered changelog has been deleted by someone in your organization.\nLearn more at http://hub.liquibase.com.";
                throw new LiquibaseHubException(message);
            }
            Connection exampleConnection = new Connection();
            exampleConnection.setProject(hubChangeLog.getProject());
            exampleConnection.setJdbcUrl(this.database.getConnection().getURL());
            connection = hubService.getConnection(exampleConnection, true);
            this.setHubConnectionId(connection.getId());
        } else {
            connection = hubService.getConnection(new Connection().setId(this.getHubConnectionId()), true);
        }
        return connection;
    }

    public DatabaseChangeLog getDatabaseChangeLog() throws LiquibaseException {
        return this.getDatabaseChangeLog(false);
    }

    private DatabaseChangeLog getDatabaseChangeLog(boolean shouldWarnOnMismatchedXsdVersion) throws LiquibaseException {
        if (this.databaseChangeLog == null && this.changeLogFile != null) {
            Scope.getCurrentScope().addMdcValue("changelogFile", this.changeLogFile);
            ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser(this.changeLogFile, this.resourceAccessor);
            if (parser instanceof XMLChangeLogSAXParser) {
                ((XMLChangeLogSAXParser)parser).setShouldWarnOnMismatchedXsdVersion(shouldWarnOnMismatchedXsdVersion);
            }
            this.databaseChangeLog = parser.parse(this.changeLogFile, this.changeLogParameters, this.resourceAccessor);
        }
        return this.databaseChangeLog;
    }

    protected UpdateVisitor createUpdateVisitor() {
        return new UpdateVisitor(this.database, this.changeExecListener);
    }

    protected UpdateVisitor createUpdateVisitor(ChangeExecListener listener) {
        return new UpdateVisitor(this.database, listener);
    }

    protected RollbackVisitor createRollbackVisitor() {
        return new RollbackVisitor(this.database, this.changeExecListener);
    }

    protected RollbackVisitor createRollbackVisitor(List<ChangesetsRolledback.ChangeSet> processedChangesets) {
        return new RollbackVisitor(this.database, this.changeExecListener, processedChangesets);
    }

    protected ChangeLogIterator getStandardChangelogIterator(Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog changeLog) throws DatabaseException {
        return this.getStandardChangelogIterator(contexts, labelExpression, false, changeLog);
    }

    protected ChangeLogIterator getStandardChangelogIterator(Contexts contexts, LabelExpression labelExpression, boolean collectAllReasons, DatabaseChangeLog changeLog) throws DatabaseException {
        return new ChangeLogIterator(changeLog, collectAllReasons, new ShouldRunChangeSetFilter(this.database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(this.database), new IgnoreChangeSetFilter());
    }

    protected ChangeLogIterator buildChangeLogIterator(String tag, DatabaseChangeLog changeLog, Contexts contexts, LabelExpression labelExpression) throws DatabaseException {
        if (tag == null) {
            return new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(this.database));
        }
        List<RanChangeSet> ranChangeSetList = this.database.getRanChangeSetList();
        return new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(this.database), new UpToTagChangeSetFilter(tag, ranChangeSetList));
    }

    public void update(String contexts, Writer output) throws LiquibaseException {
        this.update(new Contexts(contexts), output);
    }

    public void update(Contexts contexts, Writer output) throws LiquibaseException {
        this.update(contexts, new LabelExpression(), output);
    }

    public void update(Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.update(contexts, labelExpression, output, true);
    }

    public void update(final Contexts contexts, final LabelExpression labelExpression, final Writer output, final boolean checkLiquibaseTables) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                Executor oldTemplate = Liquibase.this.getAndReplaceJdbcExecutor(output);
                Liquibase.this.outputHeader("Update Database Script");
                if (Liquibase.this.isUpToDateFastCheck(contexts, labelExpression)) {
                    Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("logging", Liquibase.this.database).comment("Database is up to date, no changesets to execute");
                } else {
                    LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                    lockService.waitForLock();
                    Liquibase.this.update(contexts, labelExpression, checkLiquibaseTables);
                }
                Liquibase.this.flushOutputWriter(output);
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", Liquibase.this.database, oldTemplate);
            }
        });
    }

    public void update(int changesToApply, String contexts) throws LiquibaseException {
        this.update(changesToApply, new Contexts(contexts), new LabelExpression());
    }

    public void update(final int changesToApply, final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.addCommandFiltersMdc(labelExpression, contexts);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", Liquibase.this.database.getConnection().getURL());
                Operation updateOperation = null;
                BufferedLogService bufferLog = new BufferedLogService();
                DatabaseChangeLog changeLog = null;
                HubUpdater hubUpdater = null;
                try {
                    changeLog = Liquibase.this.getDatabaseChangeLog();
                    Liquibase.this.checkLiquibaseTables(true, changeLog, contexts, labelExpression);
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    hubUpdater = new HubUpdater(new Date(), changeLog, Liquibase.this.database);
                    hubUpdater.register(Liquibase.this.changeLogFile);
                    Liquibase.this.generateDeploymentId();
                    ChangeLogIterator listLogIterator = new ChangeLogIterator(changeLog, new ShouldRunChangeSetFilter(Liquibase.this.database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(changesToApply));
                    Connection connection = Liquibase.this.getConnection(changeLog);
                    if (connection != null) {
                        updateOperation = hubUpdater.preUpdateHub("UPDATE", "update-count", connection, Liquibase.this.changeLogFile, contexts, labelExpression, listLogIterator);
                    }
                    if (connection != null) {
                        Liquibase.this.changeExecListener = new HubChangeExecListener(updateOperation, Liquibase.this.changeExecListener);
                    }
                    StatusVisitor statusVisitor = new StatusVisitor(Liquibase.this.database);
                    ChangeLogIterator shouldRunIterator = new ChangeLogIterator(changeLog, true, new ShouldRunChangeSetFilter(Liquibase.this.database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(changesToApply));
                    shouldRunIterator.run(statusVisitor, new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
                    ChangeLogIterator runChangeLogIterator = new ChangeLogIterator(changeLog, new ShouldRunChangeSetFilter(Liquibase.this.database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(changesToApply));
                    CompositeLogService compositeLogService = new CompositeLogService(true, bufferLog);
                    Scope.child(Scope.Attr.logService.name(), (Object)compositeLogService, () -> runChangeLogIterator.run(Liquibase.this.createUpdateVisitor(), new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression)));
                    Liquibase.this.showUpdateSummary(changeLog, statusVisitor);
                    hubUpdater.postUpdateHub(updateOperation, bufferLog);
                    Liquibase.this.logDeploymentOutcomeMdc(true);
                }
                catch (Throwable e) {
                    Liquibase.this.logDeploymentOutcomeMdc(false);
                    if (hubUpdater != null) {
                        hubUpdater.postUpdateHubExceptionHandling(updateOperation, bufferLog, e.getMessage());
                    }
                    throw e;
                }
                finally {
                    Liquibase.this.database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e);
                    }
                    Liquibase.this.resetServices();
                    Liquibase.this.setChangeExecListener(null);
                }
            }
        });
    }

    public void update(String tag, String contexts) throws LiquibaseException {
        this.update(tag, new Contexts(contexts), new LabelExpression());
    }

    public void update(String tag, Contexts contexts) throws LiquibaseException {
        this.update(tag, contexts, new LabelExpression());
    }

    public void update(final String tag, final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        if (tag == null) {
            this.update(contexts, labelExpression);
            return;
        }
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.addCommandFiltersMdc(labelExpression, contexts);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", Liquibase.this.database.getConnection().getURL());
                HubUpdater hubUpdater = null;
                Operation updateOperation = null;
                BufferedLogService bufferLog = new BufferedLogService();
                DatabaseChangeLog changeLog = null;
                try {
                    changeLog = Liquibase.this.getDatabaseChangeLog();
                    Liquibase.this.checkLiquibaseTables(true, changeLog, contexts, labelExpression);
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    hubUpdater = new HubUpdater(new Date(), changeLog, Liquibase.this.database);
                    hubUpdater.register(Liquibase.this.changeLogFile);
                    Liquibase.this.generateDeploymentId();
                    List<RanChangeSet> ranChangeSetList = Liquibase.this.database.getRanChangeSetList();
                    ChangeLogIterator listLogIterator = new ChangeLogIterator(changeLog, new ShouldRunChangeSetFilter(Liquibase.this.database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new UpToTagChangeSetFilter(tag, ranChangeSetList));
                    Connection connection = Liquibase.this.getConnection(changeLog);
                    if (connection != null) {
                        updateOperation = hubUpdater.preUpdateHub("UPDATE", "update-to-tag", connection, Liquibase.this.changeLogFile, contexts, labelExpression, listLogIterator);
                    }
                    if (connection != null) {
                        Liquibase.this.changeExecListener = new HubChangeExecListener(updateOperation, Liquibase.this.changeExecListener);
                    }
                    StatusVisitor statusVisitor = new StatusVisitor(Liquibase.this.database);
                    ChangeLogIterator shouldRunIterator = new ChangeLogIterator(changeLog, true, new ShouldRunChangeSetFilter(Liquibase.this.database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new UpToTagChangeSetFilter(tag, ranChangeSetList));
                    shouldRunIterator.run(statusVisitor, new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
                    ChangeLogIterator runChangeLogIterator = new ChangeLogIterator(changeLog, new ShouldRunChangeSetFilter(Liquibase.this.database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new UpToTagChangeSetFilter(tag, ranChangeSetList));
                    CompositeLogService compositeLogService = new CompositeLogService(true, bufferLog);
                    Scope.child(Scope.Attr.logService.name(), (Object)compositeLogService, () -> runChangeLogIterator.run(Liquibase.this.createUpdateVisitor(), new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression)));
                    Liquibase.this.showUpdateSummary(changeLog, statusVisitor);
                    hubUpdater.postUpdateHub(updateOperation, bufferLog);
                    Liquibase.this.logDeploymentOutcomeMdc(true);
                }
                catch (Throwable e) {
                    Liquibase.this.logDeploymentOutcomeMdc(false);
                    if (hubUpdater != null) {
                        hubUpdater.postUpdateHubExceptionHandling(updateOperation, bufferLog, e.getMessage());
                    }
                    throw e;
                }
                finally {
                    Liquibase.this.database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e);
                    }
                    Liquibase.this.resetServices();
                    Liquibase.this.setChangeExecListener(null);
                }
            }
        });
    }

    public void update(int changesToApply, String contexts, Writer output) throws LiquibaseException {
        this.update(changesToApply, new Contexts(contexts), new LabelExpression(), output);
    }

    public void update(final int changesToApply, final Contexts contexts, final LabelExpression labelExpression, final Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                Executor oldTemplate = Liquibase.this.getAndReplaceJdbcExecutor(output);
                Liquibase.this.outputHeader("Update " + changesToApply + " Changesets Database Script");
                Liquibase.this.update(changesToApply, contexts, labelExpression);
                Liquibase.this.flushOutputWriter(output);
                Liquibase.this.resetServices();
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", Liquibase.this.database, oldTemplate);
            }
        });
    }

    public void update(String tag, String contexts, Writer output) throws LiquibaseException {
        this.update(tag, new Contexts(contexts), new LabelExpression(), output);
    }

    public void update(String tag, Contexts contexts, Writer output) throws LiquibaseException {
        this.update(tag, contexts, new LabelExpression(), output);
    }

    public void update(final String tag, final Contexts contexts, final LabelExpression labelExpression, final Writer output) throws LiquibaseException {
        if (tag == null) {
            this.update(contexts, labelExpression, output);
            return;
        }
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                Executor oldTemplate = Liquibase.this.getAndReplaceJdbcExecutor(output);
                Liquibase.this.outputHeader("Update to '" + tag + "' Database Script");
                Liquibase.this.update(tag, contexts, labelExpression);
                Liquibase.this.flushOutputWriter(output);
                Liquibase.this.resetServices();
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", Liquibase.this.database, oldTemplate);
            }
        });
    }

    private void addCommandFiltersMdc(LabelExpression labelExpression, Contexts contexts) {
        String labelFilterMdc = labelExpression != null && labelExpression.getOriginalString() != null ? labelExpression.getOriginalString() : "";
        String contextFilterMdc = contexts != null ? contexts.toString() : "";
        Scope.getCurrentScope().addMdcValue("commandLabelFilter", labelFilterMdc);
        Scope.getCurrentScope().addMdcValue("commandContextFilter", contextFilterMdc);
    }

    private void generateDeploymentId() {
        ChangeLogHistoryService changelogService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
        changelogService.generateDeploymentId();
        Scope.getCurrentScope().addMdcValue("deploymentId", changelogService.getDeploymentId());
    }

    private void logDeploymentOutcomeMdc(boolean success) throws IOException {
        int deployedChangeSetCount = this.getDefaultChangeExecListener().getDeployedChangeSets().size();
        String successLog = "Update command completed successfully.";
        String failureLog = "Update command encountered an exception.";
        try (MdcObject deploymentOutcomeMdc = Scope.getCurrentScope().addMdcValue("deploymentOutcome", success ? "success" : "fail");
             MdcObject deploymentOutcomeCountMdc = Scope.getCurrentScope().addMdcValue("deploymentOutcomeCount", String.valueOf(deployedChangeSetCount));){
            Scope.getCurrentScope().getLog(this.getClass()).info(success ? successLog : failureLog);
        }
    }

    public void outputHeader(String message) throws DatabaseException {
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("logging", this.database);
        executor.comment("*********************************************************************");
        executor.comment(message);
        executor.comment("*********************************************************************");
        executor.comment("Change Log: " + this.changeLogFile);
        executor.comment("Ran at: " + DateFormat.getDateTimeInstance(3, 3).format(new Date()));
        DatabaseConnection connection = this.getDatabase().getConnection();
        if (connection != null) {
            executor.comment("Against: " + connection.getConnectionUserName() + "@" + connection.getURL());
        }
        executor.comment("Liquibase version: " + LiquibaseUtil.getBuildVersionInfo());
        executor.comment("*********************************************************************" + StreamUtil.getLineSeparator());
        if (this.database instanceof MSSQLDatabase && this.database.getDefaultCatalogName() != null) {
            executor.execute(new RawSqlStatement("USE " + this.database.escapeObjectName(this.database.getDefaultCatalogName(), Catalog.class) + ";"));
        }
    }

    public void rollback(int changesToRollback, String contexts, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts, output);
    }

    public void rollback(int changesToRollback, Contexts contexts, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts, output);
    }

    public void rollback(int changesToRollback, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts, labelExpression, output);
    }

    public void rollback(int changesToRollback, String rollbackScript, String contexts, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, rollbackScript, new Contexts(contexts), output);
    }

    public void rollback(int changesToRollback, String rollbackScript, Contexts contexts, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, rollbackScript, contexts, new LabelExpression(), output);
    }

    public void rollback(final int changesToRollback, final String rollbackScript, final Contexts contexts, final LabelExpression labelExpression, final Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                Executor oldTemplate = Liquibase.this.getAndReplaceJdbcExecutor(output);
                Liquibase.this.outputHeader("Rollback " + changesToRollback + " Change(s) Script");
                Liquibase.this.rollback(changesToRollback, rollbackScript, contexts, labelExpression);
                Liquibase.this.flushOutputWriter(output);
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", Liquibase.this.database, oldTemplate);
                Liquibase.this.resetServices();
            }
        });
    }

    public void rollback(int changesToRollback, String contexts) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts);
    }

    public void rollback(int changesToRollback, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts, labelExpression);
    }

    public void rollback(int changesToRollback, String rollbackScript, String contexts) throws LiquibaseException {
        this.rollback(changesToRollback, rollbackScript, new Contexts(contexts), new LabelExpression());
    }

    public void rollback(final int changesToRollback, final String rollbackScript, final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.addCommandFiltersMdc(labelExpression, contexts);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                Scope.getCurrentScope().addMdcValue("rollbackCount", String.valueOf(changesToRollback));
                Scope.getCurrentScope().addMdcValue("rollbackScript", rollbackScript);
                Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", Liquibase.this.database.getConnection().getURL());
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                Operation rollbackOperation = null;
                String operationCommand = "rollback-count";
                BufferedLogService bufferLog = new BufferedLogService();
                DatabaseChangeLog changeLog = null;
                Date startTime = new Date();
                HubUpdater hubUpdater = null;
                try {
                    changeLog = Liquibase.this.getDatabaseChangeLog();
                    Liquibase.this.checkLiquibaseTables(false, changeLog, contexts, labelExpression);
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    hubUpdater = new HubUpdater(startTime, changeLog, Liquibase.this.database);
                    hubUpdater.register(Liquibase.this.changeLogFile);
                    ChangeLogIterator listLogIterator = new ChangeLogIterator(Liquibase.this.database.getRanChangeSetList(), changeLog, new AlreadyRanChangeSetFilter(Liquibase.this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(changesToRollback));
                    Connection connection = Liquibase.this.getConnection(changeLog);
                    if (connection != null) {
                        rollbackOperation = hubUpdater.preUpdateHub("ROLLBACK", "rollback-count", connection, Liquibase.this.changeLogFile, contexts, labelExpression, listLogIterator);
                    }
                    if (connection != null) {
                        Liquibase.this.changeExecListener = new HubChangeExecListener(rollbackOperation, Liquibase.this.changeExecListener);
                    }
                    ChangeLogIterator logIterator = new ChangeLogIterator(Liquibase.this.database.getRanChangeSetList(), changeLog, new AlreadyRanChangeSetFilter(Liquibase.this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(changesToRollback));
                    Liquibase.this.doRollback(bufferLog, rollbackScript, logIterator, contexts, labelExpression, hubUpdater, rollbackOperation);
                }
                catch (Throwable t) {
                    Liquibase.this.handleRollbackException(t, hubUpdater, rollbackOperation, bufferLog, "rollback-count");
                    throw t;
                }
                finally {
                    Liquibase.this.handleRollbackFinally(lockService);
                }
            }
        });
    }

    private void doRollback(BufferedLogService bufferLog, String rollbackScript, ChangeLogIterator logIterator, Contexts contexts, LabelExpression labelExpression, HubUpdater hubUpdater, Operation rollbackOperation) throws Exception {
        CompositeLogService compositeLogService = new CompositeLogService(true, bufferLog);
        if (rollbackScript == null) {
            ArrayList<ChangesetsRolledback.ChangeSet> processedChangesets = new ArrayList<ChangesetsRolledback.ChangeSet>();
            Scope.child(Scope.Attr.logService.name(), (Object)compositeLogService, () -> logIterator.run(this.createRollbackVisitor(processedChangesets), new RuntimeEnvironment(this.database, contexts, labelExpression)));
            Scope.getCurrentScope().addMdcValue("changesetsRolledback", new ChangesetsRolledback(processedChangesets), false);
        } else {
            List<ChangeSet> changeSets = this.determineRollbacks(logIterator, contexts, labelExpression);
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put(Scope.Attr.logService.name(), compositeLogService);
            values.put(BufferedLogService.class.getName(), bufferLog);
            Scope.child(values, () -> this.executeRollbackScript(rollbackScript, changeSets, contexts, labelExpression));
            this.removeRunStatus(changeSets, contexts, labelExpression);
            Scope.getCurrentScope().addMdcValue("changesetsRolledback", ChangesetsRolledback.fromChangesetList(changeSets));
        }
        hubUpdater.postUpdateHub(rollbackOperation, bufferLog);
        try (MdcObject deploymentOutcomeMdc = Scope.getCurrentScope().getMdcManager().put("deploymentOutcome", "success");){
            Scope.getCurrentScope().getLog(this.getClass()).info("Rollback command completed successfully.");
        }
    }

    private List<ChangeSet> determineRollbacks(ChangeLogIterator logIterator, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        final ArrayList<ChangeSet> changeSetsToRollback = new ArrayList<ChangeSet>();
        logIterator.run(new ChangeSetVisitor(){

            @Override
            public ChangeSetVisitor.Direction getDirection() {
                return ChangeSetVisitor.Direction.REVERSE;
            }

            @Override
            public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
                changeSetsToRollback.add(changeSet);
            }
        }, new RuntimeEnvironment(this.database, contexts, labelExpression));
        return changeSetsToRollback;
    }

    protected void removeRunStatus(List<ChangeSet> changeSets, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        for (ChangeSet changeSet : changeSets) {
            this.database.removeRanStatus(changeSet);
            this.database.commit();
        }
    }

    protected void executeRollbackScript(String rollbackScript, List<ChangeSet> changeSets, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        String rollbackScriptContents;
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        try {
            Resource resource = this.resourceAccessor.get(rollbackScript);
            if (resource == null) {
                throw new LiquibaseException("WARNING: The rollback script '" + rollbackScript + "' was not located.  Please check your parameters. No rollback was performed");
            }
            try (InputStream stream = resource.openInputStream();){
                rollbackScriptContents = StreamUtil.readStreamAsString(stream);
            }
        }
        catch (IOException e) {
            throw new LiquibaseException("Error reading rollbackScript " + executor + ": " + e.getMessage());
        }
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        DatabaseChangeLog changelog = this.getDatabaseChangeLog();
        rollbackScriptContents = this.changeLogParameters.expandExpressions(rollbackScriptContents, changelog);
        RawSQLChange rollbackChange = this.buildRawSQLChange(rollbackScriptContents);
        try {
            ((HubChangeExecListener)this.changeExecListener).setRollbackScriptContents(rollbackScriptContents);
            this.sendRollbackMessages(changeSets, changelog, RollbackMessageType.WILL_ROLLBACK, contexts, labelExpression, null);
            executor.execute(rollbackChange);
            this.sendRollbackMessages(changeSets, changelog, RollbackMessageType.ROLLED_BACK, contexts, labelExpression, null);
        }
        catch (DatabaseException e) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(e.getMessage());
            LOG.severe("Error executing rollback script: " + e.getMessage());
            if (this.changeExecListener != null) {
                this.sendRollbackMessages(changeSets, changelog, RollbackMessageType.ROLLBACK_FAILED, contexts, labelExpression, e);
            }
            throw new DatabaseException("Error executing rollback script", e);
        }
        this.database.commit();
    }

    private void sendRollbackMessages(List<ChangeSet> changeSets, DatabaseChangeLog changelog, RollbackMessageType messageType, Contexts contexts, LabelExpression labelExpression, Exception exception) throws LiquibaseException {
        for (ChangeSet changeSet : changeSets) {
            String message;
            if (messageType == RollbackMessageType.WILL_ROLLBACK) {
                this.changeExecListener.willRollback(changeSet, this.databaseChangeLog, this.database);
                continue;
            }
            if (messageType == RollbackMessageType.ROLLED_BACK) {
                message = "Rolled Back Changeset:" + changeSet.toString(false);
                Scope.getCurrentScope().getUI().sendMessage(message);
                LOG.info(message);
                this.changeExecListener.rolledBack(changeSet, this.databaseChangeLog, this.database);
                continue;
            }
            if (messageType != RollbackMessageType.ROLLBACK_FAILED) continue;
            message = "Failed rolling back Changeset:" + changeSet.toString(false);
            Scope.getCurrentScope().getUI().sendMessage(message);
            this.changeExecListener.rollbackFailed(changeSet, this.databaseChangeLog, this.database, exception);
        }
    }

    protected RawSQLChange buildRawSQLChange(String rollbackScriptContents) {
        RawSQLChange rollbackChange = new RawSQLChange(rollbackScriptContents);
        rollbackChange.setSplitStatements(true);
        rollbackChange.setStripComments(true);
        return rollbackChange;
    }

    public void rollback(String tagToRollBackTo, String contexts, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts, output);
    }

    public void rollback(String tagToRollBackTo, Contexts contexts, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts, output);
    }

    public void rollback(String tagToRollBackTo, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts, labelExpression, output);
    }

    public void rollback(String tagToRollBackTo, String rollbackScript, String contexts, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, rollbackScript, new Contexts(contexts), output);
    }

    public void rollback(String tagToRollBackTo, String rollbackScript, Contexts contexts, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, rollbackScript, contexts, new LabelExpression(), output);
    }

    public void rollback(String tagToRollBackTo, String rollbackScript, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        Executor oldTemplate = this.getAndReplaceJdbcExecutor(output);
        this.outputHeader("Rollback to '" + tagToRollBackTo + "' Script");
        this.rollback(tagToRollBackTo, contexts, labelExpression);
        this.flushOutputWriter(output);
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, oldTemplate);
        this.resetServices();
    }

    public void rollback(String tagToRollBackTo, String contexts) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts);
    }

    public void rollback(String tagToRollBackTo, Contexts contexts) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts);
    }

    public void rollback(String tagToRollBackTo, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts, labelExpression);
    }

    public void rollback(String tagToRollBackTo, String rollbackScript, String contexts) throws LiquibaseException {
        this.rollback(tagToRollBackTo, rollbackScript, new Contexts(contexts));
    }

    public void rollback(String tagToRollBackTo, String rollbackScript, Contexts contexts) throws LiquibaseException {
        this.rollback(tagToRollBackTo, rollbackScript, contexts, new LabelExpression());
    }

    public void rollback(final String tagToRollBackTo, final String rollbackScript, final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.addCommandFiltersMdc(labelExpression, contexts);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                Scope.getCurrentScope().addMdcValue("rollbackToTag", tagToRollBackTo);
                Scope.getCurrentScope().addMdcValue("rollbackScript", rollbackScript);
                Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", Liquibase.this.database.getConnection().getURL());
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                Operation rollbackOperation = null;
                String operationCommand = "rollback";
                BufferedLogService bufferLog = new BufferedLogService();
                DatabaseChangeLog changeLog = null;
                Date startTime = new Date();
                HubUpdater hubUpdater = null;
                try {
                    changeLog = Liquibase.this.getDatabaseChangeLog();
                    Liquibase.this.checkLiquibaseTables(false, changeLog, contexts, labelExpression);
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    hubUpdater = new HubUpdater(startTime, changeLog, Liquibase.this.database);
                    hubUpdater.register(Liquibase.this.changeLogFile);
                    List<RanChangeSet> ranChangeSetList = Liquibase.this.database.getRanChangeSetList();
                    ChangeLogIterator listLogIterator = new ChangeLogIterator(ranChangeSetList, changeLog, new AfterTagChangeSetFilter(tagToRollBackTo, ranChangeSetList), new AlreadyRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(Liquibase.this.database));
                    Connection connection = Liquibase.this.getConnection(changeLog);
                    if (connection != null) {
                        rollbackOperation = hubUpdater.preUpdateHub("ROLLBACK", "rollback", connection, Liquibase.this.changeLogFile, contexts, labelExpression, listLogIterator);
                    }
                    if (connection != null) {
                        Liquibase.this.changeExecListener = new HubChangeExecListener(rollbackOperation, Liquibase.this.changeExecListener);
                    }
                    ChangeLogIterator logIterator = new ChangeLogIterator(ranChangeSetList, changeLog, new AfterTagChangeSetFilter(tagToRollBackTo, ranChangeSetList), new AlreadyRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(Liquibase.this.database));
                    Liquibase.this.doRollback(bufferLog, rollbackScript, logIterator, contexts, labelExpression, hubUpdater, rollbackOperation);
                }
                catch (Throwable t) {
                    Liquibase.this.handleRollbackException(t, hubUpdater, rollbackOperation, bufferLog, "rollback");
                    throw t;
                }
                finally {
                    Liquibase.this.handleRollbackFinally(lockService);
                }
            }
        });
    }

    public void rollback(Date dateToRollBackTo, String contexts, Writer output) throws LiquibaseException {
        this.rollback(dateToRollBackTo, null, contexts, output);
    }

    public void rollback(Date dateToRollBackTo, String rollbackScript, String contexts, Writer output) throws LiquibaseException {
        this.rollback(dateToRollBackTo, new Contexts(contexts), new LabelExpression(), output);
    }

    public void rollback(Date dateToRollBackTo, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.rollback(dateToRollBackTo, null, contexts, labelExpression, output);
    }

    public void rollback(Date dateToRollBackTo, String rollbackScript, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        Executor oldTemplate = this.getAndReplaceJdbcExecutor(output);
        this.outputHeader("Rollback to " + dateToRollBackTo + " Script");
        this.rollback(dateToRollBackTo, contexts, labelExpression);
        this.flushOutputWriter(output);
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, oldTemplate);
        this.resetServices();
    }

    private Executor getAndReplaceJdbcExecutor(Writer output) {
        Executor oldTemplate = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        LoggingExecutor loggingExecutor = new LoggingExecutor(oldTemplate, output, this.database);
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("logging", this.database, loggingExecutor);
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, loggingExecutor);
        return oldTemplate;
    }

    public void rollback(Date dateToRollBackTo, String contexts) throws LiquibaseException {
        this.rollback(dateToRollBackTo, null, contexts);
    }

    public void rollback(Date dateToRollBackTo, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.rollback(dateToRollBackTo, null, contexts, labelExpression);
    }

    public void rollback(Date dateToRollBackTo, String rollbackScript, String contexts) throws LiquibaseException {
        this.rollback(dateToRollBackTo, new Contexts(contexts), new LabelExpression());
    }

    public void rollback(final Date dateToRollBackTo, final String rollbackScript, final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.addCommandFiltersMdc(labelExpression, contexts);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                Scope.getCurrentScope().addMdcValue("rollbackToDate", dateToRollBackTo.toString());
                Scope.getCurrentScope().addMdcValue("rollbackScript", rollbackScript);
                Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", Liquibase.this.database.getConnection().getURL());
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                Operation rollbackOperation = null;
                String operationCommand = "rollback-to-date";
                BufferedLogService bufferLog = new BufferedLogService();
                DatabaseChangeLog changeLog = null;
                Date startTime = new Date();
                HubUpdater hubUpdater = null;
                try {
                    changeLog = Liquibase.this.getDatabaseChangeLog();
                    Liquibase.this.checkLiquibaseTables(false, changeLog, contexts, labelExpression);
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    hubUpdater = new HubUpdater(startTime, changeLog, Liquibase.this.database);
                    hubUpdater.register(Liquibase.this.changeLogFile);
                    List<RanChangeSet> ranChangeSetList = Liquibase.this.database.getRanChangeSetList();
                    ChangeLogIterator listLogIterator = new ChangeLogIterator(ranChangeSetList, changeLog, new ExecutedAfterChangeSetFilter(dateToRollBackTo, ranChangeSetList), new AlreadyRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(Liquibase.this.database));
                    Connection connection = Liquibase.this.getConnection(changeLog);
                    if (connection != null) {
                        rollbackOperation = hubUpdater.preUpdateHub("ROLLBACK", "rollback-to-date", connection, Liquibase.this.changeLogFile, contexts, labelExpression, listLogIterator);
                    }
                    if (connection != null) {
                        Liquibase.this.changeExecListener = new HubChangeExecListener(rollbackOperation, Liquibase.this.changeExecListener);
                    }
                    ChangeLogIterator logIterator = new ChangeLogIterator(ranChangeSetList, changeLog, new ExecutedAfterChangeSetFilter(dateToRollBackTo, ranChangeSetList), new AlreadyRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(Liquibase.this.database));
                    Liquibase.this.doRollback(bufferLog, rollbackScript, logIterator, contexts, labelExpression, hubUpdater, rollbackOperation);
                }
                catch (Throwable t) {
                    Liquibase.this.handleRollbackException(t, hubUpdater, rollbackOperation, bufferLog, "rollback-to-date");
                    throw t;
                }
                finally {
                    Liquibase.this.handleRollbackFinally(lockService);
                }
            }
        });
    }

    private void handleRollbackException(Throwable t, HubUpdater hubUpdater, Operation rollbackOperation, BufferedLogService bufferLog, String operationName) throws IOException {
        if (hubUpdater != null) {
            hubUpdater.postUpdateHubExceptionHandling(rollbackOperation, bufferLog, t.getMessage());
        }
        try (MdcObject deploymentOutcomeMdc = Scope.getCurrentScope().addMdcValue("deploymentOutcome", "fail");){
            Scope.getCurrentScope().getLog(this.getClass()).info(operationName + " command encountered an exception.");
        }
    }

    private void handleRollbackFinally(LockService lockService) {
        try {
            lockService.releaseLock();
        }
        catch (LockException e) {
            LOG.severe("Error releasing lock", e);
        }
        this.resetServices();
        this.setChangeExecListener(null);
        Scope.getCurrentScope().getMdcManager().remove("changesetsRolledback");
    }

    public void changeLogSync(String contexts, Writer output) throws LiquibaseException {
        this.changeLogSync(new Contexts(contexts), new LabelExpression(), output);
    }

    public void changeLogSync(Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.doChangeLogSyncSql(null, contexts, labelExpression, output, () -> "SQL to add all changesets to database history table");
    }

    private void flushOutputWriter(Writer output) throws LiquibaseException {
        if (output == null) {
            return;
        }
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
    }

    public void changeLogSync(String contexts) throws LiquibaseException {
        this.changeLogSync(new Contexts(contexts), new LabelExpression());
    }

    @Deprecated
    public void changeLogSync(Contexts contexts) throws LiquibaseException {
        this.changeLogSync(contexts, new LabelExpression());
    }

    public void changeLogSync(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogSync(null, contexts, labelExpression);
    }

    public void changeLogSync(String tag, String contexts) throws LiquibaseException {
        this.changeLogSync(tag, new Contexts(contexts), new LabelExpression());
    }

    public void changeLogSync(final String tag, final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                Operation changeLogSyncOperation = null;
                BufferedLogService bufferLog = new BufferedLogService();
                DatabaseChangeLog changeLog = null;
                HubUpdater hubUpdater = null;
                try {
                    changeLog = Liquibase.this.getDatabaseChangeLog();
                    Liquibase.this.checkLiquibaseTables(true, changeLog, contexts, labelExpression);
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    hubUpdater = new HubUpdater(new Date(), changeLog, Liquibase.this.database);
                    hubUpdater.register(Liquibase.this.changeLogFile);
                    ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(Liquibase.this.database).generateDeploymentId();
                    ChangeLogIterator listLogIterator = Liquibase.this.buildChangeLogIterator(tag, changeLog, contexts, labelExpression);
                    Connection connection = Liquibase.this.getConnection(changeLog);
                    if (connection != null) {
                        String operationCommand = tag == null ? "changelog-sync" : "changelog-sync-to-tag";
                        changeLogSyncOperation = hubUpdater.preUpdateHub("CHANGELOGSYNC", operationCommand, connection, Liquibase.this.changeLogFile, contexts, labelExpression, listLogIterator);
                    }
                    if (connection != null) {
                        Liquibase.this.changeLogSyncListener = new HubChangeExecListener(changeLogSyncOperation, Liquibase.this.changeExecListener);
                    }
                    ChangeLogIterator runChangeLogIterator = Liquibase.this.buildChangeLogIterator(tag, changeLog, contexts, labelExpression);
                    CompositeLogService compositeLogService = new CompositeLogService(true, bufferLog);
                    Scope.child(Scope.Attr.logService.name(), (Object)compositeLogService, () -> runChangeLogIterator.run(new ChangeLogSyncVisitor(Liquibase.this.database, Liquibase.this.changeLogSyncListener), new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression)));
                    hubUpdater.postUpdateHub(changeLogSyncOperation, bufferLog);
                }
                catch (Exception e) {
                    if (changeLogSyncOperation != null) {
                        hubUpdater.postUpdateHubExceptionHandling(changeLogSyncOperation, bufferLog, e.getMessage());
                    }
                    throw e;
                }
                finally {
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e);
                    }
                    Liquibase.this.resetServices();
                    Liquibase.this.setChangeExecListener(null);
                }
            }
        });
    }

    public void changeLogSync(String tag, String contexts, Writer output) throws LiquibaseException {
        this.changeLogSync(tag, new Contexts(contexts), new LabelExpression(), output);
    }

    public void changeLogSync(String tag, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.doChangeLogSyncSql(tag, contexts, labelExpression, output, () -> "SQL to add changesets upto '" + tag + "' to database history table");
    }

    private void doChangeLogSyncSql(String tag, Contexts contexts, LabelExpression labelExpression, Writer output, Supplier<String> header) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(() -> {
            LoggingExecutor outputTemplate = new LoggingExecutor(Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor(this.database), output, this.database);
            Executor oldTemplate = this.getAndReplaceJdbcExecutor(output);
            this.outputHeader("SQL to add all changesets to database history table");
            this.changeLogSync(tag, contexts, labelExpression);
            this.flushOutputWriter(output);
            Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, oldTemplate);
            this.resetServices();
        });
    }

    public void markNextChangeSetRan(String contexts, Writer output) throws LiquibaseException {
        this.markNextChangeSetRan(new Contexts(contexts), new LabelExpression(), output);
    }

    public void markNextChangeSetRan(final Contexts contexts, final LabelExpression labelExpression, final Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                Executor oldTemplate = Liquibase.this.getAndReplaceJdbcExecutor(output);
                Liquibase.this.outputHeader("SQL to add all changesets to database history table");
                Liquibase.this.markNextChangeSetRan(contexts, labelExpression);
                Liquibase.this.flushOutputWriter(output);
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", Liquibase.this.database, oldTemplate);
                Liquibase.this.resetServices();
            }
        });
    }

    public void markNextChangeSetRan(String contexts) throws LiquibaseException {
        this.markNextChangeSetRan(new Contexts(contexts), new LabelExpression());
    }

    public void markNextChangeSetRan(final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws Exception {
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                try {
                    DatabaseChangeLog changeLog = Liquibase.this.getDatabaseChangeLog();
                    ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(Liquibase.this.database).generateDeploymentId();
                    Liquibase.this.checkLiquibaseTables(false, changeLog, contexts, labelExpression);
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(Liquibase.this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(1));
                    logIterator.run(new ChangeLogSyncVisitor(Liquibase.this.database), new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
                }
                finally {
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e);
                    }
                    Liquibase.this.resetServices();
                }
            }
        });
    }

    public void futureRollbackSQL(String contexts, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(null, contexts, output, true);
    }

    public void futureRollbackSQL(Writer output) throws LiquibaseException {
        this.futureRollbackSQL(null, null, new Contexts(), new LabelExpression(), output);
    }

    public void futureRollbackSQL(String contexts, Writer output, boolean checkLiquibaseTables) throws LiquibaseException {
        this.futureRollbackSQL(null, contexts, output, checkLiquibaseTables);
    }

    public void futureRollbackSQL(Integer count, String contexts, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(count, new Contexts(contexts), new LabelExpression(), output, true);
    }

    public void futureRollbackSQL(Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(null, null, contexts, labelExpression, output);
    }

    public void futureRollbackSQL(Integer count, String contexts, Writer output, boolean checkLiquibaseTables) throws LiquibaseException {
        this.futureRollbackSQL(count, new Contexts(contexts), new LabelExpression(), output, checkLiquibaseTables);
    }

    public void futureRollbackSQL(Integer count, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(count, contexts, labelExpression, output, true);
    }

    public void futureRollbackSQL(Integer count, Contexts contexts, LabelExpression labelExpression, Writer output, boolean checkLiquibaseTables) throws LiquibaseException {
        this.futureRollbackSQL(count, null, contexts, labelExpression, output);
    }

    public void futureRollbackSQL(String tag, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(null, tag, contexts, labelExpression, output);
    }

    protected void futureRollbackSQL(Integer count, String tag, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(count, tag, contexts, labelExpression, output, true);
    }

    protected void futureRollbackSQL(final Integer count, final String tag, final Contexts contexts, final LabelExpression labelExpression, final Writer output, final boolean checkLiquibaseTables) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws Exception {
                LoggingExecutor outputTemplate = new LoggingExecutor(Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor(Liquibase.this.database), output, Liquibase.this.database);
                Executor oldTemplate = Liquibase.this.getAndReplaceJdbcExecutor(output);
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor(Liquibase.this.database, outputTemplate);
                Liquibase.this.outputHeader("SQL to roll back currently unexecuted changes");
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                try {
                    ChangeLogIterator logIterator;
                    DatabaseChangeLog changeLog = Liquibase.this.getDatabaseChangeLog();
                    if (checkLiquibaseTables) {
                        Liquibase.this.checkLiquibaseTables(false, changeLog, contexts, labelExpression);
                    }
                    ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(Liquibase.this.database).generateDeploymentId();
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    if (count == null && tag == null) {
                        logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(Liquibase.this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(Liquibase.this.database));
                    } else if (count != null) {
                        ChangeLogIterator forwardIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(Liquibase.this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(count));
                        final ListVisitor listVisitor = new ListVisitor();
                        forwardIterator.run(listVisitor, new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
                        logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(Liquibase.this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new ChangeSetFilter(){

                            @Override
                            public ChangeSetFilterResult accepts(ChangeSet changeSet) {
                                return new ChangeSetFilterResult(listVisitor.getSeenChangeSets().contains(changeSet), null, null);
                            }
                        });
                    } else {
                        List<RanChangeSet> ranChangeSetList = Liquibase.this.database.getRanChangeSetList();
                        UpToTagChangeSetFilter upToTagChangeSetFilter = new UpToTagChangeSetFilter(tag, ranChangeSetList);
                        ChangeLogIterator forwardIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), upToTagChangeSetFilter);
                        final ListVisitor listVisitor = new ListVisitor();
                        forwardIterator.run(listVisitor, new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
                        if (!upToTagChangeSetFilter.isSeenTag()) {
                            String message = "No tag matching '" + tag + "' found";
                            Scope.getCurrentScope().getUI().sendMessage("ERROR: " + message);
                            Scope.getCurrentScope().getLog(Liquibase.class).severe(message);
                            throw new LiquibaseException(new IllegalArgumentException(message));
                        }
                        logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new ChangeSetFilter(){

                            @Override
                            public ChangeSetFilterResult accepts(ChangeSet changeSet) {
                                return new ChangeSetFilterResult(listVisitor.getSeenChangeSets().contains(changeSet), null, null);
                            }
                        });
                    }
                    logIterator.run(Liquibase.this.createRollbackVisitor(), new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
                }
                finally {
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e);
                    }
                    Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", Liquibase.this.database, oldTemplate);
                    Liquibase.this.resetServices();
                }
                Liquibase.this.flushOutputWriter(output);
            }
        });
    }

    protected void resetServices() {
        LockServiceFactory.getInstance().resetAll();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
        Scope.getCurrentScope().getSingleton(ExecutorService.class).reset();
    }

    public final void dropAll() throws DatabaseException {
        this.dropAll(new CatalogAndSchema(this.getDatabase().getDefaultCatalogName(), this.getDatabase().getDefaultSchemaName()));
    }

    public final void dropAll(CatalogAndSchema ... schemas) throws DatabaseException {
        if (schemas == null || schemas.length == 0) {
            schemas = new CatalogAndSchema[]{new CatalogAndSchema(this.getDatabase().getDefaultCatalogName(), this.getDatabase().getDefaultSchemaName())};
        }
        CatalogAndSchema[] finalSchemas = schemas;
        try {
            CommandScope dropAll = new CommandScope("internalDropAll").addArgumentValue(InternalDropAllCommandStep.DATABASE_ARG, this.getDatabase()).addArgumentValue(InternalDropAllCommandStep.SCHEMAS_ARG, finalSchemas);
            try {
                dropAll.execute();
            }
            catch (CommandExecutionException e) {
                throw new DatabaseException(e);
            }
        }
        catch (LiquibaseException e) {
            if (e instanceof DatabaseException) {
                throw (DatabaseException)e;
            }
            throw new DatabaseException(e);
        }
    }

    public void tag(String tagString) throws LiquibaseException {
        new CommandScope("tag").addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.database).addArgumentValue(TagCommandStep.TAG_ARG, tagString).execute();
    }

    public boolean tagExists(String tagString) throws LiquibaseException {
        CommandResults commandResults = new CommandScope("tagExists").addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.database).addArgumentValue(TagExistsCommandStep.TAG_ARG, tagString).execute();
        return commandResults.getResult(TagExistsCommandStep.TAG_EXISTS_RESULT);
    }

    public void updateTestingRollback(String contexts) throws LiquibaseException {
        this.updateTestingRollback(new Contexts(contexts), new LabelExpression());
    }

    public void updateTestingRollback(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.updateTestingRollback(null, contexts, labelExpression);
    }

    public void updateTestingRollback(String tag, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        Date baseDate = new Date();
        this.update(tag, contexts, labelExpression);
        this.rollback(baseDate, null, contexts, labelExpression);
        this.update(tag, contexts, labelExpression);
    }

    public void checkLiquibaseTables(boolean updateExistingNullChecksums, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.getDatabase());
        changeLogHistoryService.init();
        if (updateExistingNullChecksums) {
            changeLogHistoryService.upgradeChecksums(databaseChangeLog, contexts, labelExpression);
        }
        LockServiceFactory.getInstance().getLockService(this.getDatabase()).init();
    }

    public boolean isSafeToRunUpdate() throws DatabaseException {
        return this.getDatabase().isSafeToRunUpdate();
    }

    public DatabaseChangeLogLock[] listLocks() throws LiquibaseException {
        this.checkLiquibaseTables(false, null, new Contexts(), new LabelExpression());
        return LockServiceFactory.getInstance().getLockService(this.database).listLocks();
    }

    public void reportLocks(PrintStream out) throws LiquibaseException {
        DatabaseChangeLogLock[] locks = this.listLocks();
        out.println("Database change log locks for " + this.getDatabase().getConnection().getConnectionUserName() + "@" + this.getDatabase().getConnection().getURL());
        if (locks.length == 0) {
            out.println(" - No locks");
            return;
        }
        for (DatabaseChangeLogLock lock : locks) {
            out.println(" - " + lock.getLockedBy() + " at " + DateFormat.getDateTimeInstance().format(lock.getLockGranted()));
        }
        out.println("NOTE:  The lock time displayed is based on the database's configured time");
    }

    public void forceReleaseLocks() throws LiquibaseException {
        this.checkLiquibaseTables(false, null, new Contexts(), new LabelExpression());
        LockServiceFactory.getInstance().getLockService(this.database).forceReleaseLock();
    }

    @Deprecated
    public List<ChangeSet> listUnrunChangeSets(Contexts contexts) throws LiquibaseException {
        return this.listUnrunChangeSets(contexts, new LabelExpression());
    }

    public List<ChangeSet> listUnrunChangeSets(Contexts contexts, LabelExpression labels) throws LiquibaseException {
        return this.listUnrunChangeSets(contexts, labels, true);
    }

    public List<ChangeSet> listUnrunChangeSets(final Contexts contexts, final LabelExpression labels, final boolean checkLiquibaseTables) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labels);
        final ListVisitor visitor = new ListVisitor();
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                DatabaseChangeLog changeLog = Liquibase.this.getDatabaseChangeLog();
                if (checkLiquibaseTables) {
                    Liquibase.this.checkLiquibaseTables(true, changeLog, contexts, labels);
                }
                changeLog.validate(Liquibase.this.database, contexts, labels);
                ChangeLogIterator logIterator = Liquibase.this.getStandardChangelogIterator(contexts, labels, changeLog);
                logIterator.run(visitor, new RuntimeEnvironment(Liquibase.this.database, contexts, labels));
            }
        });
        return visitor.getSeenChangeSets();
    }

    @Deprecated
    public List<ChangeSetStatus> getChangeSetStatuses(Contexts contexts) throws LiquibaseException {
        return this.getChangeSetStatuses(contexts, new LabelExpression());
    }

    public List<ChangeSetStatus> getChangeSetStatuses(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        return this.getChangeSetStatuses(contexts, labelExpression, true);
    }

    public List<ChangeSetStatus> getChangeSetStatuses(final Contexts contexts, final LabelExpression labelExpression, final boolean checkLiquibaseTables) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        final StatusVisitor visitor = new StatusVisitor(this.database);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                DatabaseChangeLog changeLog = Liquibase.this.getDatabaseChangeLog();
                if (checkLiquibaseTables) {
                    Liquibase.this.checkLiquibaseTables(true, changeLog, contexts, labelExpression);
                }
                changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                ChangeLogIterator logIterator = Liquibase.this.getStandardChangelogIterator(contexts, labelExpression, changeLog);
                logIterator.run(visitor, new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
            }
        });
        return visitor.getStatuses();
    }

    public void reportStatus(boolean verbose, String contexts, Writer out) throws LiquibaseException {
        this.reportStatus(verbose, new Contexts(contexts), new LabelExpression(), out);
    }

    public void reportStatus(boolean verbose, Contexts contexts, Writer out) throws LiquibaseException {
        this.reportStatus(verbose, contexts, new LabelExpression(), out);
    }

    public void reportStatus(boolean verbose, Contexts contexts, LabelExpression labels, Writer out) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labels);
        try {
            List<ChangeSet> unrunChangeSets = this.listUnrunChangeSets(contexts, labels, false);
            if (unrunChangeSets.isEmpty()) {
                out.append(this.getDatabase().getConnection().getConnectionUserName());
                out.append("@");
                out.append(this.getDatabase().getConnection().getURL());
                out.append(" is up to date");
                out.append(StreamUtil.getLineSeparator());
            } else {
                out.append(String.valueOf(unrunChangeSets.size()));
                out.append(" changesets have not been applied to ");
                out.append(this.getDatabase().getConnection().getConnectionUserName());
                out.append("@");
                out.append(this.getDatabase().getConnection().getURL());
                out.append(StreamUtil.getLineSeparator());
                if (verbose) {
                    for (ChangeSet changeSet : unrunChangeSets) {
                        out.append("     ").append(changeSet.toString(false)).append(StreamUtil.getLineSeparator());
                    }
                }
            }
            out.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
    }

    public Collection<RanChangeSet> listUnexpectedChangeSets(String contexts) throws LiquibaseException {
        return this.listUnexpectedChangeSets(new Contexts(contexts), new LabelExpression());
    }

    public Collection<RanChangeSet> listUnexpectedChangeSets(final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        final ExpectedChangesVisitor visitor = new ExpectedChangesVisitor(this.database.getRanChangeSetList());
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                DatabaseChangeLog changeLog = Liquibase.this.getDatabaseChangeLog();
                changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter());
                logIterator.run(visitor, new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
            }
        });
        return visitor.getUnexpectedChangeSets();
    }

    public void reportUnexpectedChangeSets(boolean verbose, String contexts, Writer out) throws LiquibaseException {
        this.reportUnexpectedChangeSets(verbose, new Contexts(contexts), new LabelExpression(), out);
    }

    public void reportUnexpectedChangeSets(boolean verbose, Contexts contexts, LabelExpression labelExpression, Writer out) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        try {
            Collection<RanChangeSet> unexpectedChangeSets = this.listUnexpectedChangeSets(contexts, labelExpression);
            if (unexpectedChangeSets.isEmpty()) {
                out.append(this.getDatabase().getConnection().getConnectionUserName());
                out.append("@");
                out.append(this.getDatabase().getConnection().getURL());
                out.append(" contains no unexpected changes!");
                out.append(StreamUtil.getLineSeparator());
            } else {
                out.append(String.valueOf(unexpectedChangeSets.size()));
                out.append(" unexpected changes were found in ");
                out.append(this.getDatabase().getConnection().getConnectionUserName());
                out.append("@");
                out.append(this.getDatabase().getConnection().getURL());
                out.append(StreamUtil.getLineSeparator());
                if (verbose) {
                    for (RanChangeSet ranChangeSet : unexpectedChangeSets) {
                        out.append("     ").append(ranChangeSet.toString()).append(StreamUtil.getLineSeparator());
                    }
                }
            }
            out.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
    }

    public void clearCheckSums() throws LiquibaseException {
        LOG.info("Clearing database change log checksums");
        this.runInScope(() -> {
            LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
            lockService.waitForLock();
            try {
                this.checkLiquibaseTables(false, null, new Contexts(), new LabelExpression());
                ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database).clearAllCheckSums();
            }
            finally {
                try {
                    lockService.releaseLock();
                }
                catch (LockException e) {
                    LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e);
                }
            }
            this.resetServices();
        });
    }

    public final CheckSum calculateCheckSum(String changeSetIdentifier) throws LiquibaseException {
        CommandResults commandResults = new CommandScope("calculateChecksum").addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.database).addArgumentValue(CalculateChecksumCommandStep.CHANGESET_IDENTIFIER_ARG, changeSetIdentifier).addArgumentValue(CalculateChecksumCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile).execute();
        return commandResults.getResult(CalculateChecksumCommandStep.CHECKSUM_RESULT);
    }

    public CheckSum calculateCheckSum(String filename, String id, String author) throws LiquibaseException {
        return this.calculateCheckSum(String.format("%s::%s::%s", filename, id, author));
    }

    public void generateDocumentation(String outputDirectory) throws LiquibaseException {
        this.generateDocumentation(outputDirectory, new Contexts(), new LabelExpression(), new CatalogAndSchema(null, null));
    }

    public void generateDocumentation(String outputDirectory, String contexts) throws LiquibaseException {
        this.generateDocumentation(outputDirectory, new Contexts(contexts), new LabelExpression(), new CatalogAndSchema(null, null));
    }

    public void generateDocumentation(String outputDirectory, String contexts, CatalogAndSchema ... schemaList) throws LiquibaseException {
        this.generateDocumentation(outputDirectory, new Contexts(contexts), new LabelExpression(), schemaList);
    }

    public void generateDocumentation(final String outputDirectory, final Contexts contexts, final LabelExpression labelExpression, final CatalogAndSchema ... schemaList) throws LiquibaseException {
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                LOG.info("Generating Database Documentation");
                Liquibase.this.changeLogParameters.setContexts(contexts);
                Liquibase.this.changeLogParameters.setLabels(labelExpression);
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                try {
                    DatabaseChangeLog changeLog = Liquibase.this.getDatabaseChangeLog();
                    Liquibase.this.checkLiquibaseTables(false, changeLog, new Contexts(), new LabelExpression());
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new DbmsChangeSetFilter(Liquibase.this.database));
                    DBDocVisitor visitor = new DBDocVisitor(Liquibase.this.database);
                    logIterator.run(visitor, new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
                    PathHandlerFactory pathHandlerFactory = Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
                    Resource resource = pathHandlerFactory.getResource(outputDirectory);
                    visitor.writeHTML(resource, Liquibase.this.resourceAccessor, schemaList);
                }
                catch (IOException e) {
                    throw new LiquibaseException(e);
                }
                finally {
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e);
                    }
                }
            }
        });
    }

    public DiffResult diff(Database referenceDatabase, Database targetDatabase, CompareControl compareControl) throws LiquibaseException {
        return DiffGeneratorFactory.getInstance().compare(referenceDatabase, targetDatabase, compareControl);
    }

    public void validate() throws LiquibaseException {
        DatabaseChangeLog changeLog = this.getDatabaseChangeLog(true);
        changeLog.validate(this.database, new String[0]);
    }

    public void setChangeLogParameter(String key, Object value) {
        this.changeLogParameters.set(key, value);
    }

    private void setDatabasePropertiesAsChangelogParameters(Database database) throws DatabaseException {
        this.setChangeLogParameter("database.autoIncrementClause", database.getAutoIncrementClause(null, null, null, null));
        this.setChangeLogParameter("database.currentDateTimeFunction", database.getCurrentDateTimeFunction());
        this.setChangeLogParameter("database.databaseChangeLogLockTableName", database.getDatabaseChangeLogLockTableName());
        this.setChangeLogParameter("database.databaseChangeLogTableName", database.getDatabaseChangeLogTableName());
        this.setChangeLogParameter("database.databaseMajorVersion", database.getDatabaseMajorVersion());
        this.setChangeLogParameter("database.databaseMinorVersion", database.getDatabaseMinorVersion());
        this.setChangeLogParameter("database.databaseProductName", database.getDatabaseProductName());
        this.setChangeLogParameter("database.databaseProductVersion", database.getDatabaseProductVersion());
        this.setChangeLogParameter("database.defaultCatalogName", database.getDefaultCatalogName());
        this.setChangeLogParameter("database.defaultSchemaName", database.getDefaultSchemaName());
        this.setChangeLogParameter("database.defaultSchemaNamePrefix", StringUtil.trimToNull(database.getDefaultSchemaName()) == null ? "" : "." + database.getDefaultSchemaName());
        this.setChangeLogParameter("database.lineComment", database.getLineComment());
        this.setChangeLogParameter("database.liquibaseSchemaName", database.getLiquibaseSchemaName());
        this.setChangeLogParameter("database.liquibaseTablespaceName", database.getLiquibaseTablespaceName());
        this.setChangeLogParameter("database.typeName", database.getShortName());
        this.setChangeLogParameter("database.isSafeToRunUpdate", database.isSafeToRunUpdate());
        this.setChangeLogParameter("database.requiresPassword", database.requiresPassword());
        this.setChangeLogParameter("database.requiresUsername", database.requiresUsername());
        this.setChangeLogParameter("database.supportsForeignKeyDisable", database.supportsForeignKeyDisable());
        this.setChangeLogParameter("database.supportsInitiallyDeferrableColumns", database.supportsInitiallyDeferrableColumns());
        this.setChangeLogParameter("database.supportsRestrictForeignKeys", database.supportsRestrictForeignKeys());
        this.setChangeLogParameter("database.supportsSchemas", database.supportsSchemas());
        this.setChangeLogParameter("database.supportsSequences", database.supportsSequences());
        this.setChangeLogParameter("database.supportsTablespaces", database.supportsTablespaces());
    }

    private LockService getLockService() {
        return LockServiceFactory.getInstance().getLockService(this.database);
    }

    public void setChangeExecListener(ChangeExecListener listener) {
        this.changeExecListener = listener;
    }

    public void setChangeLogSyncListener(ChangeLogSyncListener changeLogSyncListener) {
        this.changeLogSyncListener = changeLogSyncListener;
    }

    public DefaultChangeExecListener getDefaultChangeExecListener() {
        return this.defaultChangeExecListener;
    }

    @SafeVarargs
    public final void generateChangeLog(CatalogAndSchema catalogAndSchema, DiffToChangeLog changeLogWriter, PrintStream outputStream, Class<? extends DatabaseObject> ... snapshotTypes) throws DatabaseException, IOException, ParserConfigurationException {
        this.generateChangeLog(catalogAndSchema, changeLogWriter, outputStream, (ChangeLogSerializer)null, snapshotTypes);
    }

    @SafeVarargs
    public final void generateChangeLog(final CatalogAndSchema catalogAndSchema, final DiffToChangeLog changeLogWriter, final PrintStream outputStream, final ChangeLogSerializer changeLogSerializer, final Class<? extends DatabaseObject> ... snapshotTypes) throws DatabaseException, IOException, ParserConfigurationException {
        try {
            this.runInScope(new Scope.ScopedRunner(){

                @Override
                public void run() throws Exception {
                    HashSet<Class<? extends DatabaseObject>> finalCompareTypes = null;
                    if (snapshotTypes != null && snapshotTypes.length > 0) {
                        finalCompareTypes = new HashSet<Class<? extends DatabaseObject>>(Arrays.asList(snapshotTypes));
                    }
                    SnapshotControl snapshotControl = new SnapshotControl(Liquibase.this.getDatabase(), snapshotTypes);
                    CompareControl compareControl = new CompareControl(new CompareControl.SchemaComparison[]{new CompareControl.SchemaComparison(catalogAndSchema, catalogAndSchema)}, finalCompareTypes);
                    DatabaseSnapshot originalDatabaseSnapshot = null;
                    try {
                        originalDatabaseSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(compareControl.getSchemas(CompareControl.DatabaseRole.REFERENCE), Liquibase.this.getDatabase(), snapshotControl);
                        DiffResult diffResult = DiffGeneratorFactory.getInstance().compare(originalDatabaseSnapshot, SnapshotGeneratorFactory.getInstance().createSnapshot(compareControl.getSchemas(CompareControl.DatabaseRole.REFERENCE), null, snapshotControl), compareControl);
                        changeLogWriter.setDiffResult(diffResult);
                        if (changeLogSerializer != null) {
                            changeLogWriter.print(outputStream, changeLogSerializer);
                        } else {
                            changeLogWriter.print(outputStream);
                        }
                    }
                    catch (InvalidExampleException e) {
                        throw new UnexpectedLiquibaseException(e);
                    }
                }
            });
        }
        catch (LiquibaseException e) {
            throw new DatabaseException(e);
        }
    }

    private void runInScope(Scope.ScopedRunner scopedRunner) throws LiquibaseException {
        HashMap<String, Object> scopeObjects = new HashMap<String, Object>();
        scopeObjects.put(Scope.Attr.database.name(), this.getDatabase());
        scopeObjects.put(Scope.Attr.resourceAccessor.name(), this.getResourceAccessor());
        try {
            Scope.child(scopeObjects, scopedRunner);
        }
        catch (Exception e) {
            if (e instanceof LiquibaseException) {
                throw (LiquibaseException)e;
            }
            throw new LiquibaseException(e);
        }
    }

    @Override
    public void close() throws LiquibaseException {
        if (this.database != null) {
            this.database.close();
        }
    }

    private static enum RollbackMessageType {
        WILL_ROLLBACK,
        ROLLED_BACK,
        ROLLBACK_FAILED;

    }
}

