/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.function.Supplier;
import liquibase.CatalogAndSchema;
import liquibase.Contexts;
import liquibase.GlobalConfiguration;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.ChangeSetStatus;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.CountChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.filter.NotRanChangeSetFilter;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.changelog.filter.UpToTagChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeLogSyncVisitor;
import liquibase.changelog.visitor.DBDocVisitor;
import liquibase.changelog.visitor.DefaultChangeExecListener;
import liquibase.changelog.visitor.ExpectedChangesVisitor;
import liquibase.changelog.visitor.ListVisitor;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.changelog.visitor.StatusVisitor;
import liquibase.changelog.visitor.UpdateVisitor;
import liquibase.command.CommandResults;
import liquibase.command.CommandScope;
import liquibase.command.core.AbstractRollbackCommandStep;
import liquibase.command.core.CalculateChecksumCommandStep;
import liquibase.command.core.ChangelogSyncCommandStep;
import liquibase.command.core.ChangelogSyncSqlCommandStep;
import liquibase.command.core.ChangelogSyncToTagCommandStep;
import liquibase.command.core.ChangelogSyncToTagSqlCommandStep;
import liquibase.command.core.GenerateChangelogCommandStep;
import liquibase.command.core.InternalDropAllCommandStep;
import liquibase.command.core.ListLocksCommandStep;
import liquibase.command.core.ReleaseLocksCommandStep;
import liquibase.command.core.RollbackCommandStep;
import liquibase.command.core.RollbackCountCommandStep;
import liquibase.command.core.RollbackCountSqlCommandStep;
import liquibase.command.core.RollbackSqlCommandStep;
import liquibase.command.core.RollbackToDateCommandStep;
import liquibase.command.core.RollbackToDateSqlCommandStep;
import liquibase.command.core.StatusCommandStep;
import liquibase.command.core.TagCommandStep;
import liquibase.command.core.TagExistsCommandStep;
import liquibase.command.core.UpdateCommandStep;
import liquibase.command.core.UpdateCountCommandStep;
import liquibase.command.core.UpdateSqlCommandStep;
import liquibase.command.core.UpdateToTagCommandStep;
import liquibase.command.core.helpers.ChangeExecListenerCommandStep;
import liquibase.command.core.helpers.DatabaseChangelogCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionCommandStep;
import liquibase.command.core.helpers.PreCompareCommandStep;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.hub.HubConfiguration;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.HubUpdater;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.model.Connection;
import liquibase.hub.model.HubChangeLog;
import liquibase.io.WriterOutputStream;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;
import liquibase.logging.mdc.customobjects.ChangesetsRolledback;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.structure.DatabaseObject;
import liquibase.util.LoggingExecutorTextUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class Liquibase
implements AutoCloseable {
    private static final Logger LOG = Scope.getCurrentScope().getLog(Liquibase.class);
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    public static final String MSG_COULD_NOT_RELEASE_LOCK = coreBundle.getString("could.not.release.lock");
    protected Database database;
    private DatabaseChangeLog databaseChangeLog;
    private String changeLogFile;
    private final ResourceAccessor resourceAccessor;
    private final ChangeLogParameters changeLogParameters;
    private ChangeExecListener changeExecListener;
    private final DefaultChangeExecListener defaultChangeExecListener = new DefaultChangeExecListener(new ChangeExecListener[0]);
    private UUID hubConnectionId;
    private final Map<String, Boolean> upToDateFastCheck = new HashMap<String, Boolean>();

    public Liquibase(String changeLogFile, ResourceAccessor resourceAccessor, DatabaseConnection conn) throws LiquibaseException {
        this(changeLogFile, resourceAccessor, DatabaseFactory.getInstance().findCorrectDatabaseImplementation(conn));
    }

    public Liquibase(String changeLogFile, ResourceAccessor resourceAccessor, Database database) {
        if (changeLogFile != null) {
            this.changeLogFile = changeLogFile.replace('\\', '/');
        }
        this.resourceAccessor = resourceAccessor;
        this.changeLogParameters = new ChangeLogParameters(database);
        this.database = database;
    }

    public Liquibase(DatabaseChangeLog changeLog, ResourceAccessor resourceAccessor, Database database) {
        this.databaseChangeLog = changeLog;
        if (changeLog != null) {
            this.changeLogFile = changeLog.getPhysicalFilePath();
        }
        if (this.changeLogFile != null) {
            this.changeLogFile = this.changeLogFile.replace('\\', '/');
        }
        this.resourceAccessor = resourceAccessor;
        this.database = database;
        this.changeLogParameters = new ChangeLogParameters(database);
    }

    public UUID getHubConnectionId() {
        return this.hubConnectionId;
    }

    public void setHubConnectionId(UUID hubConnectionId) {
        this.hubConnectionId = hubConnectionId;
    }

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public Logger getLog() {
        return LOG;
    }

    public ChangeLogParameters getChangeLogParameters() {
        return this.changeLogParameters;
    }

    public Database getDatabase() {
        return this.database;
    }

    public ResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    @Deprecated
    public void update() throws LiquibaseException {
        this.update(new Contexts());
    }

    @Deprecated
    public void update(String contexts) throws LiquibaseException {
        this.update(new Contexts(contexts));
    }

    @Deprecated
    public void update(Contexts contexts) throws LiquibaseException {
        this.update(contexts, new LabelExpression());
    }

    @Deprecated
    public void update(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.update(contexts, labelExpression, true);
    }

    @Deprecated
    public void update(Contexts contexts, LabelExpression labelExpression, boolean checkLiquibaseTables) throws LiquibaseException {
        this.runInScope(() -> {
            CommandScope updateCommand = new CommandScope(UpdateCommandStep.COMMAND_NAME);
            updateCommand.addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase());
            updateCommand.addArgumentValue(UpdateCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile);
            updateCommand.addArgumentValue(UpdateCommandStep.CONTEXTS_ARG, contexts != null ? contexts.toString() : null);
            updateCommand.addArgumentValue(UpdateCommandStep.LABEL_FILTER_ARG, labelExpression != null ? labelExpression.getOriginalString() : null);
            updateCommand.addArgumentValue(ChangeExecListenerCommandStep.CHANGE_EXEC_LISTENER_ARG, this.changeExecListener);
            updateCommand.addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_PARAMETERS, this.changeLogParameters);
            updateCommand.execute();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUpToDateFastCheck(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        String cacheKey = contexts + "/" + labelExpression;
        if (!this.upToDateFastCheck.containsKey(cacheKey)) {
            try {
                if (this.listUnrunChangeSets(contexts, labelExpression, false).isEmpty()) {
                    LOG.fine("Fast check found no un-run changesets");
                    this.upToDateFastCheck.put(cacheKey, true);
                } else {
                    this.upToDateFastCheck.put(cacheKey, false);
                }
            }
            catch (DatabaseException e) {
                LOG.info("Error querying Liquibase tables, disabling fast check for this execution. Reason: " + e.getMessage());
                this.upToDateFastCheck.put(cacheKey, false);
            }
            finally {
                ChangeLogHistoryService changeLogService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
                changeLogService.reset();
            }
        }
        return this.upToDateFastCheck.get(cacheKey);
    }

    public Connection getConnection(DatabaseChangeLog changeLog) throws LiquibaseHubException {
        Connection connection;
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        if (executor instanceof LoggingExecutor) {
            return null;
        }
        HubUpdater hubUpdater = new HubUpdater(new Date(), changeLog, this.database);
        String changeLogId = changeLog.getChangeLogId();
        if (hubUpdater.hubIsNotAvailable(changeLogId)) {
            return null;
        }
        if (StringUtil.isEmpty(HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValue()) && changeLogId != null) {
            return null;
        }
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        if (this.getHubConnectionId() == null) {
            HubChangeLog hubChangeLog = hubService.getHubChangeLog(UUID.fromString(changeLogId), "*");
            if (hubChangeLog == null) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Retrieving Hub Change Log failed for Changelog ID: " + changeLogId);
                return null;
            }
            if (hubChangeLog.isDeleted()) {
                String message = "\nThe operation did not complete and will not be reported to Hub because the\nregistered changelog has been deleted by someone in your organization.\nLearn more at http://hub.liquibase.com.";
                throw new LiquibaseHubException(message);
            }
            Connection exampleConnection = new Connection();
            exampleConnection.setProject(hubChangeLog.getProject());
            exampleConnection.setJdbcUrl(this.database.getConnection().getURL());
            connection = hubService.getConnection(exampleConnection, true);
            this.setHubConnectionId(connection.getId());
        } else {
            connection = hubService.getConnection(new Connection().setId(this.getHubConnectionId()), true);
        }
        return connection;
    }

    public DatabaseChangeLog getDatabaseChangeLog() throws LiquibaseException {
        return this.getDatabaseChangeLog(false);
    }

    private DatabaseChangeLog getDatabaseChangeLog(boolean shouldWarnOnMismatchedXsdVersion) throws LiquibaseException {
        if (this.databaseChangeLog == null && this.changeLogFile != null) {
            Scope.getCurrentScope().addMdcValue("changelogFile", this.changeLogFile);
            ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser(this.changeLogFile, this.resourceAccessor);
            if (parser instanceof XMLChangeLogSAXParser) {
                ((XMLChangeLogSAXParser)parser).setShouldWarnOnMismatchedXsdVersion(shouldWarnOnMismatchedXsdVersion);
            }
            this.databaseChangeLog = parser.parse(this.changeLogFile, this.changeLogParameters, this.resourceAccessor);
            Scope.getCurrentScope().getLog(Liquibase.class).info("Parsed changelog file '" + this.changeLogFile + "'");
        }
        return this.databaseChangeLog;
    }

    protected UpdateVisitor createUpdateVisitor() {
        return new UpdateVisitor(this.database, this.changeExecListener);
    }

    protected UpdateVisitor createUpdateVisitor(ChangeExecListener listener) {
        return new UpdateVisitor(this.database, listener);
    }

    protected RollbackVisitor createRollbackVisitor() {
        return new RollbackVisitor(this.database, this.changeExecListener);
    }

    protected RollbackVisitor createRollbackVisitor(List<ChangesetsRolledback.ChangeSet> processedChangesets) {
        return new RollbackVisitor(this.database, this.changeExecListener, processedChangesets);
    }

    protected ChangeLogIterator getStandardChangelogIterator(Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog changeLog) throws DatabaseException {
        return new ChangeLogIterator(changeLog, new ShouldRunChangeSetFilter(this.database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(this.database), new IgnoreChangeSetFilter());
    }

    public void update(String contexts, Writer output) throws LiquibaseException {
        this.update(new Contexts(contexts), output);
    }

    public void update(Contexts contexts, Writer output) throws LiquibaseException {
        this.update(contexts, new LabelExpression(), output);
    }

    public void update(Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.update(contexts, labelExpression, output, true);
    }

    public void update(Contexts contexts, LabelExpression labelExpression, Writer output, boolean checkLiquibaseTables) throws LiquibaseException {
        this.runInScope(() -> {
            CommandScope updateCommand = new CommandScope(UpdateSqlCommandStep.COMMAND_NAME);
            updateCommand.addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase());
            updateCommand.addArgumentValue(UpdateSqlCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile);
            updateCommand.addArgumentValue(UpdateSqlCommandStep.CONTEXTS_ARG, contexts != null ? contexts.toString() : null);
            updateCommand.addArgumentValue(UpdateSqlCommandStep.LABEL_FILTER_ARG, labelExpression != null ? labelExpression.getOriginalString() : null);
            updateCommand.addArgumentValue(ChangeExecListenerCommandStep.CHANGE_EXEC_LISTENER_ARG, this.changeExecListener);
            updateCommand.addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_PARAMETERS, this.changeLogParameters);
            updateCommand.setOutput(new WriterOutputStream(output, GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue()));
            updateCommand.execute();
        });
    }

    @Deprecated
    public void update(int changesToApply, String contexts) throws LiquibaseException {
        this.update(changesToApply, new Contexts(contexts), new LabelExpression());
    }

    @Deprecated
    public void update(int changesToApply, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.runInScope(() -> {
            CommandScope updateCommand = new CommandScope(UpdateCountCommandStep.COMMAND_NAME);
            updateCommand.addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase());
            updateCommand.addArgumentValue(UpdateCountCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile);
            updateCommand.addArgumentValue(UpdateCountCommandStep.CONTEXTS_ARG, contexts != null ? contexts.toString() : null);
            updateCommand.addArgumentValue(UpdateCountCommandStep.LABEL_FILTER_ARG, labelExpression != null ? labelExpression.getOriginalString() : null);
            updateCommand.addArgumentValue(ChangeExecListenerCommandStep.CHANGE_EXEC_LISTENER_ARG, this.changeExecListener);
            updateCommand.addArgumentValue(UpdateCountCommandStep.COUNT_ARG, changesToApply);
            updateCommand.addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_PARAMETERS, this.changeLogParameters);
            updateCommand.execute();
        });
    }

    @Deprecated
    public void update(String tag, String contexts) throws LiquibaseException {
        this.update(tag, new Contexts(contexts), new LabelExpression());
    }

    @Deprecated
    public void update(String tag, Contexts contexts) throws LiquibaseException {
        this.update(tag, contexts, new LabelExpression());
    }

    @Deprecated
    public void update(String tag, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        if (tag == null) {
            this.update(contexts, labelExpression);
            return;
        }
        this.runInScope(() -> {
            CommandScope updateCommand = new CommandScope(UpdateToTagCommandStep.COMMAND_NAME);
            updateCommand.addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase());
            updateCommand.addArgumentValue(UpdateToTagCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile);
            updateCommand.addArgumentValue(UpdateToTagCommandStep.CONTEXTS_ARG, contexts != null ? contexts.toString() : null);
            updateCommand.addArgumentValue(UpdateToTagCommandStep.LABEL_FILTER_ARG, labelExpression != null ? labelExpression.getOriginalString() : null);
            updateCommand.addArgumentValue(ChangeExecListenerCommandStep.CHANGE_EXEC_LISTENER_ARG, this.changeExecListener);
            updateCommand.addArgumentValue(UpdateToTagCommandStep.TAG_ARG, tag);
            updateCommand.addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_PARAMETERS, this.changeLogParameters);
            updateCommand.execute();
        });
    }

    @Deprecated
    public void update(int changesToApply, String contexts, Writer output) throws LiquibaseException {
        this.update(changesToApply, new Contexts(contexts), new LabelExpression(), output);
    }

    @Deprecated
    public void update(int changesToApply, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(() -> {
            Executor oldTemplate = this.getAndReplaceJdbcExecutor(output);
            this.outputHeader("Update " + changesToApply + " Changesets Database Script");
            this.update(changesToApply, contexts, labelExpression);
            this.flushOutputWriter(output);
            this.resetServices();
            Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, oldTemplate);
        });
    }

    @Deprecated
    public void update(String tag, String contexts, Writer output) throws LiquibaseException {
        this.update(tag, new Contexts(contexts), new LabelExpression(), output);
    }

    @Deprecated
    public void update(String tag, Contexts contexts, Writer output) throws LiquibaseException {
        this.update(tag, contexts, new LabelExpression(), output);
    }

    @Deprecated
    public void update(String tag, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        if (tag == null) {
            this.update(contexts, labelExpression, output);
            return;
        }
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(() -> {
            Executor oldTemplate = this.getAndReplaceJdbcExecutor(output);
            this.outputHeader("Update to '" + tag + "' Database Script");
            this.update(tag, contexts, labelExpression);
            this.flushOutputWriter(output);
            this.resetServices();
            Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, oldTemplate);
        });
    }

    private void addCommandFiltersMdc(LabelExpression labelExpression, Contexts contexts) {
        String labelFilterMdc = labelExpression != null && labelExpression.getOriginalString() != null ? labelExpression.getOriginalString() : "";
        String contextFilterMdc = contexts != null ? contexts.toString() : "";
        Scope.getCurrentScope().addMdcValue("commandLabelFilter", labelFilterMdc);
        Scope.getCurrentScope().addMdcValue("commandContextFilter", contextFilterMdc);
    }

    @Deprecated
    public void outputHeader(String message) throws DatabaseException {
        LoggingExecutorTextUtil.outputHeader(message, this.database, this.changeLogFile);
    }

    public void rollback(int changesToRollback, String contexts, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts, output);
    }

    public void rollback(int changesToRollback, Contexts contexts, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts, output);
    }

    public void rollback(int changesToRollback, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts, labelExpression, output);
    }

    public void rollback(int changesToRollback, String rollbackScript, String contexts, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, rollbackScript, new Contexts(contexts), output);
    }

    public void rollback(int changesToRollback, String rollbackScript, Contexts contexts, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, rollbackScript, contexts, new LabelExpression(), output);
    }

    public void rollback(int changesToRollback, String rollbackScript, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        new CommandScope(RollbackCountSqlCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase()).addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile).addArgumentValue(DatabaseChangelogCommandStep.CONTEXTS_ARG, contexts != null ? contexts.toString() : null).addArgumentValue(DatabaseChangelogCommandStep.LABEL_FILTER_ARG, labelExpression != null ? labelExpression.getOriginalString() : null).addArgumentValue(ChangeExecListenerCommandStep.CHANGE_EXEC_LISTENER_ARG, this.changeExecListener).addArgumentValue(RollbackCountCommandStep.COUNT_ARG, changesToRollback).addArgumentValue(AbstractRollbackCommandStep.ROLLBACK_SCRIPT_ARG, rollbackScript).setOutput(new WriterOutputStream(output, GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue())).execute();
    }

    public void rollback(int changesToRollback, String contexts) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts);
    }

    public void rollback(int changesToRollback, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts, labelExpression);
    }

    public void rollback(int changesToRollback, String rollbackScript, String contexts) throws LiquibaseException {
        this.rollback(changesToRollback, rollbackScript, new Contexts(contexts), new LabelExpression());
    }

    public void rollback(int changesToRollback, String rollbackScript, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        new CommandScope(RollbackCountCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase()).addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile).addArgumentValue(DatabaseChangelogCommandStep.CONTEXTS_ARG, contexts != null ? contexts.toString() : null).addArgumentValue(DatabaseChangelogCommandStep.LABEL_FILTER_ARG, labelExpression != null ? labelExpression.getOriginalString() : null).addArgumentValue(ChangeExecListenerCommandStep.CHANGE_EXEC_LISTENER_ARG, this.changeExecListener).addArgumentValue(RollbackCountCommandStep.COUNT_ARG, changesToRollback).addArgumentValue(AbstractRollbackCommandStep.ROLLBACK_SCRIPT_ARG, rollbackScript).execute();
    }

    @Deprecated
    public void rollback(String tagToRollBackTo, String contexts, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts, output);
    }

    @Deprecated
    public void rollback(String tagToRollBackTo, Contexts contexts, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts, output);
    }

    @Deprecated
    public void rollback(String tagToRollBackTo, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts, labelExpression, output);
    }

    @Deprecated
    public void rollback(String tagToRollBackTo, String rollbackScript, String contexts, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, rollbackScript, new Contexts(contexts), output);
    }

    @Deprecated
    public void rollback(String tagToRollBackTo, String rollbackScript, Contexts contexts, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, rollbackScript, contexts, new LabelExpression(), output);
    }

    @Deprecated
    public void rollback(String tagToRollBackTo, String rollbackScript, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        new CommandScope(RollbackSqlCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase()).addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile).addArgumentValue(DatabaseChangelogCommandStep.CONTEXTS_ARG, contexts != null ? contexts.toString() : null).addArgumentValue(DatabaseChangelogCommandStep.LABEL_FILTER_ARG, labelExpression != null ? labelExpression.getOriginalString() : null).addArgumentValue(ChangeExecListenerCommandStep.CHANGE_EXEC_LISTENER_ARG, this.changeExecListener).addArgumentValue(RollbackCommandStep.TAG_ARG, tagToRollBackTo).addArgumentValue(AbstractRollbackCommandStep.ROLLBACK_SCRIPT_ARG, rollbackScript).setOutput(new WriterOutputStream(output, GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue())).execute();
    }

    @Deprecated
    public void rollback(String tagToRollBackTo, String contexts) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts);
    }

    @Deprecated
    public void rollback(String tagToRollBackTo, Contexts contexts) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts);
    }

    @Deprecated
    public void rollback(String tagToRollBackTo, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts, labelExpression);
    }

    @Deprecated
    public void rollback(String tagToRollBackTo, String rollbackScript, String contexts) throws LiquibaseException {
        this.rollback(tagToRollBackTo, rollbackScript, new Contexts(contexts));
    }

    @Deprecated
    public void rollback(String tagToRollBackTo, String rollbackScript, Contexts contexts) throws LiquibaseException {
        this.rollback(tagToRollBackTo, rollbackScript, contexts, new LabelExpression());
    }

    public void rollback(String tagToRollBackTo, String rollbackScript, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        new CommandScope(RollbackCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase()).addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile).addArgumentValue(DatabaseChangelogCommandStep.CONTEXTS_ARG, contexts != null ? contexts.toString() : null).addArgumentValue(DatabaseChangelogCommandStep.LABEL_FILTER_ARG, labelExpression != null ? labelExpression.getOriginalString() : null).addArgumentValue(ChangeExecListenerCommandStep.CHANGE_EXEC_LISTENER_ARG, this.changeExecListener).addArgumentValue(RollbackCommandStep.TAG_ARG, tagToRollBackTo).addArgumentValue(RollbackCommandStep.ROLLBACK_SCRIPT_ARG, rollbackScript).execute();
    }

    public void rollback(Date dateToRollBackTo, String contexts, Writer output) throws LiquibaseException {
        this.rollback(dateToRollBackTo, null, contexts, output);
    }

    public void rollback(Date dateToRollBackTo, String rollbackScript, String contexts, Writer output) throws LiquibaseException {
        this.rollback(dateToRollBackTo, new Contexts(contexts), new LabelExpression(), output);
    }

    public void rollback(Date dateToRollBackTo, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.rollback(dateToRollBackTo, null, contexts, labelExpression, output);
    }

    public void rollback(Date dateToRollBackTo, String rollbackScript, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        new CommandScope(RollbackToDateSqlCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase()).addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile).addArgumentValue(DatabaseChangelogCommandStep.CONTEXTS_ARG, contexts != null ? contexts.toString() : null).addArgumentValue(DatabaseChangelogCommandStep.LABEL_FILTER_ARG, labelExpression != null ? labelExpression.getOriginalString() : null).addArgumentValue(ChangeExecListenerCommandStep.CHANGE_EXEC_LISTENER_ARG, this.changeExecListener).addArgumentValue(RollbackToDateCommandStep.DATE_ARG, dateToRollBackTo).addArgumentValue(AbstractRollbackCommandStep.ROLLBACK_SCRIPT_ARG, rollbackScript).setOutput(new WriterOutputStream(output, GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue())).execute();
    }

    public void rollback(Date dateToRollBackTo, String contexts) throws LiquibaseException {
        this.rollback(dateToRollBackTo, null, contexts);
    }

    public void rollback(Date dateToRollBackTo, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.rollback(dateToRollBackTo, null, contexts, labelExpression);
    }

    public void rollback(Date dateToRollBackTo, String rollbackScript, String contexts) throws LiquibaseException {
        this.rollback(dateToRollBackTo, new Contexts(contexts), new LabelExpression());
    }

    public void rollback(Date dateToRollBackTo, String rollbackScript, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.addCommandFiltersMdc(labelExpression, contexts);
        new CommandScope(RollbackToDateCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase()).addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile).addArgumentValue(DatabaseChangelogCommandStep.CONTEXTS_ARG, contexts != null ? contexts.toString() : null).addArgumentValue(DatabaseChangelogCommandStep.LABEL_FILTER_ARG, labelExpression != null ? labelExpression.getOriginalString() : null).addArgumentValue(ChangeExecListenerCommandStep.CHANGE_EXEC_LISTENER_ARG, this.changeExecListener).addArgumentValue(RollbackToDateCommandStep.DATE_ARG, dateToRollBackTo).addArgumentValue(AbstractRollbackCommandStep.ROLLBACK_SCRIPT_ARG, rollbackScript).execute();
    }

    private Executor getAndReplaceJdbcExecutor(Writer output) {
        Executor oldTemplate = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        LoggingExecutor loggingExecutor = new LoggingExecutor(oldTemplate, output, this.database);
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("logging", this.database, loggingExecutor);
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, loggingExecutor);
        return oldTemplate;
    }

    public void changeLogSync(String contexts, Writer output) throws LiquibaseException {
        this.changeLogSync(new Contexts(contexts), new LabelExpression(), output);
    }

    public void changeLogSync(Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.doChangeLogSyncSql(null, contexts, labelExpression, output, () -> "SQL to add all changesets to database history table");
    }

    private void flushOutputWriter(Writer output) throws LiquibaseException {
        if (output == null) {
            return;
        }
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
    }

    public void changeLogSync(String contexts) throws LiquibaseException {
        this.changeLogSync(new Contexts(contexts), new LabelExpression());
    }

    @Deprecated
    public void changeLogSync(Contexts contexts) throws LiquibaseException {
        this.changeLogSync(contexts, new LabelExpression());
    }

    public void changeLogSync(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogSync(null, contexts, labelExpression);
    }

    public void changeLogSync(String tag, String contexts) throws LiquibaseException {
        this.changeLogSync(tag, new Contexts(contexts), new LabelExpression());
    }

    public void changeLogSync(String tag, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        String commandToRun = StringUtil.isEmpty(tag) ? ChangelogSyncCommandStep.COMMAND_NAME[0] : ChangelogSyncToTagCommandStep.COMMAND_NAME[0];
        this.runInScope(() -> new CommandScope(commandToRun).addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase()).addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile).addArgumentValue(ChangelogSyncCommandStep.HUB_CHANGE_EXEC_LISTENER_ARG, this.changeExecListener).addArgumentValue(DatabaseChangelogCommandStep.CONTEXTS_ARG, contexts != null ? contexts.toString() : null).addArgumentValue(DatabaseChangelogCommandStep.LABEL_FILTER_ARG, labelExpression != null ? labelExpression.getOriginalString() : null).addArgumentValue(ChangelogSyncToTagCommandStep.TAG_ARG, tag).execute());
    }

    public void changeLogSync(String tag, String contexts, Writer output) throws LiquibaseException {
        this.changeLogSync(tag, new Contexts(contexts), new LabelExpression(), output);
    }

    public void changeLogSync(String tag, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.doChangeLogSyncSql(tag, contexts, labelExpression, output, () -> "SQL to add changesets upto '" + tag + "' to database history table");
    }

    private void doChangeLogSyncSql(String tag, Contexts contexts, LabelExpression labelExpression, Writer output, Supplier<String> header) throws LiquibaseException {
        String commandToRun = StringUtil.isEmpty(tag) ? ChangelogSyncSqlCommandStep.COMMAND_NAME[0] : ChangelogSyncToTagSqlCommandStep.COMMAND_NAME[0];
        this.runInScope(() -> new CommandScope(commandToRun).addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase()).addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile).addArgumentValue(ChangelogSyncSqlCommandStep.HUB_CHANGE_EXEC_LISTENER_ARG, this.changeExecListener).addArgumentValue(DatabaseChangelogCommandStep.CONTEXTS_ARG, contexts != null ? contexts.toString() : null).addArgumentValue(DatabaseChangelogCommandStep.LABEL_FILTER_ARG, labelExpression != null ? labelExpression.getOriginalString() : null).addArgumentValue(ChangelogSyncToTagSqlCommandStep.TAG_ARG, tag).setOutput(new WriterOutputStream(output, GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue())).execute());
    }

    public void markNextChangeSetRan(String contexts, Writer output) throws LiquibaseException {
        this.markNextChangeSetRan(new Contexts(contexts), new LabelExpression(), output);
    }

    public void markNextChangeSetRan(Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(() -> {
            Executor oldTemplate = this.getAndReplaceJdbcExecutor(output);
            this.outputHeader("SQL to add all changesets to database history table");
            this.markNextChangeSetRan(contexts, labelExpression);
            this.flushOutputWriter(output);
            Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, oldTemplate);
            this.resetServices();
        });
    }

    public void markNextChangeSetRan(String contexts) throws LiquibaseException {
        this.markNextChangeSetRan(new Contexts(contexts), new LabelExpression());
    }

    public void markNextChangeSetRan(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(() -> {
            LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
            lockService.waitForLock();
            try {
                DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
                ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database).generateDeploymentId();
                this.checkLiquibaseTables(false, changeLog, contexts, labelExpression);
                changeLog.validate(this.database, contexts, labelExpression);
                ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(1));
                logIterator.run(new ChangeLogSyncVisitor(this.database), new RuntimeEnvironment(this.database, contexts, labelExpression));
            }
            finally {
                try {
                    lockService.releaseLock();
                }
                catch (LockException e) {
                    LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e);
                }
                this.resetServices();
            }
        });
    }

    public void futureRollbackSQL(String contexts, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(null, contexts, output, true);
    }

    public void futureRollbackSQL(Writer output) throws LiquibaseException {
        this.futureRollbackSQL(null, null, new Contexts(), new LabelExpression(), output);
    }

    public void futureRollbackSQL(String contexts, Writer output, boolean checkLiquibaseTables) throws LiquibaseException {
        this.futureRollbackSQL(null, contexts, output, checkLiquibaseTables);
    }

    public void futureRollbackSQL(Integer count, String contexts, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(count, new Contexts(contexts), new LabelExpression(), output, true);
    }

    public void futureRollbackSQL(Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(null, null, contexts, labelExpression, output);
    }

    public void futureRollbackSQL(Integer count, String contexts, Writer output, boolean checkLiquibaseTables) throws LiquibaseException {
        this.futureRollbackSQL(count, new Contexts(contexts), new LabelExpression(), output, checkLiquibaseTables);
    }

    public void futureRollbackSQL(Integer count, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(count, contexts, labelExpression, output, true);
    }

    public void futureRollbackSQL(Integer count, Contexts contexts, LabelExpression labelExpression, Writer output, boolean checkLiquibaseTables) throws LiquibaseException {
        this.futureRollbackSQL(count, null, contexts, labelExpression, output);
    }

    public void futureRollbackSQL(String tag, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(null, tag, contexts, labelExpression, output);
    }

    protected void futureRollbackSQL(Integer count, String tag, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(count, tag, contexts, labelExpression, output, true);
    }

    protected void futureRollbackSQL(Integer count, String tag, Contexts contexts, LabelExpression labelExpression, Writer output, boolean checkLiquibaseTables) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(() -> {
            LoggingExecutor outputTemplate = new LoggingExecutor(Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor(this.database), output, this.database);
            Executor oldTemplate = this.getAndReplaceJdbcExecutor(output);
            Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor(this.database, outputTemplate);
            this.outputHeader("SQL to roll back currently unexecuted changes");
            LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
            lockService.waitForLock();
            try {
                ChangeLogIterator logIterator;
                DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
                if (checkLiquibaseTables) {
                    this.checkLiquibaseTables(false, changeLog, contexts, labelExpression);
                }
                ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database).generateDeploymentId();
                changeLog.validate(this.database, contexts, labelExpression);
                if (count == null && tag == null) {
                    logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(this.database));
                } else if (count != null) {
                    ChangeLogIterator forwardIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(count));
                    ListVisitor listVisitor = new ListVisitor();
                    forwardIterator.run(listVisitor, new RuntimeEnvironment(this.database, contexts, labelExpression));
                    logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(this.database), new IgnoreChangeSetFilter(), changeSet -> new ChangeSetFilterResult(listVisitor.getSeenChangeSets().contains(changeSet), null, null));
                } else {
                    List<RanChangeSet> ranChangeSetList = this.database.getRanChangeSetList();
                    UpToTagChangeSetFilter upToTagChangeSetFilter = new UpToTagChangeSetFilter(tag, ranChangeSetList);
                    ChangeLogIterator forwardIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(this.database), new IgnoreChangeSetFilter(), upToTagChangeSetFilter);
                    ListVisitor listVisitor = new ListVisitor();
                    forwardIterator.run(listVisitor, new RuntimeEnvironment(this.database, contexts, labelExpression));
                    if (!upToTagChangeSetFilter.isSeenTag()) {
                        String message = "No tag matching '" + tag + "' found";
                        Scope.getCurrentScope().getUI().sendMessage("ERROR: " + message);
                        Scope.getCurrentScope().getLog(Liquibase.class).severe(message);
                        throw new LiquibaseException(new IllegalArgumentException(message));
                    }
                    logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(this.database), new IgnoreChangeSetFilter(), changeSet -> new ChangeSetFilterResult(listVisitor.getSeenChangeSets().contains(changeSet), null, null));
                }
                logIterator.run(this.createRollbackVisitor(), new RuntimeEnvironment(this.database, contexts, labelExpression));
            }
            finally {
                try {
                    lockService.releaseLock();
                }
                catch (LockException e) {
                    LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e);
                }
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, oldTemplate);
                this.resetServices();
            }
            this.flushOutputWriter(output);
        });
    }

    protected void resetServices() {
        LockServiceFactory.getInstance().resetAll();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
        Scope.getCurrentScope().getSingleton(ExecutorService.class).reset();
    }

    public final void dropAll() throws DatabaseException {
        this.dropAll(new CatalogAndSchema(this.getDatabase().getDefaultCatalogName(), this.getDatabase().getDefaultSchemaName()));
    }

    public final void dropAll(CatalogAndSchema ... schemas) throws DatabaseException {
        if (schemas == null || schemas.length == 0) {
            schemas = new CatalogAndSchema[]{new CatalogAndSchema(this.getDatabase().getDefaultCatalogName(), this.getDatabase().getDefaultSchemaName())};
        }
        CatalogAndSchema[] finalSchemas = schemas;
        try {
            CommandScope dropAll = new CommandScope("internalDropAll").addArgumentValue(InternalDropAllCommandStep.DATABASE_ARG, this.getDatabase()).addArgumentValue(InternalDropAllCommandStep.SCHEMAS_ARG, finalSchemas);
            try {
                dropAll.execute();
            }
            catch (CommandExecutionException e) {
                throw new DatabaseException(e);
            }
        }
        catch (LiquibaseException e) {
            if (e instanceof DatabaseException) {
                throw (DatabaseException)e;
            }
            throw new DatabaseException(e);
        }
    }

    @Deprecated
    public void tag(String tagString) throws LiquibaseException {
        new CommandScope("tag").addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.database).addArgumentValue(TagCommandStep.TAG_ARG, tagString).execute();
    }

    @Deprecated
    public boolean tagExists(String tagString) throws LiquibaseException {
        CommandResults commandResults = new CommandScope("tagExists").addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.database).addArgumentValue(TagExistsCommandStep.TAG_ARG, tagString).execute();
        return commandResults.getResult(TagExistsCommandStep.TAG_EXISTS_RESULT);
    }

    public void updateTestingRollback(String contexts) throws LiquibaseException {
        this.updateTestingRollback(new Contexts(contexts), new LabelExpression());
    }

    public void updateTestingRollback(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.updateTestingRollback(null, contexts, labelExpression);
    }

    public void updateTestingRollback(String tag, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        ChangeLogHistoryService changeLogService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
        int originalSize = changeLogService.getRanChangeSets().size();
        this.update(tag, contexts, labelExpression);
        changeLogService.reset();
        int changesetsToRollback = changeLogService.getRanChangeSets().size() - originalSize;
        Scope.getCurrentScope().getLog(this.getClass()).info(String.format("Rolling back %d changeset(s).", changesetsToRollback));
        this.rollback(changesetsToRollback, null, contexts, labelExpression);
        this.update(tag, contexts, labelExpression);
    }

    public void checkLiquibaseTables(boolean updateExistingNullChecksums, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.getDatabase());
        changeLogHistoryService.init();
        if (updateExistingNullChecksums) {
            changeLogHistoryService.upgradeChecksums(databaseChangeLog, contexts, labelExpression);
        }
        LockServiceFactory.getInstance().getLockService(this.getDatabase()).init();
    }

    public boolean isSafeToRunUpdate() throws DatabaseException {
        return this.getDatabase().isSafeToRunUpdate();
    }

    @Deprecated
    public DatabaseChangeLogLock[] listLocks() throws LiquibaseException {
        return ListLocksCommandStep.listLocks(this.database);
    }

    @Deprecated
    public void reportLocks(PrintStream out) throws LiquibaseException {
        this.runInScope(() -> {
            CommandScope listLocksCommand = new CommandScope(ListLocksCommandStep.COMMAND_NAME);
            listLocksCommand.addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase());
            listLocksCommand.setOutput(out);
            listLocksCommand.execute();
        });
    }

    public void forceReleaseLocks() throws LiquibaseException {
        new CommandScope(ReleaseLocksCommandStep.COMMAND_NAME[0]).addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase()).execute();
    }

    @Deprecated
    public List<ChangeSet> listUnrunChangeSets(Contexts contexts) throws LiquibaseException {
        return this.listUnrunChangeSets(contexts, new LabelExpression());
    }

    @Deprecated
    public List<ChangeSet> listUnrunChangeSets(Contexts contexts, LabelExpression labels) throws LiquibaseException {
        return this.listUnrunChangeSets(contexts, labels, true);
    }

    @Deprecated
    public List<ChangeSet> listUnrunChangeSets(Contexts contexts, LabelExpression labels, boolean checkLiquibaseTables) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labels);
        ListVisitor visitor = new ListVisitor();
        this.runInScope(() -> {
            DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
            if (checkLiquibaseTables) {
                this.checkLiquibaseTables(true, changeLog, contexts, labels);
            }
            changeLog.validate(this.database, contexts, labels);
            ChangeLogIterator logIterator = this.getStandardChangelogIterator(contexts, labels, changeLog);
            logIterator.run(visitor, new RuntimeEnvironment(this.database, contexts, labels));
        });
        return visitor.getSeenChangeSets();
    }

    @Deprecated
    public List<ChangeSetStatus> getChangeSetStatuses(Contexts contexts) throws LiquibaseException {
        return this.getChangeSetStatuses(contexts, new LabelExpression());
    }

    public List<ChangeSetStatus> getChangeSetStatuses(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        return this.getChangeSetStatuses(contexts, labelExpression, true);
    }

    public List<ChangeSetStatus> getChangeSetStatuses(Contexts contexts, LabelExpression labelExpression, boolean checkLiquibaseTables) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        StatusVisitor visitor = new StatusVisitor(this.database);
        this.runInScope(() -> {
            DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
            if (checkLiquibaseTables) {
                this.checkLiquibaseTables(true, changeLog, contexts, labelExpression);
            }
            changeLog.validate(this.database, contexts, labelExpression);
            ChangeLogIterator logIterator = this.getStandardChangelogIterator(contexts, labelExpression, changeLog);
            logIterator.run(visitor, new RuntimeEnvironment(this.database, contexts, labelExpression));
        });
        return visitor.getStatuses();
    }

    @Deprecated
    public void reportStatus(boolean verbose, String contexts, Writer out) throws LiquibaseException {
        this.reportStatus(verbose, new Contexts(contexts), new LabelExpression(), out);
    }

    @Deprecated
    public void reportStatus(boolean verbose, Contexts contexts, Writer out) throws LiquibaseException {
        this.reportStatus(verbose, contexts, new LabelExpression(), out);
    }

    @Deprecated
    public void reportStatus(boolean verbose, Contexts contexts, LabelExpression labels, Writer out) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labels);
        this.runInScope(() -> {
            CommandScope statusCommand = new CommandScope(StatusCommandStep.COMMAND_NAME);
            statusCommand.addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase());
            statusCommand.addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_PARAMETERS, this.changeLogParameters);
            statusCommand.addArgumentValue(StatusCommandStep.VERBOSE_ARG, verbose);
            statusCommand.addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile);
            statusCommand.setOutput(new WriterOutputStream(out, GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue()));
            statusCommand.execute();
        });
    }

    public Collection<RanChangeSet> listUnexpectedChangeSets(String contexts) throws LiquibaseException {
        return this.listUnexpectedChangeSets(new Contexts(contexts), new LabelExpression());
    }

    public Collection<RanChangeSet> listUnexpectedChangeSets(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        ExpectedChangesVisitor visitor = new ExpectedChangesVisitor(this.database.getRanChangeSetList());
        this.runInScope(() -> {
            DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
            changeLog.validate(this.database, contexts, labelExpression);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(this.database), new IgnoreChangeSetFilter());
            logIterator.run(visitor, new RuntimeEnvironment(this.database, contexts, labelExpression));
        });
        return visitor.getUnexpectedChangeSets();
    }

    public void reportUnexpectedChangeSets(boolean verbose, String contexts, Writer out) throws LiquibaseException {
        this.reportUnexpectedChangeSets(verbose, new Contexts(contexts), new LabelExpression(), out);
    }

    public void reportUnexpectedChangeSets(boolean verbose, Contexts contexts, LabelExpression labelExpression, Writer out) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.checkLiquibaseTables(false, this.getDatabaseChangeLog(true), null, null);
        try {
            Collection<RanChangeSet> unexpectedChangeSets = this.listUnexpectedChangeSets(contexts, labelExpression);
            if (unexpectedChangeSets.isEmpty()) {
                out.append(this.getDatabase().getConnection().getConnectionUserName());
                out.append("@");
                out.append(this.getDatabase().getConnection().getURL());
                out.append(" contains no unexpected changes!");
                out.append(StreamUtil.getLineSeparator());
            } else {
                out.append(String.valueOf(unexpectedChangeSets.size()));
                out.append(" unexpected changes were found in ");
                out.append(this.getDatabase().getConnection().getConnectionUserName());
                out.append("@");
                out.append(this.getDatabase().getConnection().getURL());
                out.append(StreamUtil.getLineSeparator());
                if (verbose) {
                    for (RanChangeSet ranChangeSet : unexpectedChangeSets) {
                        out.append("     ").append(ranChangeSet.toString()).append(StreamUtil.getLineSeparator());
                    }
                }
            }
            out.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
    }

    public void clearCheckSums() throws LiquibaseException {
        LOG.info("Clearing database change log checksums");
        this.runInScope(() -> {
            LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
            lockService.waitForLock();
            try {
                this.checkLiquibaseTables(false, null, new Contexts(), new LabelExpression());
                ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database).clearAllCheckSums();
            }
            finally {
                try {
                    lockService.releaseLock();
                }
                catch (LockException e) {
                    LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e);
                }
            }
            this.resetServices();
        });
    }

    @Deprecated
    public final CheckSum calculateCheckSum(String changeSetIdentifier) throws LiquibaseException {
        CommandResults commandResults = new CommandScope("calculateChecksum").addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.database).addArgumentValue(CalculateChecksumCommandStep.CHANGESET_IDENTIFIER_ARG, changeSetIdentifier).addArgumentValue(CalculateChecksumCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile).execute();
        return commandResults.getResult(CalculateChecksumCommandStep.CHECKSUM_RESULT);
    }

    @Deprecated
    public CheckSum calculateCheckSum(String filename, String id, String author) throws LiquibaseException {
        return this.calculateCheckSum(String.format("%s::%s::%s", filename, id, author));
    }

    public void generateDocumentation(String outputDirectory) throws LiquibaseException {
        this.generateDocumentation(outputDirectory, new Contexts(), new LabelExpression(), new CatalogAndSchema(null, null));
    }

    public void generateDocumentation(String outputDirectory, String contexts) throws LiquibaseException {
        this.generateDocumentation(outputDirectory, new Contexts(contexts), new LabelExpression(), new CatalogAndSchema(null, null));
    }

    public void generateDocumentation(String outputDirectory, String contexts, CatalogAndSchema ... schemaList) throws LiquibaseException {
        this.generateDocumentation(outputDirectory, new Contexts(contexts), new LabelExpression(), schemaList);
    }

    public void generateDocumentation(String outputDirectory, Contexts contexts, LabelExpression labelExpression, CatalogAndSchema ... schemaList) throws LiquibaseException {
        this.runInScope(() -> {
            LOG.info("Generating Database Documentation");
            this.changeLogParameters.setContexts(contexts);
            this.changeLogParameters.setLabels(labelExpression);
            LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
            lockService.waitForLock();
            try {
                DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
                this.checkLiquibaseTables(false, changeLog, new Contexts(), new LabelExpression());
                changeLog.validate(this.database, contexts, labelExpression);
                ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new DbmsChangeSetFilter(this.database));
                DBDocVisitor visitor = new DBDocVisitor(this.database);
                logIterator.run(visitor, new RuntimeEnvironment(this.database, contexts, labelExpression));
                PathHandlerFactory pathHandlerFactory = Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
                Resource resource = pathHandlerFactory.getResource(outputDirectory);
                visitor.writeHTML(resource, this.resourceAccessor, schemaList);
            }
            catch (IOException e) {
                throw new LiquibaseException(e);
            }
            finally {
                try {
                    lockService.releaseLock();
                }
                catch (LockException e) {
                    LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e);
                }
            }
        });
    }

    @Deprecated
    public DiffResult diff(Database referenceDatabase, Database targetDatabase, CompareControl compareControl) throws LiquibaseException {
        return DiffGeneratorFactory.getInstance().compare(referenceDatabase, targetDatabase, compareControl);
    }

    public void validate() throws LiquibaseException {
        DatabaseChangeLog changeLog = this.getDatabaseChangeLog(true);
        this.checkLiquibaseTables(false, changeLog, null, null);
        if (changeLog != null) {
            changeLog.validate(this.database, new String[0]);
        }
    }

    public void setChangeLogParameter(String key, Object value) {
        this.changeLogParameters.set(key, value);
    }

    public void setChangeExecListener(ChangeExecListener listener) {
        this.changeExecListener = listener;
    }

    public DefaultChangeExecListener getDefaultChangeExecListener() {
        return this.defaultChangeExecListener;
    }

    @Deprecated
    @SafeVarargs
    public final void generateChangeLog(CatalogAndSchema catalogAndSchema, DiffToChangeLog changeLogWriter, PrintStream outputStream, Class<? extends DatabaseObject> ... snapshotTypes) throws DatabaseException, CommandExecutionException {
        this.generateChangeLog(catalogAndSchema, changeLogWriter, outputStream, (ChangeLogSerializer)null, snapshotTypes);
    }

    @Deprecated
    @SafeVarargs
    public final void generateChangeLog(CatalogAndSchema catalogAndSchema, DiffToChangeLog changeLogWriter, PrintStream outputStream, ChangeLogSerializer changeLogSerializer, Class<? extends DatabaseObject> ... snapshotTypes) throws DatabaseException, CommandExecutionException {
        HashSet<Class<? extends DatabaseObject>> finalCompareTypes = null;
        if (snapshotTypes != null && snapshotTypes.length > 0) {
            finalCompareTypes = new HashSet<Class<? extends DatabaseObject>>(Arrays.asList(snapshotTypes));
        }
        CompareControl compareControl = new CompareControl(new CompareControl.SchemaComparison[]{new CompareControl.SchemaComparison(catalogAndSchema, catalogAndSchema)}, finalCompareTypes);
        new CommandScope(GenerateChangelogCommandStep.COMMAND_NAME[0]).addArgumentValue(GenerateChangelogCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile).addArgumentValue(PreCompareCommandStep.COMPARE_CONTROL_ARG, compareControl).addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, this.getDatabase()).addArgumentValue(PreCompareCommandStep.SNAPSHOT_TYPES_ARG, snapshotTypes).setOutput(outputStream).execute();
    }

    private void runInScope(Scope.ScopedRunner scopedRunner) throws LiquibaseException {
        HashMap<String, Object> scopeObjects = new HashMap<String, Object>();
        scopeObjects.put(Scope.Attr.database.name(), this.getDatabase());
        scopeObjects.put(Scope.Attr.resourceAccessor.name(), this.getResourceAccessor());
        try {
            Scope.child(scopeObjects, scopedRunner);
        }
        catch (Exception e) {
            if (e instanceof LiquibaseException) {
                throw (LiquibaseException)e;
            }
            throw new LiquibaseException(e);
        }
    }

    @Override
    public void close() throws LiquibaseException {
        if (this.database != null) {
            this.database.close();
        }
    }
}

