/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.Beta;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.UpdateSummaryEnum;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.StatusChangeLogIterator;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.DefaultChangeExecListener;
import liquibase.changelog.visitor.ListVisitor;
import liquibase.changelog.visitor.StatusVisitor;
import liquibase.changelog.visitor.UpdateVisitor;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CleanUpCommandStep;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.DatabaseChangelogCommandStep;
import liquibase.command.core.helpers.HubHandler;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.executor.ExecutorService;
import liquibase.hub.listener.HubChangeExecListener;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.core.BufferedLogService;
import liquibase.logging.core.CompositeLogService;
import liquibase.logging.mdc.MdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsUpdated;
import liquibase.util.ShowSummaryUtil;

public abstract class AbstractUpdateCommandStep
extends AbstractCommandStep
implements CleanUpCommandStep {
    public static final String DEFAULT_CHANGE_EXEC_LISTENER_RESULT_KEY = "defaultChangeExecListener";
    private static final Map<String, Boolean> upToDateFastCheck = new ConcurrentHashMap<String, Boolean>();

    public abstract String getChangelogFileArg(CommandScope var1);

    public abstract String getContextsArg(CommandScope var1);

    public abstract String getLabelFilterArg(CommandScope var1);

    public abstract String[] getCommandName();

    public abstract UpdateSummaryEnum getShowSummary(CommandScope var1);

    protected abstract String getHubOperation();

    @Override
    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(Database.class, LockService.class, DatabaseChangeLog.class, ChangeExecListener.class, ChangeLogParameters.class);
    }

    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String changeLogFile = this.getChangelogFileArg(commandScope);
        Database database = (Database)commandScope.getDependency(Database.class);
        Contexts contexts = new Contexts(this.getContextsArg(commandScope));
        LabelExpression labelExpression = new LabelExpression(this.getLabelFilterArg(commandScope));
        ChangeLogParameters changeLogParameters = (ChangeLogParameters)commandScope.getDependency(ChangeLogParameters.class);
        DatabaseChangelogCommandStep.addCommandFiltersMdc(labelExpression, contexts);
        this.customMdcLogging(commandScope);
        BufferedLogService bufferLog = new BufferedLogService();
        HubHandler hubHandler = null;
        DefaultChangeExecListener defaultChangeExecListener = (DefaultChangeExecListener)commandScope.getDependency(ChangeExecListener.class);
        defaultChangeExecListener.reset();
        resultsBuilder.addResult(DEFAULT_CHANGE_EXEC_LISTENER_RESULT_KEY, defaultChangeExecListener);
        try {
            DatabaseChangeLog databaseChangeLog = (DatabaseChangeLog)commandScope.getDependency(DatabaseChangeLog.class);
            if (this.isUpToDate(commandScope, database, databaseChangeLog, contexts, labelExpression, resultsBuilder.getOutputStream())) {
                return;
            }
            ChangeLogHistoryService changelogService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database);
            Scope.getCurrentScope().addMdcValue("deploymentId", changelogService.getDeploymentId());
            Scope.getCurrentScope().getLog(this.getClass()).info(String.format("Using deploymentId: %s", changelogService.getDeploymentId()));
            hubHandler = new HubHandler(database, databaseChangeLog, changeLogFile, defaultChangeExecListener);
            ChangeLogIterator changeLogIterator = this.getStandardChangelogIterator(commandScope, database, contexts, labelExpression, databaseChangeLog);
            HubChangeExecListener hubChangeExecListener = hubHandler.startHubForUpdate(changeLogParameters, changeLogIterator, this.getHubOperation());
            StatusVisitor statusVisitor = new StatusVisitor(database);
            ChangeLogIterator shouldRunIterator = this.getStatusChangelogIterator(commandScope, database, contexts, labelExpression, databaseChangeLog);
            shouldRunIterator.run(statusVisitor, new RuntimeEnvironment(database, contexts, labelExpression));
            ChangeLogIterator runChangeLogIterator = this.getStandardChangelogIterator(commandScope, database, contexts, labelExpression, databaseChangeLog);
            HashMap<String, Object> scopeValues = new HashMap<String, Object>();
            if (hubChangeExecListener != null) {
                CompositeLogService compositeLogService = new CompositeLogService(true, bufferLog);
                scopeValues.put(Scope.Attr.logService.name(), compositeLogService);
            }
            scopeValues.put("showSummary", (Object)this.getShowSummary(commandScope));
            Scope.child(scopeValues, () -> {
                ChangeExecListener listenerToUse = hubChangeExecListener != null ? hubChangeExecListener : defaultChangeExecListener;
                runChangeLogIterator.run(new UpdateVisitor(database, listenerToUse), new RuntimeEnvironment(database, contexts, labelExpression));
                ShowSummaryUtil.showUpdateSummary(databaseChangeLog, this.getShowSummary(commandScope), statusVisitor, resultsBuilder.getOutputStream());
            });
            hubHandler.postUpdateHub(bufferLog);
            resultsBuilder.addResult("statusCode", (Object)0);
            this.logDeploymentOutcomeMdc(defaultChangeExecListener, true);
            this.postUpdateLog();
        }
        catch (Exception e) {
            this.logDeploymentOutcomeMdc(defaultChangeExecListener, false);
            resultsBuilder.addResult("statusCode", (Object)1);
            if (hubHandler != null) {
                hubHandler.postUpdateHubExceptionHandling(bufferLog, e.getMessage());
            }
            throw e;
        }
        finally {
            try {
                LockServiceFactory.getInstance().getLockService(database).releaseLock();
            }
            catch (LockException e) {
                Scope.getCurrentScope().getLog(this.getClass()).severe(Liquibase.MSG_COULD_NOT_RELEASE_LOCK, e);
            }
        }
    }

    protected void customMdcLogging(CommandScope commandScope) {
    }

    @Override
    public void cleanUp(CommandResultsBuilder resultsBuilder) {
        LockServiceFactory.getInstance().resetAll();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
        Scope.getCurrentScope().getSingleton(ExecutorService.class).reset();
    }

    private void logDeploymentOutcomeMdc(DefaultChangeExecListener defaultListener, boolean success) throws IOException {
        List<ChangeSet> deployedChangeSets = defaultListener.getDeployedChangeSets();
        int deployedChangeSetCount = deployedChangeSets.size();
        ChangesetsUpdated changesetsUpdated = new ChangesetsUpdated(deployedChangeSets);
        String successLog = "Update command completed successfully.";
        String failureLog = "Update command encountered an exception.";
        try (MdcObject deploymentOutcomeMdc = Scope.getCurrentScope().addMdcValue("deploymentOutcome", success ? "success" : "fail");
             MdcObject deploymentOutcomeCountMdc = Scope.getCurrentScope().addMdcValue("deploymentOutcomeCount", String.valueOf(deployedChangeSetCount));
             MdcObject changesetsUpdatesMdc = Scope.getCurrentScope().addMdcValue("changesetsUpdated", changesetsUpdated);){
            Scope.getCurrentScope().getLog(this.getClass()).info(success ? successLog : failureLog);
        }
    }

    @Beta
    public ChangeLogIterator getStandardChangelogIterator(CommandScope commandScope, Database database, Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog changeLog) throws DatabaseException {
        return new ChangeLogIterator(changeLog, new ShouldRunChangeSetFilter(database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(database), new IgnoreChangeSetFilter());
    }

    @Beta
    public ChangeLogIterator getStatusChangelogIterator(CommandScope commandScope, Database database, Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog changeLog) throws DatabaseException {
        return new StatusChangeLogIterator(changeLog, new ShouldRunChangeSetFilter(database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(database), new IgnoreChangeSetFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUpToDateFastCheck(CommandScope commandScope, Database database, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        String cacheKey = contexts + "/" + labelExpression;
        if (!upToDateFastCheck.containsKey(cacheKey)) {
            try {
                if (this.listUnrunChangeSets(commandScope, database, databaseChangeLog, contexts, labelExpression).isEmpty()) {
                    Scope.getCurrentScope().getLog(this.getClass()).fine("Fast check found no un-run changesets");
                    upToDateFastCheck.put(cacheKey, true);
                } else {
                    upToDateFastCheck.put(cacheKey, false);
                }
            }
            catch (DatabaseException e) {
                Scope.getCurrentScope().getLog(this.getClass()).info("Error querying Liquibase tables, disabling fast check for this execution. Reason: " + e.getMessage());
                upToDateFastCheck.put(cacheKey, false);
            }
            finally {
                ChangeLogHistoryService changeLogService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database);
                changeLogService.reset();
            }
        }
        return upToDateFastCheck.get(cacheKey);
    }

    private List<ChangeSet> listUnrunChangeSets(CommandScope commandScope, Database database, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labels) throws LiquibaseException {
        ListVisitor visitor = new ListVisitor();
        databaseChangeLog.validate(database, contexts, labels);
        ChangeLogIterator logIterator = this.getStandardChangelogIterator(commandScope, database, contexts, labels, databaseChangeLog);
        logIterator.run(visitor, new RuntimeEnvironment(database, contexts, labels));
        return visitor.getSeenChangeSets();
    }

    @Beta
    public boolean isUpToDate(CommandScope commandScope, Database database, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labelExpression, OutputStream outputStream) throws LiquibaseException, IOException {
        if (this.isUpToDateFastCheck(commandScope, database, databaseChangeLog, contexts, labelExpression)) {
            Scope.getCurrentScope().getUI().sendMessage("Database is up to date, no changesets to execute");
            StatusVisitor statusVisitor = new StatusVisitor(database);
            ChangeLogIterator shouldRunIterator = this.getStatusChangelogIterator(commandScope, database, contexts, labelExpression, databaseChangeLog);
            shouldRunIterator.run(statusVisitor, new RuntimeEnvironment(database, contexts, labelExpression));
            UpdateSummaryEnum showSummary = this.getShowSummary(commandScope);
            ShowSummaryUtil.showUpdateSummary(databaseChangeLog, showSummary, statusVisitor, outputStream);
            return true;
        }
        return false;
    }

    @Beta
    public void postUpdateLog() {
    }
}

