/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;

public class MavenResourceAccessor
implements ResourceAccessor {
    private ClassLoader _loader;

    public MavenResourceAccessor() {
        this(MavenResourceAccessor.class.getClassLoader());
    }

    public MavenResourceAccessor(ClassLoader cl) {
        this._loader = cl;
    }

    public InputStream getResourceAsStream(String file) throws IOException {
        file = file.replaceFirst("^target/classes/", "");
        return this._loader.getResourceAsStream(file);
    }

    public Enumeration<URL> getResources(String packageName) throws IOException {
        packageName = packageName.replaceFirst("^target/classes/", "");
        return this._loader.getResources(packageName);
    }

    public ClassLoader toClassLoader() {
        return this._loader;
    }

    public String toString() {
        String description;
        if (this._loader instanceof URLClassLoader) {
            ArrayList<String> urls = new ArrayList<String>();
            for (URL url : ((URLClassLoader)this._loader).getURLs()) {
                urls.add(url.toExternalForm());
            }
            description = StringUtils.join(urls, (String)",");
        } else {
            description = this._loader.getClass().getName();
        }
        return this.getClass().getName() + "(" + description + ")";
    }
}

