/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import liquibase.GlobalConfiguration;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.util.StringUtil;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseMojo;
import org.liquibase.maven.property.PropertyElement;

public class LiquibaseGenerateChangeLogMojo
extends AbstractLiquibaseMojo {
    @PropertyElement
    protected String diffTypes;
    @PropertyElement
    protected String dataDir;
    @PropertyElement
    protected String changeSetAuthor;
    @PropertyElement
    protected String contexts;
    @PropertyElement
    protected String changeSetContext;
    @PropertyElement
    protected String outputChangeLogFile;
    @PropertyElement
    protected String diffExcludeObjects;
    @PropertyElement
    protected String diffIncludeObjects;

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        ClassLoader cl = null;
        try {
            cl = this.getClassLoaderIncludingProjectClasspath();
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (MojoExecutionException e) {
            throw new LiquibaseException("Could not create the class loader, " + (Object)((Object)e), (Throwable)e);
        }
        Database database = liquibase.getDatabase();
        this.getLog().info((CharSequence)("Generating Change Log from database " + database.toString()));
        try {
            DiffOutputControl diffOutputControl = new DiffOutputControl(this.outputDefaultCatalog, this.outputDefaultSchema, true, null);
            if (this.diffExcludeObjects != null && this.diffIncludeObjects != null) {
                throw new UnexpectedLiquibaseException("Cannot specify both excludeObjects and includeObjects");
            }
            if (this.diffExcludeObjects != null) {
                diffOutputControl.setObjectChangeFilter((ObjectChangeFilter)new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, this.diffExcludeObjects));
            }
            if (this.diffIncludeObjects != null) {
                diffOutputControl.setObjectChangeFilter((ObjectChangeFilter)new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.INCLUDE, this.diffIncludeObjects));
            }
            boolean b = this.dataDir != null;
            Scope.child((String)GlobalConfiguration.SHOULD_SNAPSHOT_DATA.getKey(), (Object)b, () -> {
                CommandLineUtils.doGenerateChangeLog((String)this.outputChangeLogFile, (Database)database, (String)this.defaultCatalogName, (String)this.defaultSchemaName, (String)StringUtil.trimToNull((String)this.diffTypes), (String)StringUtil.trimToNull((String)this.changeSetAuthor), (String)StringUtil.trimToNull((String)this.changeSetContext), (String)StringUtil.trimToNull((String)this.dataDir), (DiffOutputControl)diffOutputControl);
                this.getLog().info((CharSequence)("Output written to Change Log file, " + this.outputChangeLogFile));
            });
        }
        catch (Exception e) {
            throw new LiquibaseException((Throwable)e);
        }
    }

    @Override
    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        super.checkRequiredParametersAreSpecified();
        if (this.outputChangeLogFile == null) {
            throw new MojoFailureException("The outputChangeLogFile property must be specified.");
        }
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "defaultSchemaName: " + this.defaultSchemaName));
        this.getLog().info((CharSequence)(indent + "diffTypes: " + this.diffTypes));
        this.getLog().info((CharSequence)(indent + "dataDir: " + this.dataDir));
    }
}

