/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.spring;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.liquigraph.core.io.xml.ChangelogLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public final class SpringChangelogLoader
implements ChangelogLoader {
    private final ResourceLoader resourceLoader;

    public SpringChangelogLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = Objects.requireNonNull(resourceLoader, "Resource loader may not be null");
    }

    public InputStream load(String changelog) throws IOException {
        Resource resource = this.resourceLoader.getResource(changelog);
        if (resource == null) {
            return null;
        }
        return resource.getInputStream();
    }
}

