/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.spring;

import java.util.Arrays;
import javax.sql.DataSource;
import org.liquigraph.core.api.Liquigraph;
import org.liquigraph.core.configuration.Configuration;
import org.liquigraph.core.configuration.ConfigurationBuilder;
import org.liquigraph.core.io.xml.ChangelogLoader;
import org.springframework.beans.factory.InitializingBean;

public final class SpringLiquigraph
implements InitializingBean {
    private final DataSource dataSource;
    private final ChangelogLoader changelogLoader;
    private final String changeLog;
    private String[] executionContexts;

    public SpringLiquigraph(DataSource dataSource, ChangelogLoader changelogLoader, String changelog, String[] executionContexts) {
        this.dataSource = dataSource;
        this.changelogLoader = changelogLoader;
        this.changeLog = changelog;
        this.executionContexts = executionContexts;
    }

    public void afterPropertiesSet() {
        Configuration configuration = new ConfigurationBuilder().withDataSource(this.dataSource).withChangelogLoader(this.changelogLoader).withMasterChangelogLocation(this.changeLog).withExecutionContexts(Arrays.asList(this.executionContexts)).withRunMode().build();
        new Liquigraph().runMigrations(configuration);
    }
}

