/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.spring.starter;

import javax.sql.DataSource;
import org.liquigraph.core.api.Liquigraph;
import org.liquigraph.spring.SpringChangelogLoader;
import org.liquigraph.spring.SpringLiquigraph;
import org.liquigraph.spring.starter.LiquigraphDataSource;
import org.liquigraph.spring.starter.LiquigraphProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@Configuration
@ConditionalOnClass(value={Liquigraph.class})
@ConditionalOnProperty(prefix="liquigraph", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class LiquigraphAutoConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={SpringLiquigraph.class})
    @EnableConfigurationProperties(value={LiquigraphProperties.class})
    public static class LiquigraphConfiguration {
        private final LiquigraphProperties properties;
        private final DataSource dataSource;
        private final DataSource liquigraphDataSource;

        public LiquigraphConfiguration(LiquigraphProperties properties, ObjectProvider<DataSource> dataSource, @LiquigraphDataSource ObjectProvider<DataSource> liquigraphDataSourceProvider) {
            this.properties = properties;
            this.dataSource = (DataSource)dataSource.getIfAvailable();
            this.liquigraphDataSource = (DataSource)liquigraphDataSourceProvider.getIfAvailable();
        }

        @Bean
        public SpringLiquigraph liquigraph(ResourceLoader loader) {
            SpringChangelogLoader changelogLoader = new SpringChangelogLoader(loader);
            return new SpringLiquigraph(this.getDataSource(), changelogLoader, this.properties.getChangeLog(), this.properties.getExecutionContexts());
        }

        private DataSource getDataSource() {
            if (this.liquigraphDataSource != null) {
                return this.liquigraphDataSource;
            }
            String datasourceUrl = this.properties.getUrl();
            if (datasourceUrl != null) {
                return DataSourceBuilder.create().url(datasourceUrl).username(this.properties.getUser()).password(this.properties.getPassword()).build();
            }
            return this.dataSource;
        }
    }
}

