/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.id.AbstractStringIdentifierGenerator;
import org.apache.commons.id.StringIdentifierGenerator;

public class CompositeIdentifierGenerator
extends AbstractStringIdentifierGenerator
implements Serializable {
    private static final long serialVersionUID = 20060206L;
    private final StringIdentifierGenerator[] identifierGenerators;

    public static StringIdentifierGenerator getInstance(StringIdentifierGenerator[] generators) {
        if (generators == null) {
            throw new IllegalArgumentException("Generator array must not be null");
        }
        if (generators.length == 0) {
            throw new IllegalArgumentException("Generator array must not be empty");
        }
        StringIdentifierGenerator[] generatorsCopy = new StringIdentifierGenerator[generators.length];
        for (int i = 0; i < generators.length; ++i) {
            if (generators[i] == null) {
                throw new IllegalArgumentException("Generators must not be null");
            }
            generatorsCopy[i] = generators[i];
        }
        return new CompositeIdentifierGenerator(generatorsCopy);
    }

    public static StringIdentifierGenerator getInstance(Collection generators) {
        if (generators == null) {
            throw new IllegalArgumentException("Generator collection must not be null");
        }
        if (generators.size() == 0) {
            throw new IllegalArgumentException("Generator collection must not be empty");
        }
        StringIdentifierGenerator[] generatorsCopy = new StringIdentifierGenerator[generators.size()];
        int i = 0;
        Iterator it = generators.iterator();
        while (it.hasNext()) {
            generatorsCopy[i] = (StringIdentifierGenerator)it.next();
            if (generatorsCopy[i] == null) {
                throw new IllegalArgumentException("Generators must not be null");
            }
            ++i;
        }
        return new CompositeIdentifierGenerator(generatorsCopy);
    }

    public CompositeIdentifierGenerator(StringIdentifierGenerator[] identifierGenerators) {
        this.identifierGenerators = identifierGenerators;
    }

    @Override
    public String nextStringIdentifier() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.identifierGenerators.length; ++i) {
            buffer.append(this.identifierGenerators[i].nextStringIdentifier());
        }
        return buffer.toString();
    }

    @Override
    public long maxLength() {
        long length = 0L;
        for (int i = 0; i < this.identifierGenerators.length; ++i) {
            length += this.identifierGenerators[i].maxLength();
        }
        return length;
    }

    @Override
    public long minLength() {
        long length = 0L;
        for (int i = 0; i < this.identifierGenerators.length; ++i) {
            length += this.identifierGenerators[i].minLength();
        }
        return length;
    }

    public StringIdentifierGenerator[] getIdentifierGenerators() {
        int len = this.identifierGenerators.length;
        StringIdentifierGenerator[] out = new StringIdentifierGenerator[len];
        System.arraycopy(this.identifierGenerators, 0, out, 0, len);
        return out;
    }
}

