/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.uuid.state;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.id.uuid.state.Node;
import org.apache.commons.id.uuid.state.ReadOnlyResourceStateImpl;
import org.apache.commons.id.uuid.state.State;
import org.apache.commons.id.uuid.state.StateHelper;

public class ReadWriteFileStateImpl
extends ReadOnlyResourceStateImpl
implements State {
    @Override
    public void store(Set nodes) throws IOException {
        this.writeXML(this.genXML(nodes));
    }

    private String genXML(Set nodes) throws IOException {
        Iterator it = nodes.iterator();
        StringBuffer buf = new StringBuffer(1024);
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE uuidstate [\n   <!ELEMENT uuidstate (node*)>\n   <!ELEMENT node EMPTY>\n   <!ATTLIST node id ID #REQUIRED>\n   <!ATTLIST node clocksequence CDATA #IMPLIED>\n   <!ATTLIST node lasttimestamp CDATA #IMPLIED>\n]>\n<uuidstate synchInterval=\"");
        buf.append(this.getSynchInterval());
        buf.append("\">");
        while (it.hasNext()) {
            Node n = (Node)it.next();
            buf.append("\n\t<node id=\"");
            buf.append(StateHelper.encodeMACAddress(n.getNodeIdentifier()));
            buf.append("\" clocksequence=\"");
            buf.append(n.getClockSequence());
            buf.append("\" timestamp=\"");
            buf.append(n.getLastTimestamp());
            buf.append("\" />");
        }
        buf.append("\n</uuidstate>");
        return buf.toString();
    }

    private String genXML(Set nodes, long timestamp) throws IOException {
        Iterator it = nodes.iterator();
        StringBuffer buf = new StringBuffer(1024);
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE uuidstate [\n   <!ELEMENT uuidstate (node*)>\n   <!ELEMENT node EMPTY>\n   <!ATTLIST node id ID #REQUIRED>\n   <!ATTLIST node clocksequence CDATA #IMPLIED>\n   <!ATTLIST node lasttimestamp CDATA #IMPLIED>\n]>\n<uuidstate synchInterval=\"");
        buf.append(this.getSynchInterval());
        buf.append("\">");
        while (it.hasNext()) {
            Node n = (Node)it.next();
            buf.append("\n\t<node id=\"");
            buf.append(StateHelper.encodeMACAddress(n.getNodeIdentifier()));
            buf.append("\" clocksequence=\"");
            buf.append(n.getClockSequence());
            buf.append("\" timestamp=\"");
            buf.append(timestamp);
            buf.append("\" />");
        }
        buf.append("\n</uuidstate>");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXML(String xml) {
        File file;
        String resourceName = System.getProperty("org.apache.commons.id.uuid.config.resource.filename");
        if (resourceName == null) {
            return;
        }
        URL rUrl = ClassLoader.getSystemResource(resourceName);
        if (rUrl != null && (file = new File(rUrl.getFile())) != null && file.canWrite()) {
            FileWriter fw = null;
            try {
                fw = new FileWriter(file);
                fw.write(xml);
                fw.close();
            }
            catch (IOException ioe) {
            }
            finally {
                try {
                    fw.close();
                }
                catch (IOException ioee) {}
                fw = null;
                file = null;
            }
        }
    }
}

