/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.helper.NaturalComparator;
import org.magicwerk.brownies.collections.primitive.ShortGapList;

public class ShortObjGapList
extends IList<Short> {
    ShortGapList list;

    static Short[] toWrapper(short[] elems) {
        Short[] e = new Short[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = elems[i];
        }
        return e;
    }

    static short[] toPrimitive(Short[] elems) {
        short[] e = new short[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = elems[i];
        }
        return e;
    }

    static short[] toPrimitive(GapList<? extends Short> list2) {
        short[] e = new short[list2.size()];
        for (int i = 0; i < e.length; ++i) {
            e[i] = list2.get(i);
        }
        return e;
    }

    static short[] toPrimitive(Collection<? extends Short> list) {
        short[] e = new short[list.size()];
        Iterator<? extends Short> iter = list.iterator();
        for (int i = 0; i < e.length; ++i) {
            e[i] = iter.next();
        }
        return e;
    }

    public static ShortObjGapList create() {
        return new ShortObjGapList();
    }

    public static ShortObjGapList create(Short ... elems) {
        ShortObjGapList list = new ShortObjGapList();
        list.init(elems);
        return list;
    }

    public static ShortObjGapList create(Collection<? extends Short> elems) {
        return new ShortObjGapList(elems);
    }

    public ShortObjGapList() {
        this.init();
    }

    public void init() {
        this.list = new ShortGapList();
    }

    public ShortObjGapList(int capacity) {
        this.list = new ShortGapList(capacity);
    }

    public void init(Short ... elems) {
        this.list = ShortGapList.create(ShortObjGapList.toPrimitive(elems));
    }

    public ShortObjGapList(Collection<? extends Short> elems) {
        this.init(elems);
    }

    public void init(Collection<? extends Short> elems) {
        this.list = ShortGapList.create(ShortObjGapList.toPrimitive(elems));
    }

    @Override
    protected void doClone(IList<Short> that) {
        this.list = (ShortGapList)((ShortObjGapList)that).list.clone();
    }

    @Override
    protected void doAssign(IList<Short> that) {
        ShortObjGapList list = (ShortObjGapList)that;
        this.list = list.list;
    }

    public ShortObjGapList copy() {
        return (ShortObjGapList)this.clone();
    }

    @Override
    public Short getDefaultElem() {
        return this.list.getDefaultElem();
    }

    @Override
    public IList<Short> doCreate(int capacity) {
        if (capacity == -1) {
            capacity = 10;
        }
        return new ShortObjGapList(capacity);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public int capacity() {
        return this.list.capacity();
    }

    @Override
    public Short get(int index) {
        return this.list.get(index);
    }

    @Override
    protected Short doGet(int index) {
        return this.list.doGet(index);
    }

    @Override
    protected void doGetAll(Object[] elems, int index, int len) {
        for (int i = 0; i < len; ++i) {
            elems[i] = this.list.doGet(index + i);
        }
    }

    @Override
    protected boolean doAdd(int index, Short elem) {
        return this.list.doAdd(index, elem);
    }

    @Override
    protected Short doSet(int index, Short elem) {
        return this.list.doSet(index, elem);
    }

    @Override
    protected Short doRemove(int index) {
        return this.list.doRemove(index);
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        this.list.doRemoveAll(index, len);
    }

    @Override
    protected Short doReSet(int index, Short elem) {
        return this.list.doReSet(index, elem);
    }

    @Override
    public void move(int srcIndex, int dstIndex, int len) {
        this.list.move(srcIndex, dstIndex, len);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        this.list.doEnsureCapacity(minCapacity);
    }

    @Override
    public void trimToSize() {
        this.list.trimToSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            return this.list.equals(obj);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null || elem.getClass() != Short.class) {
            return -1;
        }
        return this.list.indexOf((Short)elem);
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null || elem.getClass() != Short.class) {
            return -1;
        }
        return this.list.lastIndexOf((Short)elem);
    }

    @Override
    public boolean remove(Object elem) {
        if (elem == null || elem.getClass() != Short.class) {
            return false;
        }
        int index = this.list.indexOf((Short)elem);
        if (index == -1) {
            return false;
        }
        this.list.remove(index);
        return true;
    }

    @Override
    public boolean contains(Object elem) {
        if (elem == null || elem.getClass() != Short.class) {
            return false;
        }
        return this.list.contains((Short)elem);
    }

    @Override
    public boolean containsAny(Collection<?> coll) {
        return this.list.containsAny(coll);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.list.containsAll(coll);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean removeAll(IList<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public boolean retainAll(IList<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(0, this.size());
    }

    @Override
    public Object[] toArray(int index, int len) {
        Object[] elems = new Object[len];
        for (int i = 0; i < len; ++i) {
            elems[i] = this.list.get(i);
        }
        return elems;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.list.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        for (int i = 0; i < size; ++i) {
            array[i] = this.list.get(i);
        }
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    @Override
    public boolean addAll(Collection<? extends Short> coll) {
        return this.list.addAll(coll);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Short> coll) {
        return this.list.addAll(index, coll);
    }

    public boolean addArray(Short ... elems) {
        short[] e = ShortObjGapList.toPrimitive(elems);
        return this.list.addArray(e);
    }

    public boolean addArray(int index, Short ... elems) {
        short[] e = ShortObjGapList.toPrimitive(elems);
        return this.list.addArray(index, e);
    }

    @Override
    public boolean addAll(IList<? extends Short> list2) {
        short[] e = ShortObjGapList.toPrimitive(list2);
        return this.list.addArray(e);
    }

    @Override
    public boolean addAll(int index, IList<? extends Short> list2) {
        short[] e = ShortObjGapList.toPrimitive(list2);
        return this.list.addArray(index, e);
    }

    @Override
    public boolean removeFirstOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Short.class) {
            return false;
        }
        return this.list.removeFirstOccurrence((Short)elem);
    }

    @Override
    public boolean removeLastOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Short.class) {
            return false;
        }
        return this.list.removeLastOccurrence((Short)elem);
    }

    @Override
    public GapList<Short> getAll(int index, int len) {
        short[] elems = this.list.getArray(index, len);
        return GapList.create(ShortObjGapList.toWrapper(elems));
    }

    public Short[] getArray(int index, int len) {
        short[] elems = this.list.getArray(index, len);
        return ShortObjGapList.toWrapper(elems);
    }

    @Override
    public void setAll(int index, IList<? extends Short> list2) {
        short[] e = ShortObjGapList.toPrimitive(list2);
        this.list.setArray(index, e);
    }

    @Override
    public void setAll(int index, Collection<? extends Short> coll) {
        short[] e = ShortObjGapList.toPrimitive(coll);
        this.list.setArray(index, e);
    }

    public void setArray(int index, Short ... elems) {
        short[] e = ShortObjGapList.toPrimitive(elems);
        this.list.setArray(index, e);
    }

    @Override
    public void sort(int index, int len, Comparator comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        this.list.sort(index, len);
    }

    @Override
    public <K> int binarySearch(int index, int len, K key, Comparator<? super K> comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        return this.list.binarySearch(index, len, (Short)key);
    }

    public ShortObjGapList unmodifiableList() {
        return new ImmutableShortObjGapList(this);
    }

    protected static class ImmutableShortObjGapList
    extends ShortObjGapList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableShortObjGapList(ShortObjGapList that) {
            super(that);
        }

        @Override
        protected boolean doAdd(int index, Short elem) {
            this.error();
            return false;
        }

        @Override
        protected Short doSet(int index, Short elem) {
            this.error();
            return null;
        }

        @Override
        protected Short doReSet(int index, Short elem) {
            this.error();
            return null;
        }

        @Override
        protected Short doRemove(int index) {
            this.error();
            return null;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }
}

