/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.ServiceLoader;

public class Mappers {
    private static final String IMPLEMENTATION_SUFFIX = "Impl";

    private Mappers() {
    }

    public static <T> T getMapper(Class<T> clazz) {
        try {
            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(3);
            classLoaders.add(clazz.getClassLoader());
            if (Thread.currentThread().getContextClassLoader() != null) {
                classLoaders.add(Thread.currentThread().getContextClassLoader());
            }
            classLoaders.add(Mappers.class.getClassLoader());
            return Mappers.getMapper(clazz, classLoaders);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T getMapper(Class<T> mapperType, Iterable<ClassLoader> classLoaders) throws ClassNotFoundException, NoSuchMethodException {
        for (ClassLoader classLoader : classLoaders) {
            T mapper = Mappers.doGetMapper(mapperType, classLoader);
            if (mapper == null) continue;
            return mapper;
        }
        throw new ClassNotFoundException("Cannot find implementation for " + mapperType.getName());
    }

    private static <T> T doGetMapper(Class<T> clazz, ClassLoader classLoader) throws NoSuchMethodException {
        try {
            Class<?> implementation = classLoader.loadClass(clazz.getName() + IMPLEMENTATION_SUFFIX);
            Constructor<?> constructor = implementation.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            ServiceLoader<T> loader = ServiceLoader.load(clazz, classLoader);
            if (loader != null) {
                for (T mapper : loader) {
                    if (mapper == null) continue;
                    return mapper;
                }
            }
            return null;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

