/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.conversion;

import org.mapstruct.ap.conversion.Conversion;
import org.mapstruct.ap.model.Type;
import org.mapstruct.ap.util.NativeTypes;

public class PrimitiveToWrapperConversion
implements Conversion {
    private final Class<?> sourceType;
    private final Class<?> targetType;

    public PrimitiveToWrapperConversion(Class<?> sourceType, Class<?> targetType) {
        if (!sourceType.isPrimitive()) {
            throw new IllegalArgumentException(sourceType + " is no primitive type.");
        }
        if (targetType.isPrimitive()) {
            throw new IllegalArgumentException(targetType + " is no wrapper type.");
        }
        this.sourceType = sourceType;
        this.targetType = NativeTypes.getPrimitiveType(targetType);
    }

    @Override
    public String to(String sourcePropertyAccessor, Type type) {
        if (this.sourceType == this.targetType) {
            return sourcePropertyAccessor;
        }
        return "(" + this.targetType.getName() + ") " + sourcePropertyAccessor;
    }

    @Override
    public String from(String targetPropertyAccessor, Type type) {
        return targetPropertyAccessor + "." + this.sourceType.getName() + "Value()";
    }
}

