/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.util;

import java.util.Collection;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.model.Type;

public class TypeUtil {
    private final Elements elementUtils;
    private final Types typeUtils;
    private final TypeMirror collectionType;
    private final TypeMirror iterableType;

    public TypeUtil(Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.collectionType = elementUtils.getTypeElement(Collection.class.getCanonicalName()).asType();
        this.iterableType = elementUtils.getTypeElement(Iterable.class.getCanonicalName()).asType();
    }

    public Type getType(DeclaredType type) {
        Type elementType = null;
        boolean isIterableType = this.isIterableType(type);
        if (isIterableType && !type.getTypeArguments().isEmpty()) {
            elementType = this.retrieveType(type.getTypeArguments().iterator().next());
        }
        return new Type(this.elementUtils.getPackageOf(type.asElement()).toString(), type.asElement().getSimpleName().toString(), elementType, type.asElement().getKind() == ElementKind.ENUM, this.isCollectionType(type), isIterableType);
    }

    private boolean isIterableType(DeclaredType type) {
        return this.typeUtils.isAssignable(this.typeUtils.erasure(type), this.typeUtils.erasure(this.iterableType));
    }

    private boolean isCollectionType(DeclaredType type) {
        return this.typeUtils.isAssignable(this.typeUtils.erasure(type), this.typeUtils.erasure(this.collectionType));
    }

    public Type retrieveType(TypeMirror mirror) {
        if (mirror == null) {
            return null;
        }
        if (mirror.getKind() == TypeKind.DECLARED) {
            return this.getType((DeclaredType)mirror);
        }
        return new Type(mirror.toString());
    }
}

