/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.HashSet;
import java.util.Set;
import org.mapstruct.ap.model.AbstractModelElement;
import org.mapstruct.ap.model.MappingMethodReference;
import org.mapstruct.ap.model.Type;
import org.mapstruct.ap.model.TypeConversion;

public class PropertyMapping
extends AbstractModelElement {
    private final String sourceBeanName;
    private final String sourceName;
    private final String sourceAccessorName;
    private final Type sourceType;
    private final String targetName;
    private final String targetAccessorName;
    private final Type targetType;
    private final MappingMethodReference mappingMethod;
    private final TypeConversion conversion;

    public PropertyMapping(String sourceBeanName, String sourceName, String sourceAccessorName, Type sourceType, String targetName, String targetAccessorName, Type targetType, MappingMethodReference mappingMethod, TypeConversion conversion) {
        this.sourceBeanName = sourceBeanName;
        this.sourceName = sourceName;
        this.sourceAccessorName = sourceAccessorName;
        this.sourceType = sourceType;
        this.targetName = targetName;
        this.targetAccessorName = targetAccessorName;
        this.targetType = targetType;
        this.mappingMethod = mappingMethod;
        this.conversion = conversion;
    }

    public String getSourceBeanName() {
        return this.sourceBeanName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceAccessorName() {
        return this.sourceAccessorName;
    }

    public Type getSourceType() {
        return this.sourceType;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getTargetAccessorName() {
        return this.targetAccessorName;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public MappingMethodReference getMappingMethod() {
        return this.mappingMethod;
    }

    public TypeConversion getConversion() {
        return this.conversion;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> importTypes = new HashSet<Type>();
        importTypes.add(this.sourceType);
        importTypes.add(this.targetType);
        if (this.conversion != null && this.mappingMethod == null) {
            importTypes.addAll(this.conversion.getImportTypes());
        }
        return importTypes;
    }

    public String toString() {
        return "PropertyMapping {\n    sourceName='" + this.sourceAccessorName + "'," + "\n    sourceType=" + this.sourceType + "," + "\n    targetName='" + this.targetAccessorName + "'," + "\n    targetType=" + this.targetType + "," + "\n    mappingMethod=" + this.mappingMethod + "," + "\n    Conversion='" + this.conversion + "'," + "\n}";
    }
}

