/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source;

import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import org.mapstruct.ap.AnnotationProcessingException;
import org.mapstruct.ap.MappingPrism;
import org.mapstruct.ap.MappingsPrism;

public class Mapping {
    private final String sourceName;
    private final String sourceParameterName;
    private final String sourcePropertyName;
    private final String targetName;
    private final String dateFormat;
    private final AnnotationMirror mirror;
    private final AnnotationValue sourceAnnotationValue;
    private final AnnotationValue targetAnnotationValue;

    public static Map<String, Mapping> fromMappingsPrism(MappingsPrism mappingsAnnotation, Element element) {
        HashMap<String, Mapping> mappings = new HashMap<String, Mapping>();
        for (MappingPrism mapping : mappingsAnnotation.value()) {
            mappings.put(mapping.source(), Mapping.fromMappingPrism(mapping, element));
        }
        return mappings;
    }

    public static Mapping fromMappingPrism(MappingPrism mapping, Element element) {
        String[] sourceNameParts = Mapping.getSourceNameParts(mapping.source(), element, mapping.mirror, mapping.values.source());
        return new Mapping(mapping.source(), sourceNameParts != null ? sourceNameParts[0] : null, sourceNameParts != null ? sourceNameParts[1] : mapping.source(), mapping.target(), mapping.dateFormat(), mapping.mirror, mapping.values.source(), mapping.values.target());
    }

    private static String[] getSourceNameParts(String sourceName, Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
        if (!sourceName.contains(".")) {
            return null;
        }
        String[] parts = sourceName.split("\\.");
        if (parts.length != 2) {
            throw new AnnotationProcessingException("Mapping of nested attributes not supported yet.", element, annotationMirror, annotationValue);
        }
        return parts;
    }

    private Mapping(String sourceName, String sourceParameterName, String sourcePropertyName, String targetName, String dateFormat, AnnotationMirror mirror, AnnotationValue sourceAnnotationValue, AnnotationValue targetAnnotationValue) {
        this.sourceName = sourceName;
        this.sourceParameterName = sourceParameterName;
        this.sourcePropertyName = sourcePropertyName;
        this.targetName = targetName.equals("") ? sourceName : targetName;
        this.dateFormat = dateFormat;
        this.mirror = mirror;
        this.sourceAnnotationValue = sourceAnnotationValue;
        this.targetAnnotationValue = targetAnnotationValue;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourcePropertyName() {
        return this.sourcePropertyName;
    }

    public String getSourceParameterName() {
        return this.sourceParameterName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public AnnotationMirror getMirror() {
        return this.mirror;
    }

    public AnnotationValue getSourceAnnotationValue() {
        return this.sourceAnnotationValue;
    }

    public AnnotationValue getTargetAnnotationValue() {
        return this.targetAnnotationValue;
    }

    public Mapping reverse() {
        return new Mapping(this.targetName, null, this.targetName, this.sourceName, this.dateFormat, this.mirror, this.sourceAnnotationValue, this.targetAnnotationValue);
    }

    public String toString() {
        return "Mapping {\n    sourceName='" + this.sourceName + "'," + "\n    targetName='" + this.targetName + "'," + "\n}";
    }
}

