/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.mapstruct.ap.IterableMappingPrism;
import org.mapstruct.ap.MapMappingPrism;
import org.mapstruct.ap.MapperPrism;
import org.mapstruct.ap.MappingPrism;
import org.mapstruct.ap.MappingsPrism;
import org.mapstruct.ap.model.Parameter;
import org.mapstruct.ap.model.Type;
import org.mapstruct.ap.model.source.IterableMapping;
import org.mapstruct.ap.model.source.MapMapping;
import org.mapstruct.ap.model.source.Mapping;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.processor.ModelElementProcessor;
import org.mapstruct.ap.util.Executables;
import org.mapstruct.ap.util.TypeFactory;

public class MethodRetrievalProcessor
implements ModelElementProcessor<Void, List<Method>> {
    private Messager messager;
    private TypeFactory typeFactory;
    private Executables executables;

    @Override
    public List<Method> process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, Void sourceModel) {
        this.messager = context.getMessager();
        this.typeFactory = context.getTypeFactory();
        this.executables = new Executables(this.typeFactory);
        return this.retrieveMethods(mapperTypeElement, true);
    }

    @Override
    public int getPriority() {
        return 1;
    }

    private List<Method> retrieveMethods(TypeElement element, boolean implementationRequired) {
        ArrayList<Method> methods = new ArrayList<Method>();
        MapperPrism mapperPrism = implementationRequired ? MapperPrism.getInstanceOn(element) : null;
        for (ExecutableElement executable : ElementFilter.methodsIn(element.getEnclosedElements())) {
            Method method = this.getMethod(element, executable, implementationRequired);
            if (method == null) continue;
            methods.add(method);
        }
        if (implementationRequired) {
            for (TypeMirror usedMapper : mapperPrism.uses()) {
                methods.addAll(this.retrieveMethods((TypeElement)((DeclaredType)usedMapper).asElement(), false));
            }
        }
        return methods;
    }

    private Method getMethod(TypeElement element, ExecutableElement method, boolean implementationRequired) {
        List<Parameter> parameters = this.executables.retrieveParameters(method);
        Type returnType = this.executables.retrieveReturnType(method);
        if (implementationRequired) {
            Type resultType;
            Parameter targetParameter;
            List<Parameter> sourceParameters = this.extractSourceParameters(parameters);
            boolean isValid = this.checkParameterAndReturnType(method, sourceParameters, targetParameter = this.extractTargetParameter(parameters), resultType = this.selectResultType(returnType, targetParameter), returnType);
            if (isValid) {
                return Method.forMethodRequiringImplementation(method, parameters, returnType, this.getMappings(method), IterableMapping.fromPrism(IterableMappingPrism.getInstanceOn(method)), MapMapping.fromPrism(MapMappingPrism.getInstanceOn(method)));
            }
            return null;
        }
        if (parameters.size() == 1) {
            return Method.forReferencedMethod(this.typeFactory.getType(element), method, parameters, returnType);
        }
        return null;
    }

    private Parameter extractTargetParameter(List<Parameter> parameters) {
        for (Parameter param : parameters) {
            if (!param.isMappingTarget()) continue;
            return param;
        }
        return null;
    }

    private List<Parameter> extractSourceParameters(List<Parameter> parameters) {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>(parameters.size());
        for (Parameter param : parameters) {
            if (param.isMappingTarget()) continue;
            sourceParameters.add(param);
        }
        return sourceParameters;
    }

    private Type selectResultType(Type returnType, Parameter targetParameter) {
        if (null != targetParameter) {
            return targetParameter.getType();
        }
        return returnType;
    }

    private boolean checkParameterAndReturnType(ExecutableElement method, List<Parameter> sourceParameters, Parameter targetParameter, Type resultType, Type returnType) {
        if (sourceParameters.isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method with no input arguments.", method);
            return false;
        }
        if (targetParameter != null && sourceParameters.size() + 1 != method.getParameters().size()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method with more than one @MappingTarget parameter.", method);
            return false;
        }
        if (resultType.getTypeMirror().getKind() == TypeKind.VOID) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method with return type void.", method);
            return false;
        }
        if (returnType.getTypeMirror().getKind() != TypeKind.VOID && !resultType.isAssignableTo(returnType)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "The result type is not assignable to the the return type.", method);
            return false;
        }
        Type parameterType = sourceParameters.get(0).getType();
        if (parameterType.isIterableType() && !resultType.isIterableType()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method from iterable type to non-iterable type.", method);
            return false;
        }
        if (!parameterType.isIterableType() && resultType.isIterableType()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method from non-iterable type to iterable type.", method);
            return false;
        }
        if (parameterType.isPrimitive()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method with primitive parameter type.", method);
            return false;
        }
        if (resultType.isPrimitive()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method with primitive return type.", method);
            return false;
        }
        return true;
    }

    private Map<String, Mapping> getMappings(ExecutableElement method) {
        HashMap<String, Mapping> mappings = new HashMap<String, Mapping>();
        MappingPrism mappingAnnotation = MappingPrism.getInstanceOn(method);
        MappingsPrism mappingsAnnotation = MappingsPrism.getInstanceOn(method);
        if (mappingAnnotation != null) {
            mappings.put(mappingAnnotation.source(), Mapping.fromMappingPrism(mappingAnnotation, method));
        }
        if (mappingsAnnotation != null) {
            mappings.putAll(Mapping.fromMappingsPrism(mappingsAnnotation, method));
        }
        return mappings;
    }
}

