/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.util;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.mapstruct.ap.MappingTargetPrism;
import org.mapstruct.ap.model.Parameter;
import org.mapstruct.ap.model.Type;
import org.mapstruct.ap.util.TypeFactory;

public class Executables {
    private final TypeFactory typeFactory;

    public Executables(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public boolean isGetterMethod(ExecutableElement method) {
        return this.isPublic(method) && (this.isNonBooleanGetterMethod(method) || this.isBooleanGetterMethod(method));
    }

    private boolean isNonBooleanGetterMethod(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return method.getParameters().isEmpty() && name.startsWith("get") && name.length() > 3 && method.getReturnType().getKind() != TypeKind.VOID;
    }

    private boolean isBooleanGetterMethod(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return method.getParameters().isEmpty() && name.startsWith("is") && name.length() > 2 && method.getReturnType().getKind() == TypeKind.BOOLEAN;
    }

    public boolean isSetterMethod(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return this.isPublic(method) && name.startsWith("set") && name.length() > 3 && method.getParameters().size() == 1 && method.getReturnType().getKind() == TypeKind.VOID;
    }

    private boolean isPublic(ExecutableElement method) {
        return method.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public String getPropertyName(ExecutableElement getterOrSetterMethod) {
        if (this.isNonBooleanGetterMethod(getterOrSetterMethod)) {
            return Introspector.decapitalize(getterOrSetterMethod.getSimpleName().toString().substring(3));
        }
        if (this.isBooleanGetterMethod(getterOrSetterMethod)) {
            return Introspector.decapitalize(getterOrSetterMethod.getSimpleName().toString().substring(2));
        }
        if (this.isSetterMethod(getterOrSetterMethod)) {
            return Introspector.decapitalize(getterOrSetterMethod.getSimpleName().toString().substring(3));
        }
        throw new IllegalArgumentException("Executable " + getterOrSetterMethod + " is not getter or setter method.");
    }

    public Set<String> getPropertyNames(List<ExecutableElement> propertyAccessors) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (ExecutableElement executableElement : propertyAccessors) {
            propertyNames.add(this.getPropertyName(executableElement));
        }
        return propertyNames;
    }

    public Parameter retrieveSingleParameter(ExecutableElement method) {
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.size() != 1) {
            return null;
        }
        VariableElement parameter = parameters.get(0);
        return new Parameter(parameter.getSimpleName().toString(), this.typeFactory.getType(parameter.asType()), false);
    }

    public List<Parameter> retrieveParameters(ExecutableElement method) {
        List<? extends VariableElement> parameters = method.getParameters();
        ArrayList<Parameter> result = new ArrayList<Parameter>(parameters.size());
        for (VariableElement variableElement : parameters) {
            result.add(new Parameter(variableElement.getSimpleName().toString(), this.typeFactory.getType(variableElement.asType()), MappingTargetPrism.getInstanceOn(variableElement) != null));
        }
        return result;
    }

    public Type retrieveReturnType(ExecutableElement method) {
        return this.typeFactory.getType(method.getReturnType());
    }
}

