/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.mapstruct.ap.util.Collections;

public class Strings {
    private static final Set<String> KEYWORDS = Collections.asSet("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");

    private Strings() {
    }

    public static String capitalize(String name) {
        return name == null ? null : name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String join(Iterable<?> iterable, String separator) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object object : iterable) {
            if (!isFirst) {
                sb.append(separator);
            } else {
                isFirst = false;
            }
            sb.append(object);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String getSaveVariableName(String name, String ... existingVariableNames) {
        return Strings.getSaveVariableName(name, Arrays.asList(existingVariableNames));
    }

    public static String getSaveVariableName(String name, Collection<String> existingVariableNames) {
        HashSet<String> conflictingNames = new HashSet<String>(KEYWORDS);
        conflictingNames.addAll(existingVariableNames);
        while (conflictingNames.contains(name)) {
            name = name + "_";
        }
        return name;
    }
}

