/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.Set;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.MethodReference;
import org.mapstruct.ap.model.TypeConversion;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.util.Strings;

public class MapMappingMethod
extends MappingMethod {
    private final MethodReference keyMappingMethod;
    private final MethodReference valueMappingMethod;
    private final TypeConversion keyConversion;
    private final TypeConversion valueConversion;
    private final MethodReference factoryMethod;

    public MapMappingMethod(SourceMethod method, MethodReference keyMappingMethod, TypeConversion keyConversion, MethodReference valueMappingMethod, TypeConversion valueConversion, MethodReference factoryMethod) {
        super(method);
        this.keyMappingMethod = keyMappingMethod;
        this.keyConversion = keyConversion;
        this.valueMappingMethod = valueMappingMethod;
        this.valueConversion = valueConversion;
        this.factoryMethod = factoryMethod;
    }

    public Parameter getSourceParameter() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.isMappingTarget()) continue;
            return parameter;
        }
        throw new IllegalStateException("Method " + this + " has no source parameter.");
    }

    public MethodReference getKeyMappingMethod() {
        return this.keyMappingMethod;
    }

    public TypeConversion getKeyConversion() {
        return this.keyConversion;
    }

    public MethodReference getValueMappingMethod() {
        return this.valueMappingMethod;
    }

    public TypeConversion getValueConversion() {
        return this.valueConversion;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        if (this.valueConversion != null) {
            types.addAll(this.valueConversion.getImportTypes());
        }
        if (this.keyConversion != null) {
            types.addAll(this.keyConversion.getImportTypes());
        }
        return types;
    }

    public String getKeyVariableName() {
        return Strings.getSaveVariableName("key", this.getParameterNames());
    }

    public String getValueVariableName() {
        return Strings.getSaveVariableName("value", this.getParameterNames());
    }

    public String getEntryVariableName() {
        return Strings.getSaveVariableName("entry", this.getParameterNames());
    }

    public MethodReference getFactoryMethod() {
        return this.factoryMethod;
    }
}

