/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.HashSet;
import java.util.Set;
import org.mapstruct.ap.model.MethodReference;
import org.mapstruct.ap.model.TypeConversion;
import org.mapstruct.ap.model.common.ModelElement;
import org.mapstruct.ap.model.common.Type;

public class PropertyMapping
extends ModelElement {
    private final String sourceBeanName;
    private final String sourceName;
    private final String sourceAccessorName;
    private final Type sourceType;
    private final String targetName;
    private final String targetAccessorName;
    private final Type targetType;
    private final boolean isTargetAccessorSetter;
    private final String targetReadAccessorName;
    private final MethodReference mappingMethod;
    private final TypeConversion conversion;

    public PropertyMapping(String sourceBeanName, String sourceName, String sourceAccessorName, Type sourceType, String targetName, String targetAccessorName, Type targetType, MethodReference mappingMethod, TypeConversion conversion) {
        this.sourceBeanName = sourceBeanName;
        this.sourceName = sourceName;
        this.sourceAccessorName = sourceAccessorName;
        this.sourceType = sourceType;
        this.targetName = targetName;
        this.targetAccessorName = targetAccessorName;
        this.targetType = targetType;
        this.isTargetAccessorSetter = targetAccessorName.startsWith("set");
        this.targetReadAccessorName = this.isTargetAccessorSetter ? "get" + targetAccessorName.substring(3) : targetAccessorName;
        this.mappingMethod = mappingMethod;
        this.conversion = conversion;
    }

    public String getSourceBeanName() {
        return this.sourceBeanName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceAccessorName() {
        return this.sourceAccessorName;
    }

    public Type getSourceType() {
        return this.sourceType;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getTargetAccessorName() {
        return this.targetAccessorName;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public MethodReference getMappingMethod() {
        return this.mappingMethod;
    }

    public TypeConversion getConversion() {
        return this.conversion;
    }

    public boolean isTargetAccessorSetter() {
        return this.isTargetAccessorSetter;
    }

    public String getTargetReadAccessorName() {
        return this.targetReadAccessorName;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> importTypes = new HashSet<Type>();
        importTypes.add(this.sourceType);
        importTypes.add(this.targetType);
        if (this.conversion != null && this.mappingMethod == null) {
            importTypes.addAll(this.conversion.getImportTypes());
        }
        return importTypes;
    }

    public String toString() {
        return "PropertyMapping {\n    sourceName='" + this.sourceAccessorName + "'," + "\n    sourceType=" + this.sourceType + "," + "\n    targetName='" + this.targetAccessorName + "'," + "\n    targetType=" + this.targetType + "," + "\n    mappingMethod=" + this.mappingMethod + "," + "\n    Conversion='" + this.conversion + "'," + "\n}";
    }
}

