/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.Types;
import org.mapstruct.ap.model.common.Accessibility;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.IterableMapping;
import org.mapstruct.ap.model.source.MapMapping;
import org.mapstruct.ap.model.source.Mapping;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.model.source.MethodMatcher;
import org.mapstruct.ap.util.Strings;

public class SourceMethod
implements Method {
    private final Type declaringMapper;
    private final ExecutableElement executable;
    private final List<Parameter> parameters;
    private final Parameter targetParameter;
    private final Type returnType;
    private final Accessibility accessibility;
    private final Types typeUtils;
    private Map<String, List<Mapping>> mappings;
    private IterableMapping iterableMapping;
    private MapMapping mapMapping;
    private boolean configuredByReverseMappingMethod = false;

    public static SourceMethod forMethodRequiringImplementation(ExecutableElement executable, List<Parameter> parameters, Type returnType, Map<String, List<Mapping>> mappings, IterableMapping iterableMapping, MapMapping mapMapping, Types typeUtils) {
        return new SourceMethod(null, executable, parameters, returnType, mappings, iterableMapping, mapMapping, typeUtils);
    }

    public static SourceMethod forReferencedMethod(Type declaringMapper, ExecutableElement executable, List<Parameter> parameters, Type returnType, Types typeUtils) {
        return new SourceMethod(declaringMapper, executable, parameters, returnType, Collections.<String, List<Mapping>>emptyMap(), null, null, typeUtils);
    }

    public static SourceMethod forFactoryMethod(Type declaringMapper, ExecutableElement executable, Type returnType, Types typeUtils) {
        return new SourceMethod(declaringMapper, executable, Collections.<Parameter>emptyList(), returnType, Collections.<String, List<Mapping>>emptyMap(), null, null, typeUtils);
    }

    private SourceMethod(Type declaringMapper, ExecutableElement executable, List<Parameter> parameters, Type returnType, Map<String, List<Mapping>> mappings, IterableMapping iterableMapping, MapMapping mapMapping, Types typeUtils) {
        this.declaringMapper = declaringMapper;
        this.executable = executable;
        this.parameters = parameters;
        this.returnType = returnType;
        this.mappings = mappings;
        this.iterableMapping = iterableMapping;
        this.mapMapping = mapMapping;
        this.accessibility = Accessibility.fromModifiers(executable.getModifiers());
        this.targetParameter = this.determineTargetParameter(parameters);
        this.typeUtils = typeUtils;
    }

    private Parameter determineTargetParameter(Iterable<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            if (!parameter.isMappingTarget()) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public Type getDeclaringMapper() {
        return this.declaringMapper;
    }

    public ExecutableElement getExecutable() {
        return this.executable;
    }

    @Override
    public String getName() {
        return this.executable.getSimpleName().toString();
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public List<Parameter> getSourceParameters() {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>();
        for (Parameter parameter : this.parameters) {
            if (parameter.isMappingTarget() || parameter.isTargetType()) continue;
            sourceParameters.add(parameter);
        }
        return sourceParameters;
    }

    public List<String> getParameterNames() {
        ArrayList<String> parameterNames = new ArrayList<String>(this.parameters.size());
        for (Parameter parameter : this.parameters) {
            parameterNames.add(parameter.getName());
        }
        return parameterNames;
    }

    public Type getResultType() {
        return this.targetParameter != null ? this.targetParameter.getType() : this.returnType;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    public Map<String, List<Mapping>> getMappings() {
        return this.mappings;
    }

    public void setMappings(Map<String, List<Mapping>> mappings) {
        this.mappings = mappings;
        this.configuredByReverseMappingMethod = true;
    }

    public IterableMapping getIterableMapping() {
        return this.iterableMapping;
    }

    public void setIterableMapping(IterableMapping iterableMapping) {
        this.iterableMapping = iterableMapping;
        this.configuredByReverseMappingMethod = true;
    }

    public MapMapping getMapMapping() {
        return this.mapMapping;
    }

    public void setMapMapping(MapMapping mapMapping) {
        this.mapMapping = mapMapping;
        this.configuredByReverseMappingMethod = true;
    }

    public boolean reverses(SourceMethod method) {
        return this.getSourceParameters().size() == 1 && method.getSourceParameters().size() == 1 && this.equals(this.getSourceParameters().iterator().next().getType(), method.getResultType()) && this.equals(this.getResultType(), method.getSourceParameters().iterator().next().getType());
    }

    @Override
    public Parameter getTargetParameter() {
        return this.targetParameter;
    }

    public boolean isIterableMapping() {
        return this.getSourceParameters().size() == 1 && this.getSourceParameters().iterator().next().getType().isIterableType() && this.getResultType().isIterableType();
    }

    public boolean isMapMapping() {
        return this.getSourceParameters().size() == 1 && this.getSourceParameters().iterator().next().getType().isMapType() && this.getResultType().isMapType();
    }

    public boolean isEnumMapping() {
        return this.getSourceParameters().size() == 1 && this.getSourceParameters().iterator().next().getType().isEnumType() && this.getResultType().isEnumType();
    }

    public boolean isConfiguredByReverseMappingMethod() {
        return this.configuredByReverseMappingMethod;
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.returnType.toString());
        sb.append(" ");
        if (this.declaringMapper != null) {
            sb.append(this.declaringMapper).append(".");
        }
        sb.append(this.getName()).append("(").append(Strings.join(this.parameters, ", ")).append(")");
        return sb.toString();
    }

    public Mapping getMappingByTargetPropertyName(String targetPropertyName) {
        for (Map.Entry<String, List<Mapping>> entry : this.mappings.entrySet()) {
            for (Mapping mapping : entry.getValue()) {
                if (!mapping.getTargetName().equals(targetPropertyName)) continue;
                return mapping;
            }
        }
        return null;
    }

    public Parameter getSourceParameter(String sourceParameterName) {
        for (Parameter parameter : this.getSourceParameters()) {
            if (!parameter.getName().equals(sourceParameterName)) continue;
            return parameter;
        }
        return null;
    }

    public boolean requiresImplementation() {
        return this.declaringMapper == null && this.executable.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    @Override
    public boolean matches(List<Type> sourceTypes, Type targetType) {
        MethodMatcher matcher = new MethodMatcher(this.typeUtils, this);
        return matcher.matches(sourceTypes, targetType);
    }

    public static boolean containsTargetTypeParameter(List<Parameter> parameters) {
        for (Parameter param : parameters) {
            if (!param.isTargetType()) continue;
            return true;
        }
        return false;
    }
}

