/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.List;
import java.util.Set;
import javax.tools.Diagnostic;
import org.mapstruct.ap.model.Direct;
import org.mapstruct.ap.model.MapperReference;
import org.mapstruct.ap.model.MappingBuilderContext;
import org.mapstruct.ap.model.MethodReference;
import org.mapstruct.ap.model.TypeConversion;
import org.mapstruct.ap.model.assignment.Assignment;
import org.mapstruct.ap.model.common.ConversionContext;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.model.source.builtin.BuiltInMethod;
import org.mapstruct.ap.model.source.selector.MethodSelectors;

public class AssignmentFactory {
    private AssignmentFactory() {
    }

    public static Assignment createTypeConversion(Set<Type> importTypes, List<Type> exceptionTypes, String expression) {
        return new TypeConversion(importTypes, exceptionTypes, expression);
    }

    public static Assignment createMethodReference(Method method, MapperReference declaringMapper, Type targetType) {
        return new MethodReference(method, declaringMapper, targetType);
    }

    public static Assignment createMethodReference(BuiltInMethod method, ConversionContext contextParam) {
        return new MethodReference(method, contextParam);
    }

    public static Direct createDirect(String sourceRef) {
        return new Direct(sourceRef);
    }

    public static MethodReference createFactoryMethod(Type returnType, MappingBuilderContext ctx) {
        MethodReference result = null;
        for (SourceMethod method : ctx.getSourceModel()) {
            List<Type> parameterTypes;
            if (method.overridesMethod() || method.isIterableMapping() || method.isMapMapping() || !method.getSourceParameters().isEmpty() || !method.matches(parameterTypes = MethodSelectors.getParameterTypes(ctx.getTypeFactory(), method.getParameters(), null, returnType), returnType)) continue;
            if (result == null) {
                MapperReference mapperReference = AssignmentFactory.findMapperReference(ctx.getMapperReferences(), method);
                result = new MethodReference(method, mapperReference, null);
                continue;
            }
            ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Ambiguous factory methods: \"%s\" conflicts with \"%s\".", result, method), method.getExecutable());
        }
        return result;
    }

    private static MapperReference findMapperReference(List<MapperReference> mapperReferences, SourceMethod method) {
        for (MapperReference ref : mapperReferences) {
            if (!ref.getType().equals(method.getDeclaringMapper())) continue;
            return ref;
        }
        return null;
    }
}

