/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.List;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.mapstruct.ap.model.AssignmentFactory;
import org.mapstruct.ap.model.MappingBuilderContext;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.MethodReference;
import org.mapstruct.ap.model.assignment.Assignment;
import org.mapstruct.ap.model.assignment.SetterWrapper;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.prism.NullValueMappingPrism;
import org.mapstruct.ap.util.MapperConfig;
import org.mapstruct.ap.util.Strings;

public class IterableMappingMethod
extends MappingMethod {
    private final Assignment elementAssignment;
    private final MethodReference factoryMethod;
    private final boolean overridden;
    private final boolean mapNullToDefault;
    private final TypeFactory typeFactory;

    private IterableMappingMethod(Method method, Assignment parameterAssignment, MethodReference factoryMethod, boolean mapNullToDefault, TypeFactory typeFactory) {
        super(method);
        this.elementAssignment = parameterAssignment;
        this.factoryMethod = factoryMethod;
        this.overridden = method.overridesMethod();
        this.mapNullToDefault = mapNullToDefault;
        this.typeFactory = typeFactory;
    }

    public Parameter getSourceParameter() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.isMappingTarget()) continue;
            return parameter;
        }
        throw new IllegalStateException("Method " + this + " has no source parameter.");
    }

    public Assignment getElementAssignment() {
        return this.elementAssignment;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        if (this.elementAssignment != null) {
            types.addAll(this.elementAssignment.getImportTypes());
        }
        return types;
    }

    public boolean isMapNullToDefault() {
        return this.mapNullToDefault;
    }

    public boolean isOverridden() {
        return this.overridden;
    }

    public String getLoopVariableName() {
        return Strings.getSaveVariableName(this.getSourceParameter().getType().getTypeParameters().get(0).getName(), this.getParameterNames());
    }

    public MethodReference getFactoryMethod() {
        return this.factoryMethod;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getResultType() == null ? 0 : this.getResultType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IterableMappingMethod other = (IterableMappingMethod)obj;
        if (!this.getResultType().equals(other.getResultType())) {
            return false;
        }
        if (this.getSourceParameters().size() != other.getSourceParameters().size()) {
            return false;
        }
        for (int i = 0; i < this.getSourceParameters().size(); ++i) {
            if (this.getSourceParameters().get(i).getType().getTypeParameters().get(0).equals(other.getSourceParameters().get(i).getType().getTypeParameters().get(0))) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private Method method;
        private MappingBuilderContext ctx;
        private String dateFormat;
        private List<TypeMirror> qualifiers;

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public Builder method(Method sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder qualifiers(List<TypeMirror> qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        public IterableMappingMethod build() {
            Type sourceElementType = this.method.getSourceParameters().iterator().next().getType().getTypeParameters().get(0);
            Type targetElementType = this.method.getResultType().getTypeParameters().get(0);
            String conversionStr = Strings.getSaveVariableName(sourceElementType.getName(), this.method.getParameterNames());
            Assignment assignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, "collection element", sourceElementType, targetElementType, null, this.dateFormat, this.qualifiers, conversionStr);
            if (assignment == null) {
                String message = String.format("Can't create implementation of method %s. Found no method nor built-in conversion for mapping source element type into target element type.", this.method);
                this.ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, message, this.method.getExecutable());
            }
            assignment = new SetterWrapper(assignment, this.method.getThrownTypes());
            NullValueMappingPrism prism = NullValueMappingPrism.getInstanceOn(this.method.getExecutable());
            boolean mapNullToDefault = MapperConfig.getInstanceOn(this.ctx.getMapperTypeElement()).isMapToDefault(prism);
            MethodReference factoryMethod = AssignmentFactory.createFactoryMethod(this.method.getReturnType(), this.ctx);
            return new IterableMappingMethod(this.method, assignment, factoryMethod, mapNullToDefault, this.ctx.getTypeFactory());
        }
    }
}

