/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.mapstruct.ap.model.AssignmentFactory;
import org.mapstruct.ap.model.IterableMappingMethod;
import org.mapstruct.ap.model.MapMappingMethod;
import org.mapstruct.ap.model.MappingBuilderContext;
import org.mapstruct.ap.model.NestedPropertyMappingMethod;
import org.mapstruct.ap.model.assignment.AdderWrapper;
import org.mapstruct.ap.model.assignment.Assignment;
import org.mapstruct.ap.model.assignment.AssignmentWrapper;
import org.mapstruct.ap.model.assignment.GetterCollectionOrMapWrapper;
import org.mapstruct.ap.model.assignment.NewCollectionOrMapWrapper;
import org.mapstruct.ap.model.assignment.NullCheckWrapper;
import org.mapstruct.ap.model.assignment.SetterCollectionOrMapWrapper;
import org.mapstruct.ap.model.assignment.SetterWrapper;
import org.mapstruct.ap.model.common.ModelElement;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.ForgedMethod;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.model.source.SourceReference;
import org.mapstruct.ap.util.Executables;
import org.mapstruct.ap.util.Strings;

public class PropertyMapping
extends ModelElement {
    private final String sourceBeanName;
    private final String targetAccessorName;
    private final Type targetType;
    private final Assignment assignment;

    private PropertyMapping(String targetAccessorName, Type targetType, Assignment propertyAssignment) {
        this(null, targetAccessorName, targetType, propertyAssignment);
    }

    private PropertyMapping(String sourceBeanName, String targetAccessorName, Type targetType, Assignment assignment) {
        this.sourceBeanName = sourceBeanName;
        this.targetAccessorName = targetAccessorName;
        this.targetType = targetType;
        this.assignment = assignment;
    }

    public String getSourceBeanName() {
        return this.sourceBeanName;
    }

    public String getTargetAccessorName() {
        return this.targetAccessorName;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    @Override
    public Set<Type> getImportTypes() {
        return this.assignment.getImportTypes();
    }

    public String toString() {
        return "PropertyMapping {\n    targetName='" + this.targetAccessorName + "'," + "\n    targetType=" + this.targetType + "," + "\n    propertyAssignment=" + this.assignment + "\n}";
    }

    public static class JavaExpressionMappingBuilder {
        private MappingBuilderContext ctx;
        private SourceMethod method;
        private String javaExpression;
        private ExecutableElement targetAccessor;

        public JavaExpressionMappingBuilder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public JavaExpressionMappingBuilder souceMethod(SourceMethod sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public JavaExpressionMappingBuilder javaExpression(String javaExpression) {
            this.javaExpression = javaExpression;
            return this;
        }

        public JavaExpressionMappingBuilder targetAccessor(ExecutableElement targetAccessor) {
            this.targetAccessor = targetAccessor;
            return this;
        }

        public PropertyMapping build() {
            Type targetType;
            ModelElement assignment = AssignmentFactory.createDirect(this.javaExpression);
            assignment = new SetterWrapper((Assignment)((Object)assignment), this.method.getThrownTypes());
            if (Executables.isSetterMethod(this.targetAccessor)) {
                targetType = this.ctx.getTypeFactory().getSingleParameter(this.targetAccessor).getType();
            } else {
                targetType = this.ctx.getTypeFactory().getReturnType(this.targetAccessor);
                assignment = new GetterCollectionOrMapWrapper((Assignment)((Object)assignment));
            }
            return new PropertyMapping(this.targetAccessor.getSimpleName().toString(), targetType, (Assignment)((Object)assignment));
        }
    }

    public static class ConstantMappingBuilder {
        private MappingBuilderContext ctx;
        private SourceMethod method;
        private String constantExpression;
        private ExecutableElement targetAccessor;
        private String dateFormat;
        private List<TypeMirror> qualifiers;

        public ConstantMappingBuilder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public ConstantMappingBuilder sourceMethod(SourceMethod sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public ConstantMappingBuilder constantExpression(String constantExpression) {
            this.constantExpression = constantExpression;
            return this;
        }

        public ConstantMappingBuilder targetAccessor(ExecutableElement targetAccessor) {
            this.targetAccessor = targetAccessor;
            return this;
        }

        public ConstantMappingBuilder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public ConstantMappingBuilder qualifiers(List<TypeMirror> qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        public PropertyMapping build() {
            String mappedElement = "constant '" + this.constantExpression + "'";
            Type sourceType = this.ctx.getTypeFactory().getType(String.class);
            Type targetType = Executables.isSetterMethod(this.targetAccessor) ? this.ctx.getTypeFactory().getSingleParameter(this.targetAccessor).getType() : this.ctx.getTypeFactory().getReturnType(this.targetAccessor);
            String targetPropertyName = Executables.getPropertyName(this.targetAccessor);
            Assignment assignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, mappedElement, sourceType, targetType, targetPropertyName, this.dateFormat, this.qualifiers, this.constantExpression);
            if (assignment != null) {
                assignment = new SetterWrapper(assignment, this.method.getThrownTypes());
                if (Executables.isGetterMethod(this.targetAccessor)) {
                    assignment = new GetterCollectionOrMapWrapper(assignment);
                }
            } else {
                this.ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Can't map \"%s %s\" to \"%s %s\".", sourceType, this.constantExpression, targetType, targetPropertyName), this.method.getExecutable());
            }
            return new PropertyMapping(this.targetAccessor.getSimpleName().toString(), targetType, assignment);
        }
    }

    public static class PropertyMappingBuilder {
        private MappingBuilderContext ctx;
        private SourceMethod method;
        private ExecutableElement targetAccessor;
        private String targetPropertyName;
        private String dateFormat;
        private List<TypeMirror> qualifiers;
        private SourceReference sourceReference;

        public PropertyMappingBuilder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public PropertyMappingBuilder souceMethod(SourceMethod sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public PropertyMappingBuilder targetAccessor(ExecutableElement targetAccessor) {
            this.targetAccessor = targetAccessor;
            return this;
        }

        public PropertyMappingBuilder targetPropertyName(String targetPropertyName) {
            this.targetPropertyName = targetPropertyName;
            return this;
        }

        public PropertyMappingBuilder sourceReference(SourceReference sourceReference) {
            this.sourceReference = sourceReference;
            return this;
        }

        public PropertyMappingBuilder qualifiers(List<TypeMirror> qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        public PropertyMappingBuilder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public PropertyMapping build() {
            String sourceRefStr;
            TargetAccessorType targetAccessorType = this.getTargetAcccessorType();
            Type targetType = this.getTargetType(targetAccessorType);
            String sourceElement = this.getSourceElement();
            Type sourceType = this.getSourceType();
            if (targetAccessorType == TargetAccessorType.ADDER && sourceType.isCollectionType()) {
                sourceType = sourceType.getTypeParameters().get(0);
                sourceRefStr = Executables.getElementNameForAdder(this.targetAccessor);
            } else {
                sourceRefStr = this.getSourceRef();
            }
            Assignment assignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, sourceElement, sourceType, targetType, this.targetPropertyName, this.dateFormat, this.qualifiers, sourceRefStr);
            if (assignment == null) {
                assignment = this.forgeMapOrIterableMapping(sourceType, targetType, sourceRefStr, this.method.getExecutable());
            }
            if (assignment != null) {
                assignment = targetType.isCollectionOrMapType() ? this.assignCollection(targetType, targetAccessorType, assignment) : this.assignObject(sourceType, targetType, targetAccessorType, assignment);
            } else {
                this.ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Can't map %s to \"%s %s\". Consider to declare/implement a mapping method: \"%s map(%s value)\".", sourceElement, targetType, this.targetPropertyName, targetType, this.getSourceType()), this.method.getExecutable());
            }
            return new PropertyMapping(this.sourceReference.getParameter().getName(), this.targetAccessor.getSimpleName().toString(), targetType, assignment);
        }

        private Assignment assignObject(Type sourceType, Type targetType, TargetAccessorType targetAccessorType, Assignment rhs) {
            Assignment result = rhs;
            if (targetAccessorType == TargetAccessorType.SETTER) {
                result = new SetterWrapper(result, this.method.getThrownTypes());
                if (!sourceType.isPrimitive() && (result.getType() == Assignment.AssignmentType.TYPE_CONVERTED || result.getType() == Assignment.AssignmentType.TYPE_CONVERTED_MAPPED || result.getType() == Assignment.AssignmentType.DIRECT && targetType.isPrimitive())) {
                    result = new NullCheckWrapper(result);
                }
            } else if (this.getSourceType().isCollectionType()) {
                result = new AdderWrapper(result, this.method.getThrownTypes(), this.getSourceRef(), sourceType);
            } else {
                result = new SetterWrapper(result, this.method.getThrownTypes());
                result = new NullCheckWrapper(result);
            }
            return result;
        }

        private Assignment assignCollection(Type targetType, TargetAccessorType targetAccessorType, Assignment rhs) {
            Assignment result = rhs;
            if (targetAccessorType == TargetAccessorType.SETTER) {
                AssignmentWrapper newCollectionOrMap = null;
                if (result.getType() == Assignment.AssignmentType.DIRECT) {
                    newCollectionOrMap = new NewCollectionOrMapWrapper(result, targetType.getImportTypes());
                    newCollectionOrMap = new SetterWrapper(newCollectionOrMap, this.method.getThrownTypes());
                }
                result = new SetterWrapper(result, this.method.getThrownTypes());
                result = new SetterCollectionOrMapWrapper(result, this.targetAccessor.getSimpleName().toString(), newCollectionOrMap);
            } else {
                result = new SetterWrapper(result, this.method.getThrownTypes());
                result = new GetterCollectionOrMapWrapper(result);
            }
            if (result.getType() == Assignment.AssignmentType.DIRECT) {
                result = new NullCheckWrapper(result);
            }
            return result;
        }

        private Type getSourceType() {
            Parameter sourceParam = this.sourceReference.getParameter();
            List<SourceReference.PropertyEntry> propertyEntries = this.sourceReference.getPropertyEntries();
            if (propertyEntries.isEmpty()) {
                return sourceParam.getType();
            }
            if (propertyEntries.size() == 1) {
                SourceReference.PropertyEntry propertyEntry = propertyEntries.get(0);
                return propertyEntry.getType();
            }
            SourceReference.PropertyEntry lastPropertyEntry = propertyEntries.get(propertyEntries.size() - 1);
            return lastPropertyEntry.getType();
        }

        private String getSourceRef() {
            Parameter sourceParam = this.sourceReference.getParameter();
            List<SourceReference.PropertyEntry> propertyEntries = this.sourceReference.getPropertyEntries();
            if (propertyEntries.isEmpty()) {
                return sourceParam.getName();
            }
            if (propertyEntries.size() == 1) {
                SourceReference.PropertyEntry propertyEntry = propertyEntries.get(0);
                return sourceParam.getName() + "." + propertyEntry.getAccessor().getSimpleName() + "()";
            }
            SourceReference.PropertyEntry lastPropertyEntry = propertyEntries.get(propertyEntries.size() - 1);
            String forgedMethodName = Strings.joinAndCamelize(this.sourceReference.getElementNames());
            ForgedMethod methodToGenerate = new ForgedMethod(forgedMethodName, this.sourceReference.getParameter().getType(), lastPropertyEntry.getType(), this.method.getExecutable());
            NestedPropertyMappingMethod.Builder builder = new NestedPropertyMappingMethod.Builder();
            NestedPropertyMappingMethod nestedPropertyMapping = builder.method(methodToGenerate).propertyEntries(this.sourceReference.getPropertyEntries()).build();
            if (!this.ctx.getMappingsToGenerate().contains(nestedPropertyMapping)) {
                this.ctx.getMappingsToGenerate().add(nestedPropertyMapping);
            }
            return forgedMethodName + "( " + sourceParam.getName() + " )";
        }

        private String getSourceElement() {
            Parameter sourceParam = this.sourceReference.getParameter();
            List<SourceReference.PropertyEntry> propertyEntries = this.sourceReference.getPropertyEntries();
            if (propertyEntries.isEmpty()) {
                return String.format("parameter \"%s %s\"", sourceParam.getType(), sourceParam.getName());
            }
            if (propertyEntries.size() == 1) {
                SourceReference.PropertyEntry propertyEntry = propertyEntries.get(0);
                return String.format("property \"%s %s\"", propertyEntry.getType(), propertyEntry.getName());
            }
            SourceReference.PropertyEntry lastPropertyEntry = propertyEntries.get(propertyEntries.size() - 1);
            return String.format("property \"%s %s\"", lastPropertyEntry.getType(), Strings.join(this.sourceReference.getElementNames(), "."));
        }

        private TargetAccessorType getTargetAcccessorType() {
            if (Executables.isSetterMethod(this.targetAccessor)) {
                return TargetAccessorType.SETTER;
            }
            if (Executables.isAdderMethod(this.targetAccessor)) {
                return TargetAccessorType.ADDER;
            }
            return TargetAccessorType.GETTER;
        }

        private Type getTargetType(TargetAccessorType targetAccessorType) {
            switch (targetAccessorType) {
                case ADDER: 
                case SETTER: {
                    return this.ctx.getTypeFactory().getSingleParameter(this.targetAccessor).getType();
                }
            }
            return this.ctx.getTypeFactory().getReturnType(this.targetAccessor);
        }

        private Assignment forgeMapOrIterableMapping(Type sourceType, Type targetType, String sourceReference, ExecutableElement element) {
            Assignment assignment = null;
            if (sourceType.isCollectionType() && targetType.isCollectionType()) {
                ForgedMethod methodToGenerate = new ForgedMethod(sourceType, targetType, element);
                IterableMappingMethod.Builder builder = new IterableMappingMethod.Builder();
                IterableMappingMethod iterableMappingMethod = builder.mappingContext(this.ctx).method(methodToGenerate).build();
                if (!this.ctx.getMappingsToGenerate().contains(iterableMappingMethod)) {
                    this.ctx.getMappingsToGenerate().add(iterableMappingMethod);
                }
                assignment = AssignmentFactory.createMethodReference(methodToGenerate, null, targetType);
                assignment.setAssignment(AssignmentFactory.createDirect(sourceReference));
            } else if (sourceType.isMapType() && targetType.isMapType()) {
                ForgedMethod methodToGenerate = new ForgedMethod(sourceType, targetType, element);
                MapMappingMethod.Builder builder = new MapMappingMethod.Builder();
                MapMappingMethod mapMappingMethod = builder.mappingContext(this.ctx).method(methodToGenerate).build();
                if (!this.ctx.getMappingsToGenerate().contains(mapMappingMethod)) {
                    this.ctx.getMappingsToGenerate().add(mapMappingMethod);
                }
                assignment = AssignmentFactory.createMethodReference(methodToGenerate, null, targetType);
                assignment.setAssignment(AssignmentFactory.createDirect(sourceReference));
            }
            return assignment;
        }

        private static enum TargetAccessorType {
            GETTER,
            SETTER,
            ADDER;

        }
    }
}

