/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.mapstruct.ap.model.common.Accessibility;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.util.Strings;

public class ForgedMethod
implements Method {
    private final List<Parameter> parameters;
    private final Type returnType;
    private final String name;
    private final ExecutableElement positionHintElement;

    public ForgedMethod(Type sourceType, Type targetType, ExecutableElement positionHintElement) {
        this.parameters = Arrays.asList(new Parameter(Strings.decapitalize(sourceType.getName()), sourceType));
        this.returnType = targetType;
        String fromName = this.getName(this.parameters.iterator().next().getType());
        String toName = this.getName(this.returnType);
        this.name = Strings.decapitalize(fromName + "To" + toName);
        this.positionHintElement = positionHintElement;
    }

    public ForgedMethod(String name, Type sourceType, Type targetType, ExecutableElement positionHintElement) {
        this.parameters = Arrays.asList(new Parameter(Strings.decapitalize(sourceType.getName()), sourceType));
        this.returnType = targetType;
        this.name = name;
        this.positionHintElement = positionHintElement;
    }

    private String getName(Type type) {
        StringBuilder builder = new StringBuilder();
        for (Type typeParam : type.getTypeParameters()) {
            builder.append(typeParam.getName());
        }
        builder.append(type.getName());
        return builder.toString();
    }

    @Override
    public boolean matches(List<Type> sourceTypes, Type targetType) {
        if (!targetType.equals(this.returnType)) {
            return false;
        }
        if (sourceTypes.size() == this.parameters.size()) {
            return false;
        }
        for (int i = 0; i < sourceTypes.size(); ++i) {
            if (sourceTypes.get(i).equals(this.parameters.get(i).getType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type getDeclaringMapper() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public List<Parameter> getSourceParameters() {
        return this.parameters;
    }

    @Override
    public Parameter getTargetParameter() {
        return null;
    }

    @Override
    public Accessibility getAccessibility() {
        return Accessibility.PROTECTED;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public List<Type> getThrownTypes() {
        return Collections.emptyList();
    }

    @Override
    public Type getResultType() {
        return this.returnType;
    }

    @Override
    public List<String> getParameterNames() {
        return Arrays.asList("source");
    }

    @Override
    public boolean overridesMethod() {
        return false;
    }

    @Override
    public ExecutableElement getExecutable() {
        return this.positionHintElement;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.returnType.toString());
        sb.append(" ");
        sb.append(this.getName()).append("(").append(Strings.join(this.parameters, ", ")).append(")");
        return sb.toString();
    }
}

