/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.Types;
import org.mapstruct.ap.model.common.Accessibility;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.model.source.IterableMapping;
import org.mapstruct.ap.model.source.MapMapping;
import org.mapstruct.ap.model.source.Mapping;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.model.source.MethodMatcher;
import org.mapstruct.ap.model.source.SourceReference;
import org.mapstruct.ap.util.Strings;

public class SourceMethod
implements Method {
    private final Types typeUtils;
    private final TypeFactory typeFactory;
    private final Messager messager;
    private final Type declaringMapper;
    private final ExecutableElement executable;
    private final List<Parameter> parameters;
    private final Parameter targetParameter;
    private final Type returnType;
    private final Accessibility accessibility;
    private final List<Type> exceptionTypes;
    private Map<String, List<Mapping>> mappings;
    private IterableMapping iterableMapping;
    private MapMapping mapMapping;

    public static SourceMethod forMethodRequiringImplementation(ExecutableElement executable, List<Parameter> parameters, Type returnType, List<Type> exceptionTypes, Map<String, List<Mapping>> mappings, IterableMapping iterableMapping, MapMapping mapMapping, Types typeUtils, Messager messager, TypeFactory typeFactory) {
        SourceMethod sourceMethod = new SourceMethod(null, executable, parameters, returnType, exceptionTypes, mappings, iterableMapping, mapMapping, typeUtils, typeFactory, messager);
        for (Map.Entry<String, List<Mapping>> entry : sourceMethod.getMappings().entrySet()) {
            for (Mapping mapping : entry.getValue()) {
                mapping.init(sourceMethod, messager, typeFactory);
            }
        }
        return sourceMethod;
    }

    public static SourceMethod forReferencedMethod(Type declaringMapper, ExecutableElement executable, List<Parameter> parameters, Type returnType, List<Type> exceptionTypes, Types typeUtils) {
        return new SourceMethod(declaringMapper, executable, parameters, returnType, exceptionTypes, Collections.<String, List<Mapping>>emptyMap(), null, null, typeUtils, null, null);
    }

    public static SourceMethod forFactoryMethod(Type declaringMapper, ExecutableElement executable, Type returnType, List<Type> exceptionTypes, Types typeUtils) {
        return new SourceMethod(declaringMapper, executable, Collections.<Parameter>emptyList(), returnType, exceptionTypes, Collections.<String, List<Mapping>>emptyMap(), null, null, typeUtils, null, null);
    }

    private SourceMethod(Type declaringMapper, ExecutableElement executable, List<Parameter> parameters, Type returnType, List<Type> exceptionTypes, Map<String, List<Mapping>> mappings, IterableMapping iterableMapping, MapMapping mapMapping, Types typeUtils, TypeFactory typeFactory, Messager messager) {
        this.declaringMapper = declaringMapper;
        this.executable = executable;
        this.parameters = parameters;
        this.returnType = returnType;
        this.exceptionTypes = exceptionTypes;
        this.mappings = mappings;
        this.iterableMapping = iterableMapping;
        this.mapMapping = mapMapping;
        this.accessibility = Accessibility.fromModifiers(executable.getModifiers());
        this.targetParameter = this.determineTargetParameter(parameters);
        this.typeUtils = typeUtils;
        this.typeFactory = typeFactory;
        this.messager = messager;
    }

    private Parameter determineTargetParameter(Iterable<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            if (!parameter.isMappingTarget()) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public Type getDeclaringMapper() {
        return this.declaringMapper;
    }

    @Override
    public ExecutableElement getExecutable() {
        return this.executable;
    }

    @Override
    public String getName() {
        return this.executable.getSimpleName().toString();
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public List<Parameter> getSourceParameters() {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>();
        for (Parameter parameter : this.parameters) {
            if (parameter.isMappingTarget() || parameter.isTargetType()) continue;
            sourceParameters.add(parameter);
        }
        return sourceParameters;
    }

    @Override
    public List<String> getParameterNames() {
        ArrayList<String> parameterNames = new ArrayList<String>(this.parameters.size());
        for (Parameter parameter : this.parameters) {
            parameterNames.add(parameter.getName());
        }
        return parameterNames;
    }

    @Override
    public Type getResultType() {
        return this.targetParameter != null ? this.targetParameter.getType() : this.returnType;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    public Map<String, List<Mapping>> getMappings() {
        return this.mappings;
    }

    public Mapping getSingleMappingByTargetPropertyName(String targetPropertyName) {
        List<Mapping> all = this.mappings.get(targetPropertyName);
        return all != null ? all.iterator().next() : null;
    }

    public void setMappings(Map<String, List<Mapping>> mappings) {
        this.mappings = mappings;
    }

    public IterableMapping getIterableMapping() {
        return this.iterableMapping;
    }

    public void setIterableMapping(IterableMapping iterableMapping) {
        this.iterableMapping = iterableMapping;
    }

    public MapMapping getMapMapping() {
        return this.mapMapping;
    }

    public void setMapMapping(MapMapping mapMapping) {
        this.mapMapping = mapMapping;
    }

    public boolean reverses(SourceMethod method) {
        return this.getSourceParameters().size() == 1 && method.getSourceParameters().size() == 1 && this.equals(this.getSourceParameters().iterator().next().getType(), method.getResultType()) && this.equals(this.getResultType(), method.getSourceParameters().iterator().next().getType());
    }

    @Override
    public Parameter getTargetParameter() {
        return this.targetParameter;
    }

    public boolean isIterableMapping() {
        return this.getSourceParameters().size() == 1 && this.getSourceParameters().iterator().next().getType().isIterableType() && this.getResultType().isIterableType();
    }

    public boolean isMapMapping() {
        return this.getSourceParameters().size() == 1 && this.getSourceParameters().iterator().next().getType().isMapType() && this.getResultType().isMapType();
    }

    public boolean isEnumMapping() {
        return this.getSourceParameters().size() == 1 && this.getSourceParameters().iterator().next().getType().isEnumType() && this.getResultType().isEnumType();
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.returnType.toString());
        sb.append(" ");
        if (this.declaringMapper != null) {
            sb.append(this.declaringMapper).append(".");
        }
        sb.append(this.getName()).append("(").append(Strings.join(this.parameters, ", ")).append(")");
        return sb.toString();
    }

    public List<Mapping> getMappingBySourcePropertyName(String sourcePropertyName) {
        ArrayList<Mapping> mappingsOfSourceProperty = new ArrayList<Mapping>();
        for (List<Mapping> mappingOfProperty : this.mappings.values()) {
            for (Mapping mapping : mappingOfProperty) {
                if (this.isEnumMapping()) {
                    if (!mapping.getSourceName().equals(sourcePropertyName)) continue;
                    mappingsOfSourceProperty.add(mapping);
                    continue;
                }
                List<SourceReference.PropertyEntry> sourceEntries = mapping.getSourceReference().getPropertyEntries();
                if (sourceEntries.size() != 1 || !sourcePropertyName.equals(sourceEntries.get(0).getName())) continue;
                mappingsOfSourceProperty.add(mapping);
            }
        }
        return mappingsOfSourceProperty;
    }

    public Parameter getSourceParameter(String sourceParameterName) {
        for (Parameter parameter : this.getSourceParameters()) {
            if (!parameter.getName().equals(sourceParameterName)) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public boolean overridesMethod() {
        return this.declaringMapper == null && this.executable.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    @Override
    public boolean matches(List<Type> sourceTypes, Type targetType) {
        MethodMatcher matcher = new MethodMatcher(this.typeUtils, this);
        return matcher.matches(sourceTypes, targetType);
    }

    public static boolean containsTargetTypeParameter(List<Parameter> parameters) {
        for (Parameter param : parameters) {
            if (!param.isTargetType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Type> getThrownTypes() {
        return this.exceptionTypes;
    }

    public void mergeWithInverseMappings(SourceMethod inverseMethod) {
        HashMap<String, List<Mapping>> newMappings = new HashMap<String, List<Mapping>>();
        if (inverseMethod != null && !inverseMethod.getMappings().isEmpty()) {
            for (List<Mapping> mappings : inverseMethod.getMappings().values()) {
                for (Mapping inverseMapping : mappings) {
                    Mapping reversed = inverseMapping.reverse(this, this.messager, this.typeFactory);
                    if (reversed == null) continue;
                    ArrayList<Mapping> mappingsOfProperty = (ArrayList<Mapping>)newMappings.get(reversed.getTargetName());
                    if (mappingsOfProperty == null) {
                        mappingsOfProperty = new ArrayList<Mapping>();
                        newMappings.put(reversed.getTargetName(), mappingsOfProperty);
                    }
                    mappingsOfProperty.add(reversed);
                }
            }
        }
        if (this.getMappings().isEmpty()) {
            this.setMappings(newMappings);
        } else {
            newMappings.putAll(this.getMappings());
            this.getMappings().clear();
            this.getMappings().putAll(newMappings);
        }
    }
}

