/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.processor.creation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.mapstruct.ap.conversion.ConversionProvider;
import org.mapstruct.ap.conversion.Conversions;
import org.mapstruct.ap.model.AssignmentFactory;
import org.mapstruct.ap.model.Direct;
import org.mapstruct.ap.model.MapperReference;
import org.mapstruct.ap.model.MappingBuilderContext;
import org.mapstruct.ap.model.VirtualMappingMethod;
import org.mapstruct.ap.model.assignment.Assignment;
import org.mapstruct.ap.model.common.DefaultConversionContext;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.model.source.builtin.BuiltInMappingMethods;
import org.mapstruct.ap.model.source.builtin.BuiltInMethod;
import org.mapstruct.ap.model.source.selector.MethodSelectors;
import org.mapstruct.ap.util.Strings;

public class MappingResolverImpl
implements MappingBuilderContext.MappingResolver {
    private final Messager messager;
    private final Types typeUtils;
    private final TypeFactory typeFactory;
    private final List<SourceMethod> sourceModel;
    private final List<MapperReference> mapperReferences;
    private final Conversions conversions;
    private final BuiltInMappingMethods builtInMethods;
    private final MethodSelectors methodSelectors;
    private final Set<VirtualMappingMethod> usedVirtualMappings = new HashSet<VirtualMappingMethod>();

    public MappingResolverImpl(Messager messager, Elements elementUtils, Types typeUtils, TypeFactory typeFactory, List<SourceMethod> sourceModel, List<MapperReference> mapperReferences) {
        this.messager = messager;
        this.typeUtils = typeUtils;
        this.typeFactory = typeFactory;
        this.sourceModel = sourceModel;
        this.mapperReferences = mapperReferences;
        this.conversions = new Conversions(elementUtils, typeFactory);
        this.builtInMethods = new BuiltInMappingMethods(typeFactory);
        this.methodSelectors = new MethodSelectors(typeUtils, elementUtils, typeFactory);
    }

    @Override
    public Assignment getTargetAssignment(Method mappingMethod, String mappedElement, Type sourceType, Type targetType, String targetPropertyName, String dateFormat, List<TypeMirror> qualifiers, String sourceReference) {
        ResolvingAttempt attempt = new ResolvingAttempt(this.sourceModel, mappingMethod, mappedElement, targetPropertyName, dateFormat, qualifiers, sourceReference);
        return attempt.getTargetAssignment(sourceType, targetType);
    }

    @Override
    public Set<VirtualMappingMethod> getUsedVirtualMappings() {
        return this.usedVirtualMappings;
    }

    private class ResolvingAttempt {
        private final Method mappingMethod;
        private final String mappedElement;
        private final List<SourceMethod> methods;
        private final String targetPropertyName;
        private final String dateFormat;
        private final List<TypeMirror> qualifiers;
        private final String sourceReference;
        private final Set<VirtualMappingMethod> virtualMethodCandidates;

        private ResolvingAttempt(List<SourceMethod> sourceModel, Method mappingMethod, String mappedElement, String targetPropertyName, String dateFormat, List<TypeMirror> qualifiers, String sourceReference) {
            this.mappingMethod = mappingMethod;
            this.mappedElement = mappedElement;
            this.methods = this.filterPossibleCandidateMethods(sourceModel);
            this.targetPropertyName = targetPropertyName;
            this.dateFormat = dateFormat;
            this.qualifiers = qualifiers;
            this.sourceReference = sourceReference;
            this.virtualMethodCandidates = new HashSet<VirtualMappingMethod>();
        }

        private <T extends Method> List<T> filterPossibleCandidateMethods(List<T> candidateMethods) {
            ArrayList<Method> result = new ArrayList<Method>(candidateMethods.size());
            for (Method candidate : candidateMethods) {
                if (!this.isCandidateForMapping(candidate)) continue;
                result.add(candidate);
            }
            return result;
        }

        private Assignment getTargetAssignment(Type sourceType, Type targetType) {
            Assignment referencedMethod = this.resolveViaMethod(sourceType, targetType, false);
            if (referencedMethod != null) {
                referencedMethod.setAssignment(AssignmentFactory.createDirect(this.sourceReference));
                return referencedMethod;
            }
            if (sourceType.isAssignableTo(targetType) || this.isPropertyMappable(sourceType, targetType)) {
                Direct simpleAssignment = AssignmentFactory.createDirect(this.sourceReference);
                return simpleAssignment;
            }
            Assignment conversion = this.resolveViaConversion(sourceType, targetType);
            if (conversion != null) {
                conversion.setAssignment(AssignmentFactory.createDirect(this.sourceReference));
                return conversion;
            }
            Assignment builtInMethod = this.resolveViaBuiltInMethod(sourceType, targetType);
            if (builtInMethod != null) {
                builtInMethod.setAssignment(AssignmentFactory.createDirect(this.sourceReference));
                MappingResolverImpl.this.usedVirtualMappings.addAll(this.virtualMethodCandidates);
                return builtInMethod;
            }
            referencedMethod = this.resolveViaMethodAndMethod(sourceType, targetType);
            if (referencedMethod != null) {
                MappingResolverImpl.this.usedVirtualMappings.addAll(this.virtualMethodCandidates);
                return referencedMethod;
            }
            referencedMethod = this.resolveViaConversionAndMethod(sourceType, targetType);
            if (referencedMethod != null) {
                MappingResolverImpl.this.usedVirtualMappings.addAll(this.virtualMethodCandidates);
                return referencedMethod;
            }
            conversion = this.resolveViaMethodAndConversion(sourceType, targetType);
            if (conversion != null) {
                MappingResolverImpl.this.usedVirtualMappings.addAll(this.virtualMethodCandidates);
                return conversion;
            }
            return null;
        }

        private Assignment resolveViaConversion(Type sourceType, Type targetType) {
            ConversionProvider conversionProvider = MappingResolverImpl.this.conversions.getConversion(sourceType, targetType);
            if (conversionProvider == null) {
                return null;
            }
            DefaultConversionContext ctx = new DefaultConversionContext(MappingResolverImpl.this.typeFactory, targetType, this.dateFormat);
            return conversionProvider.to(ctx);
        }

        private Assignment resolveViaMethod(Type sourceType, Type targetType, boolean considerBuiltInMethods) {
            SourceMethod matchingSourceMethod = this.getBestMatch(this.methods, sourceType, targetType);
            if (matchingSourceMethod != null) {
                return this.getMappingMethodReference(matchingSourceMethod, targetType);
            }
            if (considerBuiltInMethods) {
                return this.resolveViaBuiltInMethod(sourceType, targetType);
            }
            return null;
        }

        private Assignment resolveViaBuiltInMethod(Type sourceType, Type targetType) {
            BuiltInMethod matchingBuiltInMethod = this.getBestMatch(MappingResolverImpl.this.builtInMethods.getBuiltInMethods(), sourceType, targetType);
            if (matchingBuiltInMethod != null) {
                this.virtualMethodCandidates.add(new VirtualMappingMethod(matchingBuiltInMethod));
                DefaultConversionContext ctx = new DefaultConversionContext(MappingResolverImpl.this.typeFactory, targetType, this.dateFormat);
                Assignment methodReference = AssignmentFactory.createMethodReference(matchingBuiltInMethod, ctx);
                methodReference.setAssignment(AssignmentFactory.createDirect(this.sourceReference));
                return methodReference;
            }
            return null;
        }

        private Assignment resolveViaMethodAndMethod(Type sourceType, Type targetType) {
            ArrayList<SourceMethod> methodYCandidates = new ArrayList<SourceMethod>(this.methods);
            methodYCandidates.addAll(MappingResolverImpl.this.builtInMethods.getBuiltInMethods());
            Assignment methodRefY = null;
            for (Method method : methodYCandidates) {
                methodRefY = this.resolveViaMethod(method.getSourceParameters().get(0).getType(), targetType, true);
                if (methodRefY == null) continue;
                Assignment methodRefX = this.resolveViaMethod(sourceType, method.getSourceParameters().get(0).getType(), true);
                if (methodRefX != null) {
                    methodRefY.setAssignment(methodRefX);
                    methodRefX.setAssignment(AssignmentFactory.createDirect(this.sourceReference));
                    break;
                }
                this.virtualMethodCandidates.clear();
                methodRefY = null;
            }
            return methodRefY;
        }

        private Assignment resolveViaConversionAndMethod(Type sourceType, Type targetType) {
            ArrayList<SourceMethod> methodYCandidates = new ArrayList<SourceMethod>(this.methods);
            methodYCandidates.addAll(MappingResolverImpl.this.builtInMethods.getBuiltInMethods());
            Assignment methodRefY = null;
            for (Method method : methodYCandidates) {
                methodRefY = this.resolveViaMethod(method.getSourceParameters().get(0).getType(), targetType, true);
                if (methodRefY == null) continue;
                Assignment conversionXRef = this.resolveViaConversion(sourceType, method.getSourceParameters().get(0).getType());
                if (conversionXRef != null) {
                    methodRefY.setAssignment(conversionXRef);
                    conversionXRef.setAssignment(AssignmentFactory.createDirect(this.sourceReference));
                    break;
                }
                this.virtualMethodCandidates.clear();
                methodRefY = null;
            }
            return methodRefY;
        }

        private Assignment resolveViaMethodAndConversion(Type sourceType, Type targetType) {
            ArrayList<SourceMethod> methodXCandidates = new ArrayList<SourceMethod>(this.methods);
            methodXCandidates.addAll(MappingResolverImpl.this.builtInMethods.getBuiltInMethods());
            Assignment conversionYRef = null;
            for (Method method : methodXCandidates) {
                Assignment methodRefX = this.resolveViaMethod(sourceType, method.getReturnType(), true);
                if (methodRefX == null) continue;
                conversionYRef = this.resolveViaConversion(method.getReturnType(), targetType);
                if (conversionYRef != null) {
                    conversionYRef.setAssignment(methodRefX);
                    methodRefX.setAssignment(AssignmentFactory.createDirect(this.sourceReference));
                    break;
                }
                this.virtualMethodCandidates.clear();
                conversionYRef = null;
            }
            return conversionYRef;
        }

        private boolean isCandidateForMapping(Method methodCandidate) {
            return methodCandidate.getSourceParameters().size() == 1 && !methodCandidate.getReturnType().isVoid() && methodCandidate.getTargetParameter() == null;
        }

        private <T extends Method> T getBestMatch(List<T> methods, Type sourceType, Type returnType) {
            List<T> candidates = MappingResolverImpl.this.methodSelectors.getMatchingMethods(this.mappingMethod, methods, sourceType, returnType, this.qualifiers, this.targetPropertyName);
            if (candidates.size() > 1) {
                String errorMsg = String.format("Ambiguous mapping methods found for mapping " + this.mappedElement + " to %s: %s.", returnType, Strings.join(candidates, ", "));
                MappingResolverImpl.this.messager.printMessage(Diagnostic.Kind.ERROR, errorMsg, this.mappingMethod.getExecutable());
            }
            if (!candidates.isEmpty()) {
                return (T)((Method)candidates.get(0));
            }
            return null;
        }

        private Assignment getMappingMethodReference(SourceMethod method, Type targetType) {
            MapperReference mapperReference = this.findMapperReference(method);
            return AssignmentFactory.createMethodReference(method, mapperReference, SourceMethod.containsTargetTypeParameter(method.getParameters()) ? targetType : null);
        }

        private MapperReference findMapperReference(SourceMethod method) {
            for (MapperReference ref : MappingResolverImpl.this.mapperReferences) {
                if (!ref.getType().equals(method.getDeclaringMapper())) continue;
                return ref;
            }
            return null;
        }

        private boolean isPropertyMappable(Type sourceType, Type targetType) {
            boolean collectionOrMapTargetTypeHasCompatibleConstructor = false;
            if (sourceType.isCollectionType() && targetType.isCollectionType()) {
                collectionOrMapTargetTypeHasCompatibleConstructor = this.collectionTypeHasCompatibleConstructor(sourceType, targetType.getImplementationType() != null ? targetType.getImplementationType() : targetType);
            }
            if (sourceType.isMapType() && targetType.isMapType()) {
                collectionOrMapTargetTypeHasCompatibleConstructor = this.mapTypeHasCompatibleConstructor(sourceType, targetType.getImplementationType() != null ? targetType.getImplementationType() : targetType);
            }
            return (targetType.isCollectionType() || targetType.isMapType()) && collectionOrMapTargetTypeHasCompatibleConstructor;
        }

        private boolean collectionTypeHasCompatibleConstructor(Type sourceType, Type targetType) {
            TypeMirror sourceElementType = sourceType.getTypeParameters().isEmpty() ? MappingResolverImpl.this.typeFactory.getType(Object.class).getTypeMirror() : sourceType.getTypeParameters().get(0).getTypeMirror();
            TypeMirror targetElementType = targetType.getTypeParameters().isEmpty() ? MappingResolverImpl.this.typeFactory.getType(Object.class).getTypeMirror() : targetType.getTypeParameters().get(0).getTypeMirror();
            return MappingResolverImpl.this.typeUtils.isAssignable(sourceElementType, targetElementType);
        }

        private boolean mapTypeHasCompatibleConstructor(Type sourceType, Type targetType) {
            TypeMirror targetValueType;
            TypeMirror targetKeyType;
            TypeMirror sourceValueType;
            TypeMirror sourceKeyType;
            if (sourceType.getTypeParameters().isEmpty()) {
                sourceKeyType = MappingResolverImpl.this.typeFactory.getType(Object.class).getTypeMirror();
                sourceValueType = MappingResolverImpl.this.typeFactory.getType(Object.class).getTypeMirror();
            } else {
                sourceKeyType = sourceType.getTypeParameters().get(0).getTypeMirror();
                sourceValueType = sourceType.getTypeParameters().get(1).getTypeMirror();
            }
            if (targetType.getTypeParameters().isEmpty()) {
                targetKeyType = MappingResolverImpl.this.typeFactory.getType(Object.class).getTypeMirror();
                targetValueType = MappingResolverImpl.this.typeFactory.getType(Object.class).getTypeMirror();
            } else {
                targetKeyType = targetType.getTypeParameters().get(0).getTypeMirror();
                targetValueType = targetType.getTypeParameters().get(1).getTypeMirror();
            }
            return MappingResolverImpl.this.typeUtils.isAssignable(sourceKeyType, targetKeyType) && MappingResolverImpl.this.typeUtils.isAssignable(sourceValueType, targetValueType);
        }
    }
}

