/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.model.source.BeanMapping;
import org.mapstruct.ap.model.source.IterableMapping;
import org.mapstruct.ap.model.source.MapMapping;
import org.mapstruct.ap.model.source.Mapping;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.util.FormattingMessager;

public class MappingOptions {
    private Map<String, List<Mapping>> mappings;
    private IterableMapping iterableMapping;
    private MapMapping mapMapping;
    private BeanMapping beanMapping;
    private boolean fullyInitialized;

    public MappingOptions(Map<String, List<Mapping>> mappings, IterableMapping iterableMapping, MapMapping mapMapping, BeanMapping beanMapping) {
        this.mappings = mappings;
        this.iterableMapping = iterableMapping;
        this.mapMapping = mapMapping;
        this.beanMapping = beanMapping;
    }

    public Map<String, List<Mapping>> getMappings() {
        return this.mappings;
    }

    public IterableMapping getIterableMapping() {
        return this.iterableMapping;
    }

    public MapMapping getMapMapping() {
        return this.mapMapping;
    }

    public BeanMapping getBeanMapping() {
        return this.beanMapping;
    }

    public void setMappings(Map<String, List<Mapping>> mappings) {
        this.mappings = mappings;
    }

    public void setIterableMapping(IterableMapping iterableMapping) {
        this.iterableMapping = iterableMapping;
    }

    public void setMapMapping(MapMapping mapMapping) {
        this.mapMapping = mapMapping;
    }

    public void setBeanMapping(BeanMapping beanMapping) {
        this.beanMapping = beanMapping;
    }

    public boolean isFullyInitialized() {
        return this.fullyInitialized;
    }

    public void markAsFullyInitialized() {
        this.fullyInitialized = true;
    }

    public void applyInheritedOptions(MappingOptions inherited, boolean isInverse, SourceMethod method, FormattingMessager messager, TypeFactory typeFactory) {
        if (null != inherited) {
            if (this.getIterableMapping() == null && inherited.getIterableMapping() != null) {
                this.setIterableMapping(inherited.getIterableMapping());
            }
            if (this.getMapMapping() == null && inherited.getMapMapping() != null) {
                this.setMapMapping(inherited.getMapMapping());
            }
            if (this.getBeanMapping() == null && inherited.getBeanMapping() != null) {
                this.setBeanMapping(inherited.getBeanMapping());
            }
            HashMap<String, List<Mapping>> newMappings = new HashMap<String, List<Mapping>>();
            for (List<Mapping> lmappings : inherited.getMappings().values()) {
                for (Mapping mapping : lmappings) {
                    if (isInverse) {
                        mapping = mapping.reverse(method, messager, typeFactory);
                    }
                    if (mapping == null) continue;
                    ArrayList<Mapping> mappingsOfProperty = (ArrayList<Mapping>)newMappings.get(mapping.getTargetName());
                    if (mappingsOfProperty == null) {
                        mappingsOfProperty = new ArrayList<Mapping>();
                        newMappings.put(mapping.getTargetName(), mappingsOfProperty);
                    }
                    mappingsOfProperty.add(mapping.copyForInheritanceTo(method));
                }
            }
            newMappings.putAll(this.getMappings());
            this.setMappings(newMappings);
        }
        this.markAsFullyInitialized();
    }
}

