/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.model.source.BeanMapping;
import org.mapstruct.ap.model.source.IterableMapping;
import org.mapstruct.ap.model.source.MapMapping;
import org.mapstruct.ap.model.source.Mapping;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.prism.BeanMappingPrism;
import org.mapstruct.ap.prism.IterableMappingPrism;
import org.mapstruct.ap.prism.MapMappingPrism;
import org.mapstruct.ap.prism.MappingPrism;
import org.mapstruct.ap.prism.MappingsPrism;
import org.mapstruct.ap.processor.ModelElementProcessor;
import org.mapstruct.ap.util.AnnotationProcessingException;
import org.mapstruct.ap.util.Executables;
import org.mapstruct.ap.util.FormattingMessager;
import org.mapstruct.ap.util.MapperConfiguration;
import org.mapstruct.ap.util.Message;

public class MethodRetrievalProcessor
implements ModelElementProcessor<Void, List<SourceMethod>> {
    private FormattingMessager messager;
    private TypeFactory typeFactory;
    private Types typeUtils;
    private Elements elementUtils;

    @Override
    public List<SourceMethod> process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, Void sourceModel) {
        this.messager = context.getMessager();
        this.typeFactory = context.getTypeFactory();
        this.typeUtils = context.getTypeUtils();
        this.elementUtils = context.getElementUtils();
        MapperConfiguration mapperConfig = MapperConfiguration.getInstanceOn(mapperTypeElement);
        if (!mapperConfig.isValid()) {
            throw new AnnotationProcessingException("Couldn't retrieve @Mapper annotation", mapperTypeElement, mapperConfig.getAnnotationMirror());
        }
        List<SourceMethod> prototypeMethods = this.retrievePrototypeMethods(mapperConfig.getMapperConfigMirror(), mapperConfig);
        return this.retrieveMethods(mapperTypeElement, mapperTypeElement, mapperConfig, prototypeMethods);
    }

    @Override
    public int getPriority() {
        return 1;
    }

    private List<SourceMethod> retrievePrototypeMethods(TypeMirror typeMirror, MapperConfiguration mapperConfig) {
        if (typeMirror == null || typeMirror.getKind() == TypeKind.VOID) {
            return Collections.emptyList();
        }
        TypeElement typeElement = this.asTypeElement(typeMirror);
        ArrayList<SourceMethod> methods = new ArrayList<SourceMethod>();
        for (ExecutableElement executable : Executables.getAllEnclosedExecutableElements(this.elementUtils, typeElement)) {
            List<SourceMethod> prototypeMethods;
            boolean containsTargetTypeParameter;
            List<Parameter> parameters;
            ExecutableType methodType = this.typeFactory.getMethodType(typeElement, executable);
            SourceMethod method = this.getMethodRequiringImplementation(methodType, executable, parameters = this.typeFactory.getParameters(methodType, executable), containsTargetTypeParameter = SourceMethod.containsTargetTypeParameter(parameters), mapperConfig, prototypeMethods = Collections.emptyList());
            if (method == null) continue;
            methods.add(method);
        }
        return methods;
    }

    private List<SourceMethod> retrieveMethods(TypeElement usedMapper, TypeElement mapperToImplement, MapperConfiguration mapperConfig, List<SourceMethod> prototypeMethods) {
        ArrayList<SourceMethod> methods = new ArrayList<SourceMethod>();
        for (ExecutableElement executable : Executables.getAllEnclosedExecutableElements(this.elementUtils, usedMapper)) {
            SourceMethod method = this.getMethod(usedMapper, executable, mapperToImplement, mapperConfig, prototypeMethods);
            if (method == null) continue;
            methods.add(method);
        }
        if (usedMapper.equals(mapperToImplement)) {
            for (TypeMirror mapper : mapperConfig.uses()) {
                methods.addAll(this.retrieveMethods(this.asTypeElement(mapper), mapperToImplement, mapperConfig, prototypeMethods));
            }
        }
        return methods;
    }

    private TypeElement asTypeElement(TypeMirror usedMapper) {
        return (TypeElement)((DeclaredType)usedMapper).asElement();
    }

    private SourceMethod getMethod(TypeElement usedMapper, ExecutableElement method, TypeElement mapperToImplement, MapperConfiguration mapperConfig, List<SourceMethod> prototypeMethods) {
        ExecutableType methodType = this.typeFactory.getMethodType(usedMapper, method);
        List<Parameter> parameters = this.typeFactory.getParameters(methodType, method);
        boolean methodRequiresImplementation = method.getModifiers().contains((Object)Modifier.ABSTRACT);
        boolean containsTargetTypeParameter = SourceMethod.containsTargetTypeParameter(parameters);
        if (usedMapper.equals(mapperToImplement) && methodRequiresImplementation) {
            return this.getMethodRequiringImplementation(methodType, method, parameters, containsTargetTypeParameter, mapperConfig, prototypeMethods);
        }
        if (this.isValidReferencedMethod(parameters) || this.isValidFactoryMethod(parameters)) {
            return this.getReferencedMethod(usedMapper, methodType, method, mapperToImplement, parameters);
        }
        return null;
    }

    private SourceMethod getMethodRequiringImplementation(ExecutableType methodType, ExecutableElement method, List<Parameter> parameters, boolean containsTargetTypeParameter, MapperConfiguration mapperConfig, List<SourceMethod> prototypeMethods) {
        Type resultType;
        Parameter targetParameter;
        Type returnType = this.typeFactory.getReturnType(methodType);
        List<Type> exceptionTypes = this.typeFactory.getThrownTypes(methodType);
        List<Parameter> sourceParameters = this.extractSourceParameters(parameters);
        boolean isValid = this.checkParameterAndReturnType(method, sourceParameters, targetParameter = this.extractTargetParameter(parameters), resultType = this.selectResultType(returnType, targetParameter), returnType, containsTargetTypeParameter);
        if (!isValid) {
            return null;
        }
        return new SourceMethod.Builder().setExecutable(method).setParameters(parameters).setReturnType(returnType).setExceptionTypes(exceptionTypes).setMappings(this.getMappings(method)).setIterableMapping(IterableMapping.fromPrism(IterableMappingPrism.getInstanceOn(method), method, this.messager)).setMapMapping(MapMapping.fromPrism(MapMappingPrism.getInstanceOn(method), method, this.messager)).setBeanMapping(BeanMapping.fromPrism(BeanMappingPrism.getInstanceOn(method), method, this.messager)).setTypeUtils(this.typeUtils).setMessager(this.messager).setTypeFactory(this.typeFactory).setMapperConfiguration(mapperConfig).setPrototypeMethods(prototypeMethods).build();
    }

    private SourceMethod getReferencedMethod(TypeElement usedMapper, ExecutableType methodType, ExecutableElement method, TypeElement mapperToImplement, List<Parameter> parameters) {
        Type returnType = this.typeFactory.getReturnType(methodType);
        List<Type> exceptionTypes = this.typeFactory.getThrownTypes(methodType);
        Type usedMapperAsType = this.typeFactory.getType(usedMapper);
        Type mapperToImplementAsType = this.typeFactory.getType(mapperToImplement);
        if (!mapperToImplementAsType.canAccess(usedMapperAsType, method)) {
            return null;
        }
        return new SourceMethod.Builder().setDeclaringMapper(usedMapper.equals(mapperToImplement) ? null : usedMapperAsType).setExecutable(method).setParameters(parameters).setReturnType(returnType).setExceptionTypes(exceptionTypes).setTypeUtils(this.typeUtils).setTypeFactory(this.typeFactory).build();
    }

    private boolean isValidReferencedMethod(List<Parameter> parameters) {
        int validSourceParameters = 0;
        int targetParameters = 0;
        int targetTypeParameters = 0;
        for (Parameter param : parameters) {
            if (param.isMappingTarget()) {
                ++targetParameters;
            }
            if (param.isTargetType()) {
                ++targetTypeParameters;
            }
            if (param.isMappingTarget() || param.isTargetType()) continue;
            ++validSourceParameters;
        }
        return validSourceParameters == 1 && targetParameters <= 1 && targetTypeParameters <= 1 && parameters.size() == validSourceParameters + targetParameters + targetTypeParameters;
    }

    private boolean isValidFactoryMethod(List<Parameter> parameters) {
        int validSourceParameters = 0;
        int targetParameters = 0;
        int targetTypeParameters = 0;
        for (Parameter param : parameters) {
            if (param.isMappingTarget()) {
                ++targetParameters;
            }
            if (param.isTargetType()) {
                ++targetTypeParameters;
            }
            if (param.isMappingTarget() || param.isTargetType()) continue;
            ++validSourceParameters;
        }
        return validSourceParameters == 0 && targetParameters == 0 && targetTypeParameters <= 1 && parameters.size() == validSourceParameters + targetParameters + targetTypeParameters;
    }

    private Parameter extractTargetParameter(List<Parameter> parameters) {
        for (Parameter param : parameters) {
            if (!param.isMappingTarget()) continue;
            return param;
        }
        return null;
    }

    private List<Parameter> extractSourceParameters(List<Parameter> parameters) {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>(parameters.size());
        for (Parameter param : parameters) {
            if (param.isMappingTarget()) continue;
            sourceParameters.add(param);
        }
        return sourceParameters;
    }

    private Type selectResultType(Type returnType, Parameter targetParameter) {
        if (null != targetParameter) {
            return targetParameter.getType();
        }
        return returnType;
    }

    private boolean checkParameterAndReturnType(ExecutableElement method, List<Parameter> sourceParameters, Parameter targetParameter, Type resultType, Type returnType, boolean containsTargetTypeParameter) {
        if (sourceParameters.isEmpty()) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_NO_INPUT_ARGS, new Object[0]);
            return false;
        }
        if (targetParameter != null && sourceParameters.size() + 1 != method.getParameters().size()) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_DUPLICATE_MAPPING_TARGETS, new Object[0]);
            return false;
        }
        if (resultType.getTypeMirror().getKind() == TypeKind.VOID) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_VOID_MAPPING_METHOD, new Object[0]);
            return false;
        }
        if (returnType.getTypeMirror().getKind() != TypeKind.VOID && !resultType.isAssignableTo(returnType)) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_NON_ASSIGNABLE_RESULTTYPE, new Object[0]);
            return false;
        }
        Type parameterType = sourceParameters.get(0).getType();
        if (parameterType.isIterableType() && !resultType.isIterableType()) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_ITERABLE_TO_NON_ITERABLE, new Object[0]);
            return false;
        }
        if (containsTargetTypeParameter) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_MAPPING_HAS_TARGET_TYPE_PARAMETER, new Object[0]);
            return false;
        }
        if (!parameterType.isIterableType() && resultType.isIterableType()) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_NON_ITERABLE_TO_ITERABLE, new Object[0]);
            return false;
        }
        if (parameterType.isPrimitive()) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_PRIMITIVE_PARAMETER, new Object[0]);
            return false;
        }
        if (resultType.isPrimitive()) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_PRIMITIVE_RETURN, new Object[0]);
            return false;
        }
        if (parameterType.isEnumType() && !resultType.isEnumType()) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_ENUM_TO_NON_ENUM, new Object[0]);
            return false;
        }
        if (!parameterType.isEnumType() && resultType.isEnumType()) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_NON_ENUM_TO_ENUM, new Object[0]);
            return false;
        }
        return true;
    }

    private Map<String, List<Mapping>> getMappings(ExecutableElement method) {
        HashMap<String, List<Mapping>> mappings = new HashMap<String, List<Mapping>>();
        MappingPrism mappingAnnotation = MappingPrism.getInstanceOn(method);
        MappingsPrism mappingsAnnotation = MappingsPrism.getInstanceOn(method);
        if (mappingAnnotation != null) {
            Mapping mapping;
            if (!mappings.containsKey(mappingAnnotation.target())) {
                mappings.put(mappingAnnotation.target(), new ArrayList());
            }
            if ((mapping = Mapping.fromMappingPrism(mappingAnnotation, method, this.messager)) != null) {
                ((List)mappings.get(mappingAnnotation.target())).add(mapping);
            }
        }
        if (mappingsAnnotation != null) {
            mappings.putAll(Mapping.fromMappingsPrism(mappingsAnnotation, method, this.messager));
        }
        return mappings;
    }
}

