/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.List;
import java.util.SortedSet;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.mapstruct.ap.internal.model.Decorator;
import org.mapstruct.ap.internal.model.GeneratedType;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.common.Accessibility;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.version.VersionInformation;

public class Mapper
extends GeneratedType {
    private static final String IMPLEMENTATION_SUFFIX = "Impl";
    private static final String DECORATED_IMPLEMENTATION_SUFFIX = "Impl_";
    private final List<MapperReference> referencedMappers;
    private Decorator decorator;

    private Mapper(TypeFactory typeFactory, String packageName, String name, String superClassName, String interfaceName, List<MappingMethod> methods, Options options, VersionInformation versionInformation, Accessibility accessibility, List<MapperReference> referencedMappers, Decorator decorator, SortedSet<Type> extraImportedTypes) {
        super(typeFactory, packageName, name, superClassName, interfaceName, methods, referencedMappers, options, versionInformation, accessibility, extraImportedTypes, null);
        this.referencedMappers = referencedMappers;
        this.decorator = decorator;
    }

    public List<MapperReference> getReferencedMappers() {
        return this.referencedMappers;
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public void removeDecorator() {
        this.decorator = null;
    }

    @Override
    protected String getTemplateName() {
        return this.getTemplateNameForClass(GeneratedType.class);
    }

    public static class Builder {
        private TypeFactory typeFactory;
        private TypeElement element;
        private List<MappingMethod> mappingMethods;
        private List<MapperReference> mapperReferences;
        private SortedSet<Type> extraImportedTypes;
        private Elements elementUtils;
        private Options options;
        private VersionInformation versionInformation;
        private Decorator decorator;

        public Builder element(TypeElement element) {
            this.element = element;
            return this;
        }

        public Builder mappingMethods(List<MappingMethod> mappingMethods) {
            this.mappingMethods = mappingMethods;
            return this;
        }

        public Builder mapperReferences(List<MapperReference> mapperReferences) {
            this.mapperReferences = mapperReferences;
            return this;
        }

        public Builder options(Options options) {
            this.options = options;
            return this;
        }

        public Builder versionInformation(VersionInformation versionInformation) {
            this.versionInformation = versionInformation;
            return this;
        }

        public Builder typeFactory(TypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            return this;
        }

        public Builder elementUtils(Elements elementUtils) {
            this.elementUtils = elementUtils;
            return this;
        }

        public Builder decorator(Decorator decorator) {
            this.decorator = decorator;
            return this;
        }

        public Builder extraImports(SortedSet<Type> extraImportedTypes) {
            this.extraImportedTypes = extraImportedTypes;
            return this;
        }

        public Mapper build() {
            String implementationName = this.element.getSimpleName() + (this.decorator == null ? Mapper.IMPLEMENTATION_SUFFIX : Mapper.DECORATED_IMPLEMENTATION_SUFFIX);
            return new Mapper(this.typeFactory, this.elementUtils.getPackageOf(this.element).getQualifiedName().toString(), implementationName, this.element.getKind() != ElementKind.INTERFACE ? this.element.getSimpleName().toString() : null, this.element.getKind() == ElementKind.INTERFACE ? this.element.getSimpleName().toString() : null, this.mappingMethods, this.options, this.versionInformation, Accessibility.fromModifiers(this.element.getModifiers()), this.mapperReferences, this.decorator, this.extraImportedTypes);
        }
    }
}

