/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.prism;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class MappingPrism {
    private String _target;
    private String _source;
    private String _dateFormat;
    private String _constant;
    private String _expression;
    private Boolean _ignore;
    private List<TypeMirror> _qualifiedBy;
    private TypeMirror _resultType;
    private List<String> _dependsOn;
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    public static MappingPrism getInstanceOn(Element e) {
        AnnotationMirror m = MappingPrism.getMirror("org.mapstruct.Mapping", e);
        if (m == null) {
            return null;
        }
        return MappingPrism.getInstance(m);
    }

    public static MappingPrism getInstance(AnnotationMirror mirror) {
        return new MappingPrism(mirror);
    }

    private MappingPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._target = this.getValue("target", String.class);
        this._source = this.getValue("source", String.class);
        this._dateFormat = this.getValue("dateFormat", String.class);
        this._constant = this.getValue("constant", String.class);
        this._expression = this.getValue("expression", String.class);
        this._ignore = this.getValue("ignore", Boolean.class);
        this._qualifiedBy = this.getArrayValues("qualifiedBy", TypeMirror.class);
        this._resultType = this.getValue("resultType", TypeMirror.class);
        this._dependsOn = this.getArrayValues("dependsOn", String.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String target() {
        return this._target;
    }

    public String source() {
        return this._source;
    }

    public String dateFormat() {
        return this._dateFormat;
    }

    public String constant() {
        return this._constant;
    }

    public String expression() {
        return this._expression;
    }

    public Boolean ignore() {
        return this._ignore;
    }

    public List<TypeMirror> qualifiedBy() {
        return this._qualifiedBy;
    }

    public TypeMirror resultType() {
        return this._resultType;
    }

    public List<String> dependsOn() {
        return this._dependsOn;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = MappingPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = MappingPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : MappingPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return null;
            }
            return result;
        }
        return null;
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    public static class Values {
        private Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public AnnotationValue target() {
            return this.values.get("target");
        }

        public AnnotationValue source() {
            return this.values.get("source");
        }

        public AnnotationValue dateFormat() {
            return this.values.get("dateFormat");
        }

        public AnnotationValue constant() {
            return this.values.get("constant");
        }

        public AnnotationValue expression() {
            return this.values.get("expression");
        }

        public AnnotationValue ignore() {
            return this.values.get("ignore");
        }

        public AnnotationValue qualifiedBy() {
            return this.values.get("qualifiedBy");
        }

        public AnnotationValue resultType() {
            return this.values.get("resultType");
        }

        public AnnotationValue dependsOn() {
            return this.values.get("dependsOn");
        }
    }
}

