/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.util.List;
import java.util.ListIterator;
import javax.lang.model.element.TypeElement;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.AnnotationMapperReference;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.option.OptionsHelper;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;
import org.mapstruct.ap.internal.util.MapperConfiguration;

public abstract class AnnotationBasedComponentModelProcessor
implements ModelElementProcessor<Mapper, Mapper> {
    private TypeFactory typeFactory;

    @Override
    public Mapper process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, Mapper mapper) {
        this.typeFactory = context.getTypeFactory();
        String componentModel = MapperConfiguration.getInstanceOn(mapperTypeElement).componentModel();
        String effectiveComponentModel = OptionsHelper.getEffectiveComponentModel(context.getOptions(), componentModel);
        if (!this.getComponentModelIdentifier().equalsIgnoreCase(effectiveComponentModel)) {
            return mapper;
        }
        for (Annotation typeAnnotation : this.getTypeAnnotations(mapper)) {
            mapper.addAnnotation(typeAnnotation);
        }
        if (!this.requiresGenerationOfDecoratorClass()) {
            mapper.removeDecorator();
        }
        ListIterator<MapperReference> iterator = mapper.getReferencedMappers().listIterator();
        while (iterator.hasNext()) {
            MapperReference reference = iterator.next();
            iterator.remove();
            iterator.add(this.replacementMapperReference(reference));
        }
        return mapper;
    }

    protected MapperReference replacementMapperReference(MapperReference originalReference) {
        return new AnnotationMapperReference(originalReference.getType(), originalReference.getVariableName(), this.getMapperReferenceAnnotation(), originalReference.isUsed());
    }

    protected abstract String getComponentModelIdentifier();

    protected abstract List<Annotation> getTypeAnnotations(Mapper var1);

    protected abstract Annotation getMapperReferenceAnnotation();

    protected abstract boolean requiresGenerationOfDecoratorClass();

    @Override
    public int getPriority() {
        return 1100;
    }

    protected TypeFactory getTypeFactory() {
        return this.typeFactory;
    }
}

