/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.assignment.Assignment;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.builtin.BuiltInMethod;

public class MethodReference
extends MappingMethod
implements Assignment {
    private final MapperReference declaringMapper;
    private final Set<Type> importTypes;
    private final List<Type> thrownTypes;
    private final boolean isUpdateMethod;
    private final String contextParam;
    private Assignment assignment;

    public MethodReference(Method method, MapperReference declaringMapper, Type targetType) {
        super(method);
        this.declaringMapper = declaringMapper;
        this.contextParam = null;
        HashSet<Type> imported = new HashSet<Type>(method.getThrownTypes());
        if (targetType != null) {
            imported.add(targetType);
        }
        this.importTypes = Collections.unmodifiableSet(imported);
        this.thrownTypes = method.getThrownTypes();
        this.isUpdateMethod = method.getMappingTargetParameter() != null;
    }

    public MethodReference(BuiltInMethod method, ConversionContext contextParam) {
        super(method);
        this.declaringMapper = null;
        this.contextParam = method.getContextParameter(contextParam);
        this.importTypes = Collections.emptySet();
        this.thrownTypes = Collections.emptyList();
        this.isUpdateMethod = method.getMappingTargetParameter() != null;
    }

    public MapperReference getDeclaringMapper() {
        return this.declaringMapper;
    }

    public String getMapperVariableName() {
        return this.declaringMapper.getVariableName();
    }

    public String getContextParam() {
        return this.contextParam;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    @Override
    public void setAssignment(Assignment assignment) {
        this.assignment = assignment;
    }

    @Override
    public String getSourceReference() {
        return this.assignment.getSourceReference();
    }

    public Type getSingleSourceParameterType() {
        for (Parameter parameter : this.getSourceParameters()) {
            if (parameter.isTargetType()) continue;
            return parameter.getType();
        }
        return null;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> imported = new HashSet<Type>(this.importTypes);
        if (this.assignment != null) {
            imported.addAll(this.assignment.getImportTypes());
        }
        return imported;
    }

    @Override
    public List<Type> getThrownTypes() {
        ArrayList<Type> exceptions = new ArrayList<Type>();
        exceptions.addAll(this.thrownTypes);
        if (this.assignment != null) {
            exceptions.addAll(this.assignment.getThrownTypes());
        }
        return exceptions;
    }

    @Override
    public Assignment.AssignmentType getType() {
        switch (this.assignment.getType()) {
            case DIRECT: {
                return Assignment.AssignmentType.MAPPED;
            }
            case MAPPED: {
                return Assignment.AssignmentType.MAPPED_TWICE;
            }
            case TYPE_CONVERTED: {
                return Assignment.AssignmentType.TYPE_CONVERTED_MAPPED;
            }
        }
        return null;
    }

    @Override
    public boolean isUpdateMethod() {
        return this.isUpdateMethod;
    }
}

