/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.DateFormatValidationResult;
import org.mapstruct.ap.internal.model.common.DateFormatValidator;
import org.mapstruct.ap.internal.model.common.DateFormatValidatorFactory;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Strings;

public class DefaultConversionContext
implements ConversionContext {
    private final FormattingMessager messager;
    private final Type sourceType;
    private final Type targetType;
    private final String dateFormat;
    private final TypeFactory typeFactory;

    public DefaultConversionContext(TypeFactory typeFactory, FormattingMessager messager, Type sourceType, Type targetType, String dateFormat) {
        this.typeFactory = typeFactory;
        this.messager = messager;
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.dateFormat = dateFormat;
        this.validateDateFormat();
    }

    private void validateDateFormat() {
        DateFormatValidator dateFormatValidator;
        DateFormatValidationResult validationResult;
        if (!Strings.isEmpty(this.dateFormat) && !(validationResult = (dateFormatValidator = DateFormatValidatorFactory.forTypes(this.sourceType, this.targetType)).validate(this.dateFormat)).isValid()) {
            validationResult.printErrorMessage(this.messager);
        }
    }

    @Override
    public Type getTargetType() {
        return this.targetType;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    protected FormattingMessager getMessager() {
        return this.messager;
    }
}

