/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.builtin;

import java.util.List;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.builtin.BuiltInMethod;
import org.mapstruct.ap.internal.model.source.builtin.CalendarToXmlGregorianCalendar;
import org.mapstruct.ap.internal.model.source.builtin.CalendarToZonedDateTime;
import org.mapstruct.ap.internal.model.source.builtin.DateToXmlGregorianCalendar;
import org.mapstruct.ap.internal.model.source.builtin.JaxbElemToValue;
import org.mapstruct.ap.internal.model.source.builtin.StringToXmlGregorianCalendar;
import org.mapstruct.ap.internal.model.source.builtin.XmlGregorianCalendarToCalendar;
import org.mapstruct.ap.internal.model.source.builtin.XmlGregorianCalendarToDate;
import org.mapstruct.ap.internal.model.source.builtin.XmlGregorianCalendarToString;
import org.mapstruct.ap.internal.model.source.builtin.ZonedDateTimeToCalendar;
import org.mapstruct.ap.internal.util.Collections;

public class BuiltInMappingMethods {
    private final List<BuiltInMethod> builtInMethods;

    public BuiltInMappingMethods(TypeFactory typeFactory) {
        this.builtInMethods = Collections.newArrayList(new DateToXmlGregorianCalendar(typeFactory), new XmlGregorianCalendarToDate(typeFactory), new StringToXmlGregorianCalendar(typeFactory), new XmlGregorianCalendarToString(typeFactory), new CalendarToXmlGregorianCalendar(typeFactory), new XmlGregorianCalendarToCalendar(typeFactory));
        if (BuiltInMappingMethods.isJaxbAvailable(typeFactory)) {
            this.builtInMethods.add(new JaxbElemToValue(typeFactory));
        }
        if (BuiltInMappingMethods.isJava8TimeAvailable(typeFactory)) {
            this.builtInMethods.add(new ZonedDateTimeToCalendar(typeFactory));
            this.builtInMethods.add(new CalendarToZonedDateTime(typeFactory));
        }
    }

    private static boolean isJaxbAvailable(TypeFactory typeFactory) {
        return typeFactory.isTypeAvailable("javax.xml.bind.JAXBElement");
    }

    private static boolean isJava8TimeAvailable(TypeFactory typeFactory) {
        return typeFactory.isTypeAvailable("java.time.ZonedDateTime");
    }

    public List<BuiltInMethod> getBuiltInMethods() {
        return this.builtInMethods;
    }
}

