/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.spi;

import java.beans.Introspector;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.mapstruct.ap.spi.AccessorNamingStrategy;
import org.mapstruct.ap.spi.MethodType;

public class DefaultAccessorNamingStrategy
implements AccessorNamingStrategy {
    @Override
    public MethodType getMethodType(ExecutableElement method) {
        if (this.isGetterMethod(method)) {
            return MethodType.GETTER;
        }
        if (this.isSetterMethod(method)) {
            return MethodType.SETTER;
        }
        if (this.isAdderMethod(method)) {
            return MethodType.ADDER;
        }
        if (this.isPresenceCheckMethod(method)) {
            return MethodType.PRESENCE_CHECKER;
        }
        return MethodType.OTHER;
    }

    private boolean isGetterMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        boolean isNonBooleanGetterName = methodName.startsWith("get") && methodName.length() > 3 && method.getReturnType().getKind() != TypeKind.VOID;
        boolean isBooleanGetterName = methodName.startsWith("is") && methodName.length() > 2;
        boolean returnTypeIsBoolean = method.getReturnType().getKind() == TypeKind.BOOLEAN || "java.lang.Boolean".equals(DefaultAccessorNamingStrategy.getQualifiedName(method.getReturnType()));
        return isNonBooleanGetterName || isBooleanGetterName && returnTypeIsBoolean;
    }

    public boolean isSetterMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return methodName.startsWith("set") && methodName.length() > 3;
    }

    public boolean isAdderMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return methodName.startsWith("add") && methodName.length() > 3;
    }

    @Override
    public String getPropertyName(ExecutableElement getterOrSetterMethod) {
        String methodName;
        return Introspector.decapitalize(methodName.substring((methodName = getterOrSetterMethod.getSimpleName().toString()).startsWith("is") ? 2 : 3));
    }

    @Override
    public String getElementName(ExecutableElement adderMethod) {
        String methodName = adderMethod.getSimpleName().toString();
        return Introspector.decapitalize(methodName.substring(3));
    }

    @Override
    public String getCollectionGetterName(String property) {
        return "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
    }

    protected static String getQualifiedName(TypeMirror type) {
        DeclaredType declaredType = type.accept(new SimpleTypeVisitor6<DeclaredType, Void>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        }, null);
        if (declaredType == null) {
            return null;
        }
        TypeElement typeElement = declaredType.asElement().accept(new SimpleElementVisitor6<TypeElement, Void>(){

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }
        }, null);
        return typeElement != null ? typeElement.getQualifiedName().toString() : null;
    }

    private boolean isPresenceCheckMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return methodName.startsWith("has") && methodName.length() > 3 && (method.getReturnType().getKind() == TypeKind.BOOLEAN || "java.lang.Boolean".equals(DefaultAccessorNamingStrategy.getQualifiedName(method.getReturnType())));
    }
}

