/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import org.mapstruct.ap.internal.model.AssignmentFactory;
import org.mapstruct.ap.internal.model.IterableMappingMethod;
import org.mapstruct.ap.internal.model.MapMappingMethod;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.NestedPropertyMappingMethod;
import org.mapstruct.ap.internal.model.assignment.AdderWrapper;
import org.mapstruct.ap.internal.model.assignment.ArrayCopyWrapper;
import org.mapstruct.ap.internal.model.assignment.Assignment;
import org.mapstruct.ap.internal.model.assignment.AssignmentWrapper;
import org.mapstruct.ap.internal.model.assignment.EnumConstantWrapper;
import org.mapstruct.ap.internal.model.assignment.EnumSetCopyWrapper;
import org.mapstruct.ap.internal.model.assignment.GetterWrapperForCollectionsAndMaps;
import org.mapstruct.ap.internal.model.assignment.LocalVarWrapper;
import org.mapstruct.ap.internal.model.assignment.NewCollectionOrMapWrapper;
import org.mapstruct.ap.internal.model.assignment.NullCheckWrapper;
import org.mapstruct.ap.internal.model.assignment.SetterWrapper;
import org.mapstruct.ap.internal.model.assignment.SetterWrapperForCollectionsAndMaps;
import org.mapstruct.ap.internal.model.assignment.UpdateNullCheckWrapper;
import org.mapstruct.ap.internal.model.assignment.UpdateWrapper;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.ForgedMethod;
import org.mapstruct.ap.internal.model.source.FormattingParameters;
import org.mapstruct.ap.internal.model.source.PropertyEntry;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.SourceReference;
import org.mapstruct.ap.internal.prism.NullValueCheckStrategyPrism;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Executables;
import org.mapstruct.ap.internal.util.MapperConfiguration;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;

public class PropertyMapping
extends ModelElement {
    private final String name;
    private final String sourceBeanName;
    private final String targetWriteAccessorName;
    private final String targetReadAccessorName;
    private final String localTargetVarName;
    private final Type targetType;
    private final Assignment assignment;
    private final List<String> dependsOn;
    private final Assignment defaultValueAssignment;

    private PropertyMapping(String name, String targetWriteAccessorName, String targetReadAccessorName, Type targetType, String localTargetVarName, Assignment propertyAssignment, List<String> dependsOn, Assignment defaultValueAssignment) {
        this(name, null, targetWriteAccessorName, targetReadAccessorName, targetType, localTargetVarName, propertyAssignment, dependsOn, defaultValueAssignment);
    }

    private PropertyMapping(String name, String sourceBeanName, String targetWriteAccessorName, String targetReadAccessorName, Type targetType, String localTargetVarName, Assignment assignment, List<String> dependsOn, Assignment defaultValueAssignment) {
        this.name = name;
        this.sourceBeanName = sourceBeanName;
        this.targetWriteAccessorName = targetWriteAccessorName;
        this.targetReadAccessorName = targetReadAccessorName;
        this.targetType = targetType;
        this.localTargetVarName = localTargetVarName;
        this.assignment = assignment;
        this.dependsOn = dependsOn != null ? dependsOn : java.util.Collections.emptyList();
        this.defaultValueAssignment = defaultValueAssignment;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceBeanName() {
        return this.sourceBeanName;
    }

    public String getTargetWriteAccessorName() {
        return this.targetWriteAccessorName;
    }

    public String getTargetReadAccessorName() {
        return this.targetReadAccessorName;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public String getLocalTargetVarName() {
        return this.localTargetVarName;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    public Assignment getDefaultValueAssignment() {
        return this.defaultValueAssignment;
    }

    @Override
    public Set<Type> getImportTypes() {
        if (this.defaultValueAssignment == null) {
            return this.assignment.getImportTypes();
        }
        return Collections.asSet(this.assignment.getImportTypes(), new Collection[]{this.defaultValueAssignment.getImportTypes()});
    }

    public List<String> getDependsOn() {
        return this.dependsOn;
    }

    public String toString() {
        return "PropertyMapping {\n    name='" + this.name + "'," + "\n    targetWriteAccessorName='" + this.targetWriteAccessorName + "'," + "\n    targetReadAccessorName='" + this.targetReadAccessorName + "'," + "\n    targetType=" + this.targetType + "," + "\n    propertyAssignment=" + this.assignment + "," + "\n    defaultValueAssignment=" + this.defaultValueAssignment + "," + "\n    dependsOn=" + this.dependsOn + "\n}";
    }

    public static class JavaExpressionMappingBuilder
    extends MappingBuilderBase<JavaExpressionMappingBuilder> {
        private String javaExpression;

        public JavaExpressionMappingBuilder javaExpression(String javaExpression) {
            this.javaExpression = javaExpression;
            return this;
        }

        public PropertyMapping build() {
            ModelElement assignment = AssignmentFactory.createDirect(this.javaExpression);
            assignment = Executables.isSetterMethod(this.targetWriteAccessor) ? new SetterWrapper((Assignment)((Object)assignment), this.method.getThrownTypes()) : new GetterWrapperForCollectionsAndMaps((Assignment)((Object)assignment), this.method.getThrownTypes(), this.ctx.getTypeFactory().asCollectionOrMap(this.targetType), this.existingVariableNames);
            return new PropertyMapping(this.targetPropertyName, this.targetWriteAccessor.getSimpleName().toString(), this.targetReadAccessor != null ? this.targetReadAccessor.getSimpleName().toString() : null, this.targetType, this.localTargetVarName, (Assignment)((Object)assignment), this.dependsOn, null);
        }
    }

    public static class ConstantMappingBuilder
    extends MappingBuilderBase<ConstantMappingBuilder> {
        private String constantExpression;
        private FormattingParameters formattingParameters;
        private SelectionParameters selectionParameters;

        public ConstantMappingBuilder constantExpression(String constantExpression) {
            this.constantExpression = constantExpression;
            return this;
        }

        public ConstantMappingBuilder formattingParameters(FormattingParameters formattingParameters) {
            this.formattingParameters = formattingParameters;
            return this;
        }

        public ConstantMappingBuilder selectionParameters(SelectionParameters selectionParameters) {
            this.selectionParameters = selectionParameters;
            return this;
        }

        public PropertyMapping build() {
            String mappedElement = "constant '" + this.constantExpression + "'";
            Type sourceType = this.ctx.getTypeFactory().getType(String.class);
            Assignment assignment = null;
            assignment = !this.targetType.isEnumType() ? this.ctx.getMappingResolver().getTargetAssignment(this.method, mappedElement, sourceType, this.targetType, this.targetPropertyName, this.formattingParameters, this.selectionParameters, this.constantExpression, this.method.getMappingTargetParameter() != null) : this.getEnumAssignment();
            if (assignment != null) {
                if (Executables.isSetterMethod(this.targetWriteAccessor)) {
                    if (assignment.isUpdateMethod()) {
                        if (this.targetReadAccessor == null) {
                            this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.CONSTANTMAPPING_NO_READ_ACCESSOR_FOR_TARGET_TYPE, this.targetPropertyName);
                        }
                        MethodReference factoryMethod = this.ctx.getMappingResolver().getFactoryMethod(this.method, this.targetType, null);
                        assignment = new UpdateWrapper(assignment, this.method.getThrownTypes(), factoryMethod, this.targetType);
                    } else {
                        assignment = new SetterWrapper(assignment, this.method.getThrownTypes());
                    }
                } else {
                    assignment = new GetterWrapperForCollectionsAndMaps(assignment, this.method.getThrownTypes(), this.ctx.getTypeFactory().asCollectionOrMap(this.targetType), this.existingVariableNames);
                }
            } else {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.CONSTANTMAPPING_MAPPING_NOT_FOUND, sourceType, this.constantExpression, this.targetType, this.targetPropertyName);
            }
            return new PropertyMapping(this.targetPropertyName, this.targetWriteAccessor.getSimpleName().toString(), this.targetReadAccessor != null ? this.targetReadAccessor.getSimpleName().toString() : null, this.targetType, this.localTargetVarName, assignment, this.dependsOn, null);
        }

        private Assignment getEnumAssignment() {
            ModelElement assignment = null;
            String enumExpression = this.constantExpression.substring(1, this.constantExpression.length() - 1);
            if (this.targetType.getEnumConstants().contains(enumExpression)) {
                assignment = AssignmentFactory.createDirect(enumExpression);
                assignment = new EnumConstantWrapper((Assignment)((Object)assignment), this.targetType);
            } else {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.CONSTANTMAPPING_NON_EXISTING_CONSTANT, this.constantExpression, this.targetType, this.targetPropertyName);
            }
            return assignment;
        }
    }

    public static class PropertyMappingBuilder
    extends MappingBuilderBase<PropertyMappingBuilder> {
        private String defaultValue;
        private SourceReference sourceReference;
        private FormattingParameters formattingParameters;
        private SelectionParameters selectionParameters;

        public PropertyMappingBuilder sourceReference(SourceReference sourceReference) {
            this.sourceReference = sourceReference;
            return this;
        }

        public PropertyMappingBuilder selectionParameters(SelectionParameters selectionParameters) {
            this.selectionParameters = selectionParameters;
            return this;
        }

        public PropertyMappingBuilder formattingParameters(FormattingParameters formattingParameters) {
            this.formattingParameters = formattingParameters;
            return this;
        }

        public PropertyMappingBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public PropertyMapping build() {
            String sourceRefStr;
            String sourceElement = this.getSourceElement();
            Type sourceType = this.getSourceType();
            if (this.targetWriteAccessorType == TargetWriteAccessorType.ADDER && sourceType.isCollectionType()) {
                sourceType = sourceType.getTypeParameters().get(0);
                sourceRefStr = Executables.getElementNameForAdder(this.targetWriteAccessor);
            } else {
                sourceRefStr = this.getSourceRef();
            }
            boolean preferUpdateMethods = this.targetWriteAccessorType == TargetWriteAccessorType.ADDER ? false : this.method.getMappingTargetParameter() != null;
            Assignment assignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, sourceElement, sourceType, this.targetType, this.targetPropertyName, this.formattingParameters, this.selectionParameters, sourceRefStr, preferUpdateMethods);
            if (assignment == null) {
                if ((sourceType.isCollectionType() || sourceType.isArrayType()) && this.targetType.isIterableType()) {
                    assignment = this.forgeIterableMapping(sourceType, this.targetType, sourceRefStr, this.method.getExecutable());
                } else if (sourceType.isMapType() && this.targetType.isMapType()) {
                    assignment = this.forgeMapMapping(sourceType, this.targetType, sourceRefStr, this.method.getExecutable());
                }
            }
            if (assignment != null) {
                assignment = this.targetType.isCollectionOrMapType() ? this.assignToCollection(this.targetType, this.targetWriteAccessorType, assignment) : (this.targetType.isArrayType() && sourceType.isArrayType() && assignment.getType() == Assignment.AssignmentType.DIRECT ? this.assignToArray(this.targetType, assignment) : this.assignToPlain(sourceType, this.targetType, this.targetWriteAccessorType, assignment));
            } else {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_MAPPING_NOT_FOUND, sourceElement, this.targetType, this.targetPropertyName, this.targetType, this.getSourceType());
            }
            return new PropertyMapping(this.targetPropertyName, this.sourceReference.getParameter().getName(), this.targetWriteAccessor.getSimpleName().toString(), this.targetReadAccessor != null ? this.targetReadAccessor.getSimpleName().toString() : null, this.targetType, this.localTargetVarName, assignment, this.dependsOn, this.getDefaultValueAssignment());
        }

        private Assignment getDefaultValueAssignment() {
            if (!(this.defaultValue == null || this.getSourceType().isPrimitive() && this.getSourcePresenceCheckerRef() == null)) {
                PropertyMapping build = ((ConstantMappingBuilder)((ConstantMappingBuilder)((ConstantMappingBuilder)((ConstantMappingBuilder)((ConstantMappingBuilder)((ConstantMappingBuilder)((ConstantMappingBuilder)new ConstantMappingBuilder().constantExpression('\"' + this.defaultValue + '\"').formattingParameters(this.formattingParameters).selectionParameters(this.selectionParameters).dependsOn(this.dependsOn)).existingVariableNames(this.existingVariableNames)).mappingContext(this.ctx)).sourceMethod(this.method)).targetPropertyName(this.targetPropertyName)).targetReadAccessor(this.targetReadAccessor)).targetWriteAccessor(this.targetWriteAccessor)).build();
                return build.getAssignment();
            }
            return null;
        }

        private Assignment assignToPlain(Type sourceType, Type targetType, TargetWriteAccessorType targetAccessorType, Assignment rightHandSide) {
            Assignment result = targetAccessorType == TargetWriteAccessorType.SETTER ? this.assignToPlainViaSetter(sourceType, targetType, rightHandSide) : this.assignToPlainViaAdder(sourceType, rightHandSide);
            return result;
        }

        private Assignment assignToPlainViaSetter(Type sourceType, Type targetType, Assignment rightHandSide) {
            AssignmentWrapper result;
            if (rightHandSide.isUpdateMethod()) {
                if (this.targetReadAccessor == null) {
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_NO_READ_ACCESSOR_FOR_TARGET_TYPE, this.targetPropertyName);
                }
                MethodReference factoryMethod = this.ctx.getMappingResolver().getFactoryMethod(this.method, targetType, null);
                result = new UpdateWrapper(rightHandSide, this.method.getThrownTypes(), factoryMethod, targetType);
            } else {
                result = new SetterWrapper(rightHandSide, this.method.getThrownTypes());
            }
            if (this.sourceReference.getPropertyEntries().isEmpty()) {
                return result;
            }
            if (this.sourceReference.getPropertyEntries().size() > 1) {
                return result;
            }
            if (sourceType.isPrimitive()) {
                if (this.getSourcePresenceCheckerRef() != null) {
                    result = new NullCheckWrapper(result, this.getSourcePresenceCheckerRef());
                }
            } else if (result.isUpdateMethod()) {
                result = new UpdateNullCheckWrapper(result, this.getSourcePresenceCheckerRef());
            } else if (this.getSourcePresenceCheckerRef() != null) {
                result = new NullCheckWrapper(result, this.getSourcePresenceCheckerRef());
            } else if (NullValueCheckStrategyPrism.ALWAYS.equals((Object)this.method.getMapperConfiguration().getNullValueCheckStrategy())) {
                result = new NullCheckWrapper(result, this.getSourcePresenceCheckerRef());
            } else if (result.getType() == Assignment.AssignmentType.TYPE_CONVERTED || result.getType() == Assignment.AssignmentType.TYPE_CONVERTED_MAPPED || result.getType() == Assignment.AssignmentType.MAPPED_TYPE_CONVERTED || result.getType() == Assignment.AssignmentType.DIRECT && targetType.isPrimitive()) {
                result = new NullCheckWrapper(result, this.getSourcePresenceCheckerRef());
            }
            return result;
        }

        private Assignment assignToPlainViaAdder(Type sourceType, Assignment rightHandSide) {
            Assignment result = rightHandSide;
            if (this.getSourceType().isCollectionType()) {
                result = new AdderWrapper(result, this.method.getThrownTypes(), this.getSourceRef(), sourceType);
                result = new NullCheckWrapper(result, this.getSourcePresenceCheckerRef());
            } else {
                result = new SetterWrapper(result, this.method.getThrownTypes());
                result = new NullCheckWrapper(result, this.getSourcePresenceCheckerRef());
            }
            return result;
        }

        private Assignment assignToCollection(Type targetType, TargetWriteAccessorType targetAccessorType, Assignment rhs) {
            Assignment result = rhs;
            if (targetAccessorType == TargetWriteAccessorType.SETTER) {
                AssignmentWrapper newCollectionOrMap = null;
                if (result.getType() == Assignment.AssignmentType.DIRECT) {
                    Set<Type> implementationTypes = targetType.getImplementationType() != null ? targetType.getImplementationType().getImportTypes() : targetType.getImportTypes();
                    newCollectionOrMap = "java.util.EnumSet".equals(targetType.getFullyQualifiedName()) ? new EnumSetCopyWrapper(this.ctx.getTypeFactory(), result) : new NewCollectionOrMapWrapper(result, implementationTypes);
                    newCollectionOrMap = new SetterWrapper(newCollectionOrMap, this.method.getThrownTypes());
                }
                if (result.isUpdateMethod()) {
                    if (this.targetReadAccessor == null) {
                        this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_NO_READ_ACCESSOR_FOR_TARGET_TYPE, this.targetPropertyName);
                    }
                    MethodReference factoryMethod = this.ctx.getMappingResolver().getFactoryMethod(this.method, targetType, null);
                    result = new UpdateWrapper(result, this.method.getThrownTypes(), factoryMethod, targetType);
                } else {
                    result = this.method.isUpdateMethod() ? new LocalVarWrapper(result, this.method.getThrownTypes(), targetType) : new SetterWrapper(result, this.method.getThrownTypes());
                    result = new SetterWrapperForCollectionsAndMaps(result, this.targetReadAccessor.getSimpleName().toString(), newCollectionOrMap, targetType, this.existingVariableNames);
                }
            } else {
                result = new GetterWrapperForCollectionsAndMaps(result, this.method.getThrownTypes(), this.ctx.getTypeFactory().asCollectionOrMap(targetType), this.existingVariableNames);
            }
            if (result.getType() == Assignment.AssignmentType.DIRECT) {
                result = new NullCheckWrapper(result, this.getSourcePresenceCheckerRef());
            } else if (result.getType() == Assignment.AssignmentType.MAPPED && result.isUpdateMethod()) {
                result = new UpdateNullCheckWrapper(result, this.getSourcePresenceCheckerRef());
            }
            return result;
        }

        private Assignment assignToArray(Type targetType, Assignment rightHandSide) {
            Type arrayType = this.ctx.getTypeFactory().getType(Arrays.class);
            ArrayCopyWrapper assignment = new ArrayCopyWrapper(rightHandSide, this.targetPropertyName, arrayType, targetType, this.existingVariableNames);
            return new NullCheckWrapper(assignment, this.getSourcePresenceCheckerRef());
        }

        private Type getSourceType() {
            Parameter sourceParam = this.sourceReference.getParameter();
            List<PropertyEntry> propertyEntries = this.sourceReference.getPropertyEntries();
            if (propertyEntries.isEmpty()) {
                return sourceParam.getType();
            }
            PropertyEntry lastPropertyEntry = Collections.last(propertyEntries);
            return lastPropertyEntry.getType();
        }

        private String getSourceRef() {
            Parameter sourceParam = this.sourceReference.getParameter();
            List<PropertyEntry> propertyEntries = this.sourceReference.getPropertyEntries();
            if (propertyEntries.isEmpty()) {
                return sourceParam.getName();
            }
            if (propertyEntries.size() == 1) {
                PropertyEntry propertyEntry = propertyEntries.get(0);
                return sourceParam.getName() + "." + propertyEntry.getReadAccessor().getSimpleName() + "()";
            }
            PropertyEntry lastPropertyEntry = Collections.last(propertyEntries);
            MapperConfiguration config = this.method.getMapperConfiguration();
            String forgedName = Strings.joinAndCamelize(this.sourceReference.getElementNames());
            forgedName = Strings.getSaveVariableName(forgedName, this.ctx.getNamesOfMappingsToGenerate());
            ForgedMethod methodRef = new ForgedMethod(forgedName, this.sourceReference.getParameter().getType(), lastPropertyEntry.getType(), config, this.method.getExecutable());
            NestedPropertyMappingMethod.Builder builder = new NestedPropertyMappingMethod.Builder();
            NestedPropertyMappingMethod nestedPropertyMapping = builder.method(methodRef).propertyEntries(this.sourceReference.getPropertyEntries()).build();
            if (!this.ctx.getMappingsToGenerate().contains(nestedPropertyMapping)) {
                this.ctx.getMappingsToGenerate().add(nestedPropertyMapping);
            } else {
                forgedName = this.ctx.getExistingMappingMethod(nestedPropertyMapping).getName();
            }
            return forgedName + "( " + sourceParam.getName() + " )";
        }

        private String getSourceElement() {
            Parameter sourceParam = this.sourceReference.getParameter();
            List<PropertyEntry> propertyEntries = this.sourceReference.getPropertyEntries();
            if (propertyEntries.isEmpty()) {
                return String.format("parameter \"%s %s\"", sourceParam.getType(), sourceParam.getName());
            }
            if (propertyEntries.size() == 1) {
                PropertyEntry propertyEntry = propertyEntries.get(0);
                return String.format("property \"%s %s\"", propertyEntry.getType(), propertyEntry.getName());
            }
            PropertyEntry lastPropertyEntry = propertyEntries.get(propertyEntries.size() - 1);
            return String.format("property \"%s %s\"", lastPropertyEntry.getType(), Strings.join(this.sourceReference.getElementNames(), "."));
        }

        private String getSourcePresenceCheckerRef() {
            String sourcePresenceChecker = null;
            if (!this.sourceReference.getPropertyEntries().isEmpty()) {
                Parameter sourceParam = this.sourceReference.getParameter();
                PropertyEntry propertyEntry = Collections.first(this.sourceReference.getPropertyEntries());
                if (propertyEntry.getPresenceChecker() != null) {
                    sourcePresenceChecker = sourceParam.getName() + "." + propertyEntry.getPresenceChecker().getSimpleName() + "()";
                }
            }
            return sourcePresenceChecker;
        }

        private Assignment forgeIterableMapping(Type sourceType, Type targetType, String sourceReference, ExecutableElement element) {
            Assignment assignment = null;
            String name = this.getName(sourceType, targetType);
            name = Strings.getSaveVariableName(name, this.ctx.getNamesOfMappingsToGenerate());
            MapperConfiguration config = this.method.getMapperConfiguration();
            ForgedMethod methodRef = new ForgedMethod(name, sourceType, targetType, config, element);
            IterableMappingMethod.Builder builder = new IterableMappingMethod.Builder();
            IterableMappingMethod iterableMappingMethod = builder.mappingContext(this.ctx).method(methodRef).selectionParameters(this.selectionParameters).build();
            if (iterableMappingMethod != null) {
                if (!this.ctx.getMappingsToGenerate().contains(iterableMappingMethod)) {
                    this.ctx.getMappingsToGenerate().add(iterableMappingMethod);
                } else {
                    String existingName = this.ctx.getExistingMappingMethod(iterableMappingMethod).getName();
                    methodRef = new ForgedMethod(existingName, methodRef);
                }
                assignment = AssignmentFactory.createMethodReference(methodRef, null, targetType);
                assignment.setAssignment(AssignmentFactory.createDirect(sourceReference));
            }
            return assignment;
        }

        private Assignment forgeMapMapping(Type sourceType, Type targetType, String sourceReference, ExecutableElement element) {
            Assignment assignment = null;
            String name = this.getName(sourceType, targetType);
            name = Strings.getSaveVariableName(name, this.ctx.getNamesOfMappingsToGenerate());
            MapperConfiguration config = this.method.getMapperConfiguration();
            ForgedMethod methodRef = new ForgedMethod(name, sourceType, targetType, config, element);
            MapMappingMethod.Builder builder = new MapMappingMethod.Builder();
            MapMappingMethod mapMappingMethod = builder.mappingContext(this.ctx).method(methodRef).build();
            if (mapMappingMethod != null) {
                if (!this.ctx.getMappingsToGenerate().contains(mapMappingMethod)) {
                    this.ctx.getMappingsToGenerate().add(mapMappingMethod);
                } else {
                    String existingName = this.ctx.getExistingMappingMethod(mapMappingMethod).getName();
                    methodRef = new ForgedMethod(existingName, methodRef);
                }
                assignment = AssignmentFactory.createMethodReference(methodRef, null, targetType);
                assignment.setAssignment(AssignmentFactory.createDirect(sourceReference));
            }
            return assignment;
        }

        private String getName(Type sourceType, Type targetType) {
            String fromName = this.getName(sourceType);
            String toName = this.getName(targetType);
            return Strings.decapitalize(fromName + "To" + toName);
        }

        private String getName(Type type) {
            StringBuilder builder = new StringBuilder();
            for (Type typeParam : type.getTypeParameters()) {
                builder.append(typeParam.getIdentification());
            }
            builder.append(type.getIdentification());
            return builder.toString();
        }
    }

    private static class MappingBuilderBase<T extends MappingBuilderBase<T>> {
        protected MappingBuilderContext ctx;
        protected SourceMethod method;
        protected ExecutableElement targetWriteAccessor;
        protected TargetWriteAccessorType targetWriteAccessorType;
        protected Type targetType;
        protected ExecutableElement targetReadAccessor;
        protected String targetPropertyName;
        protected String localTargetVarName;
        protected List<String> dependsOn;
        protected Set<String> existingVariableNames;

        private MappingBuilderBase() {
        }

        public T mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return (T)this;
        }

        public T sourceMethod(SourceMethod sourceMethod) {
            this.method = sourceMethod;
            return (T)this;
        }

        public T targetProperty(PropertyEntry targetProp) {
            this.targetReadAccessor = targetProp.getReadAccessor();
            this.targetWriteAccessor = targetProp.getWriteAccessor();
            this.targetType = targetProp.getType();
            this.targetWriteAccessorType = TargetWriteAccessorType.of(this.targetWriteAccessor);
            return (T)this;
        }

        public T targetReadAccessor(ExecutableElement targetReadAccessor) {
            this.targetReadAccessor = targetReadAccessor;
            return (T)this;
        }

        public T targetWriteAccessor(ExecutableElement targetWriteAccessor) {
            this.targetWriteAccessor = targetWriteAccessor;
            this.targetWriteAccessorType = TargetWriteAccessorType.of(targetWriteAccessor);
            this.targetType = this.determineTargetType();
            return (T)this;
        }

        public T localTargetVarName(String localTargetVarName) {
            this.localTargetVarName = localTargetVarName;
            return (T)this;
        }

        private Type determineTargetType() {
            DeclaredType resultType = (DeclaredType)this.method.getResultType().getTypeMirror();
            switch (this.targetWriteAccessorType) {
                case ADDER: 
                case SETTER: {
                    return this.ctx.getTypeFactory().getSingleParameter(resultType, this.targetWriteAccessor).getType();
                }
            }
            return this.ctx.getTypeFactory().getReturnType(resultType, this.targetWriteAccessor);
        }

        public T targetPropertyName(String targetPropertyName) {
            this.targetPropertyName = targetPropertyName;
            return (T)this;
        }

        public T dependsOn(List<String> dependsOn) {
            this.dependsOn = dependsOn;
            return (T)this;
        }

        public T existingVariableNames(Set<String> existingVariableNames) {
            this.existingVariableNames = existingVariableNames;
            return (T)this;
        }
    }

    private static enum TargetWriteAccessorType {
        GETTER,
        SETTER,
        ADDER;


        public static TargetWriteAccessorType of(ExecutableElement accessor) {
            if (Executables.isSetterMethod(accessor)) {
                return SETTER;
            }
            if (Executables.isAdderMethod(accessor)) {
                return ADDER;
            }
            return GETTER;
        }
    }
}

