/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Manifest;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import org.mapstruct.ap.internal.version.VersionInformation;

public class DefaultVersionInformation
implements VersionInformation {
    private static final String JAVAC_PE_CLASS = "com.sun.tools.javac.processing.JavacProcessingEnvironment";
    private static final String COMPILER_NAME_JAVAC = "javac";
    private static final String JDT_IDE_PE_CLASS = "org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeBuildProcessingEnvImpl";
    private static final String JDT_BATCH_PE_CLASS = "org.eclipse.jdt.internal.compiler.apt.dispatch.BatchProcessingEnvImpl";
    private static final String COMPILER_NAME_ECLIPSE_JDT = "Eclipse JDT";
    private static final String MAP_STRUCT_VERSION = DefaultVersionInformation.initMapStructVersion();
    private final String runtimeVersion;
    private final String runtimeVendor;
    private final String compiler;
    private final boolean sourceVersionAtLeast9;
    private final boolean eclipseJDT;
    private final boolean javac;

    DefaultVersionInformation(String runtimeVersion, String runtimeVendor, String compiler, SourceVersion sourceVersion) {
        this.runtimeVersion = runtimeVersion;
        this.runtimeVendor = runtimeVendor;
        this.compiler = compiler;
        this.eclipseJDT = compiler.startsWith(COMPILER_NAME_ECLIPSE_JDT);
        this.javac = compiler.startsWith(COMPILER_NAME_JAVAC);
        this.sourceVersionAtLeast9 = sourceVersion.compareTo(SourceVersion.RELEASE_6) > 2;
    }

    @Override
    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    @Override
    public String getRuntimeVendor() {
        return this.runtimeVendor;
    }

    @Override
    public String getMapStructVersion() {
        return MAP_STRUCT_VERSION;
    }

    @Override
    public String getCompiler() {
        return this.compiler;
    }

    @Override
    public boolean isSourceVersionAtLeast9() {
        return this.sourceVersionAtLeast9;
    }

    @Override
    public boolean isEclipseJDTCompiler() {
        return this.eclipseJDT;
    }

    @Override
    public boolean isJavacCompiler() {
        return this.javac;
    }

    static DefaultVersionInformation fromProcessingEnvironment(ProcessingEnvironment processingEnv) {
        String runtimeVersion = System.getProperty("java.version");
        String runtimeVendor = System.getProperty("java.vendor");
        String compiler = DefaultVersionInformation.getCompiler(processingEnv);
        return new DefaultVersionInformation(runtimeVersion, runtimeVendor, compiler, processingEnv.getSourceVersion());
    }

    private static String getCompiler(ProcessingEnvironment processingEnv) {
        String className = processingEnv.getClass().getName();
        if (className.equals(JAVAC_PE_CLASS)) {
            return COMPILER_NAME_JAVAC;
        }
        if (className.equals(JDT_IDE_PE_CLASS)) {
            return "Eclipse JDT (IDE) " + DefaultVersionInformation.getLibraryName(processingEnv.getTypeUtils().getClass(), true);
        }
        if (className.equals(JDT_BATCH_PE_CLASS)) {
            return "Eclipse JDT (Batch) " + DefaultVersionInformation.getLibraryName(processingEnv.getClass(), true);
        }
        return processingEnv.getClass().getSimpleName() + " from " + DefaultVersionInformation.getLibraryName(processingEnv.getClass(), false);
    }

    private static String getLibraryName(Class<?> clazz, boolean preferVersionOnly) {
        String version;
        String classFileName = DefaultVersionInformation.asClassFileName(clazz.getName());
        URL resource = clazz.getClassLoader().getResource(classFileName);
        Manifest manifest = DefaultVersionInformation.openManifest(classFileName, resource);
        if (preferVersionOnly && manifest != null && (version = manifest.getMainAttributes().getValue("Bundle-Version")) != null) {
            return version;
        }
        if ("jar".equals(resource.getProtocol())) {
            return DefaultVersionInformation.extractJarFileName(resource.getFile());
        }
        if ("jrt".equals(resource.getProtocol())) {
            return DefaultVersionInformation.extractJrtModuleName(resource);
        }
        if ("bundleresource".equals(resource.getProtocol()) && manifest != null) {
            return DefaultVersionInformation.extractBundleName(manifest);
        }
        return resource.toExternalForm();
    }

    private static Manifest openManifest(String classFileName, URL resource) {
        try {
            URL manifestUrl = DefaultVersionInformation.createManifestUrl(classFileName, resource);
            return new Manifest(manifestUrl.openStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String extractBundleName(Manifest manifest) {
        String version = manifest.getMainAttributes().getValue("Bundle-Version");
        String symbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        int semicolon = symbolicName.indexOf(59);
        if (semicolon > 0) {
            symbolicName = symbolicName.substring(0, semicolon);
        }
        return symbolicName + "_" + version;
    }

    private static String extractJrtModuleName(URL resource) {
        int moduleNameSeparator = resource.getFile().indexOf(47, 1);
        if (moduleNameSeparator > 1) {
            return resource.getFile().substring(1, moduleNameSeparator);
        }
        return resource.toExternalForm();
    }

    private static URL createManifestUrl(String classFileName, URL resource) throws MalformedURLException {
        String classUrlString = resource.toExternalForm();
        String baseFileUrl = classUrlString.substring(0, classUrlString.length() - classFileName.length());
        return new URL(baseFileUrl + "META-INF/MANIFEST.MF");
    }

    private static String asClassFileName(String className) {
        return className.replace('.', '/') + ".class";
    }

    private static String extractJarFileName(String file) {
        String fullFileName;
        int lastPathSep;
        int excl = file.indexOf(33);
        if (excl > 0 && (lastPathSep = (fullFileName = file.substring(0, excl)).lastIndexOf(47)) > 0 && lastPathSep < fullFileName.length()) {
            return fullFileName.substring(lastPathSep + 1);
        }
        return file;
    }

    private static String initMapStructVersion() {
        String version;
        URL resource;
        String classFileName = DefaultVersionInformation.asClassFileName(DefaultVersionInformation.class.getName());
        Manifest manifest = DefaultVersionInformation.openManifest(classFileName, resource = DefaultVersionInformation.class.getClassLoader().getResource(classFileName));
        if (null != manifest && (version = manifest.getMainAttributes().getValue("Implementation-Version")) != null) {
            return version;
        }
        return "";
    }
}

