/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.mapstruct.ap.internal.gem.CollectionMappingStrategyGem;
import org.mapstruct.ap.internal.gem.ReportingPolicyGem;
import org.mapstruct.ap.internal.model.BuilderFinisherMethodResolver;
import org.mapstruct.ap.internal.model.ForgedMethod;
import org.mapstruct.ap.internal.model.ForgedMethodHistory;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.LifecycleMethodResolver;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.NestedTargetPropertyMappingHolder;
import org.mapstruct.ap.internal.model.NormalTypeMappingMethod;
import org.mapstruct.ap.internal.model.ObjectFactoryMethodResolver;
import org.mapstruct.ap.internal.model.PropertyMapping;
import org.mapstruct.ap.internal.model.beanmapping.AbstractReference;
import org.mapstruct.ap.internal.model.beanmapping.MappingReference;
import org.mapstruct.ap.internal.model.beanmapping.MappingReferences;
import org.mapstruct.ap.internal.model.beanmapping.SourceReference;
import org.mapstruct.ap.internal.model.beanmapping.TargetReference;
import org.mapstruct.ap.internal.model.common.BuilderType;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.ParameterBinding;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.dependency.GraphAnalyzer;
import org.mapstruct.ap.internal.model.source.BeanMappingOptions;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.accessor.AccessorType;
import org.mapstruct.ap.internal.util.accessor.ParameterElementAccessor;

public class BeanMappingMethod
extends NormalTypeMappingMethod {
    private final List<PropertyMapping> propertyMappings;
    private final Map<String, List<PropertyMapping>> mappingsByParameter;
    private final Map<String, List<PropertyMapping>> constructorMappingsByParameter;
    private final List<PropertyMapping> constantMappings;
    private final List<PropertyMapping> constructorConstantMappings;
    private final Type returnTypeToConstruct;
    private final BuilderType returnTypeBuilder;
    private final MethodReference finalizerMethod;

    private BeanMappingMethod(Method method, Collection<String> existingVariableNames, List<PropertyMapping> propertyMappings, MethodReference factoryMethod, boolean mapNullToDefault, Type returnTypeToConstruct, BuilderType returnTypeBuilder, List<LifecycleCallbackMethodReference> beforeMappingReferences, List<LifecycleCallbackMethodReference> afterMappingReferences, MethodReference finalizerMethod) {
        super(method, existingVariableNames, factoryMethod, mapNullToDefault, beforeMappingReferences, afterMappingReferences);
        this.propertyMappings = propertyMappings;
        this.returnTypeBuilder = returnTypeBuilder;
        this.finalizerMethod = finalizerMethod;
        this.mappingsByParameter = new HashMap<String, List<PropertyMapping>>();
        this.constantMappings = new ArrayList<PropertyMapping>(propertyMappings.size());
        this.constructorMappingsByParameter = new LinkedHashMap<String, List<PropertyMapping>>();
        this.constructorConstantMappings = new ArrayList<PropertyMapping>();
        Set sourceParameterNames = this.getSourceParameters().stream().map(Parameter::getName).collect(Collectors.toSet());
        for (PropertyMapping mapping : propertyMappings) {
            if (mapping.isConstructorMapping()) {
                if (sourceParameterNames.contains(mapping.getSourceBeanName())) {
                    this.constructorMappingsByParameter.computeIfAbsent(mapping.getSourceBeanName(), key -> new ArrayList()).add(mapping);
                    continue;
                }
                this.constructorConstantMappings.add(mapping);
                continue;
            }
            if (sourceParameterNames.contains(mapping.getSourceBeanName())) {
                this.mappingsByParameter.computeIfAbsent(mapping.getSourceBeanName(), key -> new ArrayList()).add(mapping);
                continue;
            }
            this.constantMappings.add(mapping);
        }
        this.returnTypeToConstruct = returnTypeToConstruct;
    }

    public List<PropertyMapping> getConstantMappings() {
        return this.constantMappings;
    }

    public List<PropertyMapping> getConstructorConstantMappings() {
        return this.constructorConstantMappings;
    }

    public List<PropertyMapping> propertyMappingsByParameter(Parameter parameter) {
        return this.mappingsByParameter.getOrDefault(parameter.getName(), java.util.Collections.emptyList());
    }

    public List<PropertyMapping> constructorPropertyMappingsByParameter(Parameter parameter) {
        return this.constructorMappingsByParameter.getOrDefault(parameter.getName(), java.util.Collections.emptyList());
    }

    public Type getReturnTypeToConstruct() {
        return this.returnTypeToConstruct;
    }

    public boolean hasConstructorMappings() {
        return !this.constructorMappingsByParameter.isEmpty() || !this.constructorConstantMappings.isEmpty();
    }

    public MethodReference getFinalizerMethod() {
        return this.finalizerMethod;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        for (PropertyMapping propertyMapping : this.propertyMappings) {
            types.addAll(propertyMapping.getImportTypes());
        }
        if (this.returnTypeToConstruct != null) {
            types.addAll(this.returnTypeToConstruct.getImportTypes());
        }
        if (this.returnTypeBuilder != null) {
            types.add(this.returnTypeBuilder.getOwningType());
        }
        return types;
    }

    public List<Parameter> getSourceParametersExcludingPrimitives() {
        return this.getSourceParameters().stream().filter(parameter -> !parameter.getType().isPrimitive()).collect(Collectors.toList());
    }

    public List<Parameter> getSourcePrimitiveParameters() {
        return this.getSourceParameters().stream().filter(parameter -> parameter.getType().isPrimitive()).collect(Collectors.toList());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BeanMappingMethod that = (BeanMappingMethod)obj;
        if (!super.equals(obj)) {
            return false;
        }
        return Objects.equals(this.propertyMappings, that.propertyMappings);
    }

    private static class ConstructorAccessor {
        private final List<ParameterBinding> parameterBindings;
        private final Map<String, Accessor> constructorAccessors;

        private ConstructorAccessor(List<ParameterBinding> parameterBindings, Map<String, Accessor> constructorAccessors) {
            this.parameterBindings = parameterBindings;
            this.constructorAccessors = constructorAccessors;
        }
    }

    public static class Builder {
        private MappingBuilderContext ctx;
        private Method method;
        private BuilderType returnTypeBuilder;
        private Map<String, Accessor> unprocessedConstructorProperties;
        private Map<String, Accessor> unprocessedTargetProperties;
        private Map<String, Accessor> unprocessedSourceProperties;
        private Set<String> targetProperties;
        private final List<PropertyMapping> propertyMappings = new ArrayList<PropertyMapping>();
        private final Set<Parameter> unprocessedSourceParameters = new HashSet<Parameter>();
        private final Set<String> existingVariableNames = new HashSet<String>();
        private final Map<String, Set<MappingReference>> unprocessedDefinedTargets = new LinkedHashMap<String, Set<MappingReference>>();
        private MappingReferences mappingReferences;
        private MethodReference factoryMethod;
        private boolean hasFactoryMethod;

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public Builder returnTypeBuilder(BuilderType returnTypeBuilder) {
            this.returnTypeBuilder = returnTypeBuilder;
            return this;
        }

        public Builder sourceMethod(SourceMethod sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public Builder forgedMethod(ForgedMethod forgedMethod) {
            this.method = forgedMethod;
            this.mappingReferences = forgedMethod.getMappingReferences();
            Parameter sourceParameter = Collections.first(Parameter.getSourceParameters(forgedMethod.getParameters()));
            for (MappingReference mappingReference : this.mappingReferences.getMappingReferences()) {
                SourceReference sourceReference = mappingReference.getSourceReference();
                if (sourceReference == null) continue;
                mappingReference.setSourceReference(new SourceReference.BuilderFromSourceReference().sourceParameter(sourceParameter).sourceReference(sourceReference).build());
            }
            return this;
        }

        public BeanMappingMethod build() {
            BeanMappingOptions beanMapping = this.method.getOptions().getBeanMapping();
            SelectionParameters selectionParameters = beanMapping != null ? beanMapping.getSelectionParameters() : null;
            Type returnTypeToConstruct = null;
            boolean cannotConstructReturnType = false;
            if (!this.method.getReturnType().isVoid()) {
                Type returnTypeImpl = this.getReturnTypeToConstructFromSelectionParameters(selectionParameters);
                if (returnTypeImpl != null) {
                    this.initializeFactoryMethod(returnTypeImpl, selectionParameters);
                    if (this.factoryMethod != null || this.canResultTypeFromBeanMappingBeConstructed(returnTypeImpl)) {
                        returnTypeToConstruct = returnTypeImpl;
                    } else {
                        cannotConstructReturnType = true;
                    }
                } else if (this.isBuilderRequired()) {
                    returnTypeImpl = this.returnTypeBuilder.getBuilder();
                    this.initializeFactoryMethod(returnTypeImpl, selectionParameters);
                    if (this.factoryMethod != null || this.canReturnTypeBeConstructed(returnTypeImpl)) {
                        returnTypeToConstruct = returnTypeImpl;
                    } else {
                        cannotConstructReturnType = true;
                    }
                } else if (!this.method.isUpdateMethod()) {
                    returnTypeImpl = this.method.getReturnType();
                    this.initializeFactoryMethod(returnTypeImpl, selectionParameters);
                    if (this.factoryMethod != null || this.canReturnTypeBeConstructed(returnTypeImpl)) {
                        returnTypeToConstruct = returnTypeImpl;
                    } else {
                        cannotConstructReturnType = true;
                    }
                }
            }
            if (cannotConstructReturnType) {
                return null;
            }
            Type resultTypeToMap = returnTypeToConstruct == null ? this.method.getResultType() : returnTypeToConstruct;
            this.existingVariableNames.addAll(this.method.getParameterNames());
            CollectionMappingStrategyGem cms = this.method.getOptions().getMapper().getCollectionMappingStrategy();
            Map<String, Accessor> accessors = resultTypeToMap.getPropertyWriteAccessors(cms);
            this.targetProperties = new LinkedHashSet<String>(accessors.keySet());
            this.unprocessedTargetProperties = new LinkedHashMap<String, Accessor>(accessors);
            if (!this.method.isUpdateMethod() && !this.hasFactoryMethod) {
                ConstructorAccessor constructorAccessor = this.getConstructorAccessor(resultTypeToMap);
                if (constructorAccessor != null) {
                    this.unprocessedConstructorProperties = constructorAccessor.constructorAccessors;
                    this.factoryMethod = MethodReference.forConstructorInvocation(resultTypeToMap, constructorAccessor.parameterBindings);
                } else {
                    this.unprocessedConstructorProperties = new LinkedHashMap<String, Accessor>();
                }
                this.targetProperties.addAll(this.unprocessedConstructorProperties.keySet());
                this.unprocessedTargetProperties.putAll(this.unprocessedConstructorProperties);
            } else {
                this.unprocessedConstructorProperties = new LinkedHashMap<String, Accessor>();
            }
            this.unprocessedSourceProperties = new LinkedHashMap<String, Accessor>();
            for (Parameter sourceParameter : this.method.getSourceParameters()) {
                this.unprocessedSourceParameters.add(sourceParameter);
                if (sourceParameter.getType().isPrimitive() || sourceParameter.getType().isArrayType()) continue;
                Map<String, Accessor> readAccessors = sourceParameter.getType().getPropertyReadAccessors();
                for (Map.Entry<String, Accessor> entry : readAccessors.entrySet()) {
                    this.unprocessedSourceProperties.put(entry.getKey(), entry.getValue());
                }
            }
            if (beanMapping != null) {
                for (String ignoreUnmapped : beanMapping.getIgnoreUnmappedSourceProperties()) {
                    this.unprocessedSourceProperties.remove(ignoreUnmapped);
                }
            }
            this.initializeMappingReferencesIfNeeded(resultTypeToMap);
            boolean mappingErrorOccurred = this.handleDefinedMappings(resultTypeToMap);
            if (mappingErrorOccurred) {
                return null;
            }
            if (!this.mappingReferences.isRestrictToDefinedMappings()) {
                this.applyTargetThisMapping();
                this.applyPropertyNameBasedMapping();
                this.applyParameterNameBasedMapping();
            }
            this.handleUnprocessedDefinedTargets();
            this.handleUnmappedConstructorProperties();
            this.reportErrorForUnmappedTargetPropertiesIfRequired();
            this.reportErrorForUnmappedSourcePropertiesIfRequired();
            boolean mapNullToDefault = this.method.getOptions().getBeanMapping().getNullValueMappingStrategy().isReturnDefault();
            this.sortPropertyMappingsByDependencies();
            List<LifecycleCallbackMethodReference> beforeMappingMethods = LifecycleMethodResolver.beforeMappingMethods(this.method, resultTypeToMap, selectionParameters, this.ctx, this.existingVariableNames);
            List<LifecycleCallbackMethodReference> afterMappingMethods = LifecycleMethodResolver.afterMappingMethods(this.method, resultTypeToMap, selectionParameters, this.ctx, this.existingVariableNames);
            if (this.factoryMethod != null && this.method instanceof ForgedMethod) {
                ((ForgedMethod)this.method).addThrownTypes(this.factoryMethod.getThrownTypes());
            }
            MethodReference finalizeMethod = null;
            if (this.shouldCallFinalizerMethod(returnTypeToConstruct)) {
                finalizeMethod = this.getFinalizerMethod();
            }
            return new BeanMappingMethod(this.method, this.existingVariableNames, this.propertyMappings, this.factoryMethod, mapNullToDefault, returnTypeToConstruct, this.returnTypeBuilder, beforeMappingMethods, afterMappingMethods, finalizeMethod);
        }

        private void initializeMappingReferencesIfNeeded(Type resultTypeToMap) {
            if (this.mappingReferences == null && this.method instanceof SourceMethod) {
                HashSet<String> readAndWriteTargetProperties = new HashSet<String>(this.unprocessedTargetProperties.keySet());
                readAndWriteTargetProperties.addAll(resultTypeToMap.getPropertyReadAccessors().keySet());
                this.mappingReferences = MappingReferences.forSourceMethod((SourceMethod)this.method, resultTypeToMap, readAndWriteTargetProperties, this.ctx.getMessager(), this.ctx.getTypeFactory());
            }
        }

        private boolean isBuilderRequired() {
            return this.returnTypeBuilder != null && (!this.method.isUpdateMethod() || !this.method.isMappingTargetAssignableToReturnType());
        }

        private boolean shouldCallFinalizerMethod(Type returnTypeToConstruct) {
            if (returnTypeToConstruct == null) {
                return false;
            }
            if (returnTypeToConstruct.isAssignableTo(this.method.getReturnType())) {
                return false;
            }
            return this.returnTypeBuilder != null;
        }

        private MethodReference getFinalizerMethod() {
            return BuilderFinisherMethodResolver.getBuilderFinisherMethod(this.method, this.returnTypeBuilder, this.ctx);
        }

        private void handleUnprocessedDefinedTargets() {
            Iterator<Map.Entry<String, Set<MappingReference>>> iterator = this.unprocessedDefinedTargets.entrySet().iterator();
            block0: while (iterator.hasNext()) {
                Map.Entry<String, Set<MappingReference>> entry = iterator.next();
                String propertyName = entry.getKey();
                if (!this.unprocessedTargetProperties.containsKey(propertyName)) continue;
                List<Parameter> sourceParameters = this.method.getSourceParameters();
                boolean forceUpdateMethod = sourceParameters.size() > 1;
                for (Parameter sourceParameter : sourceParameters) {
                    SourceReference reference = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(propertyName).build();
                    Accessor targetPropertyReadAccessor = this.method.getResultType().getPropertyReadAccessors().get(propertyName);
                    MappingReferences mappingRefs = this.extractMappingReferences(propertyName, true);
                    PropertyMapping propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).target(propertyName, targetPropertyReadAccessor, this.unprocessedTargetProperties.get(propertyName))).sourceReference(reference).existingVariableNames(this.existingVariableNames)).dependsOn(mappingRefs.collectNestedDependsOn())).forgeMethodWithMappingReferences(mappingRefs).forceUpdateMethod(forceUpdateMethod).forgedNamedBased(false).build();
                    if (propertyMapping == null) continue;
                    this.unprocessedTargetProperties.remove(propertyName);
                    this.unprocessedConstructorProperties.remove(propertyName);
                    this.unprocessedSourceProperties.remove(propertyName);
                    iterator.remove();
                    this.propertyMappings.add(propertyMapping);
                    continue block0;
                }
            }
        }

        private void handleUnmappedConstructorProperties() {
            for (Map.Entry<String, Accessor> entry : this.unprocessedConstructorProperties.entrySet()) {
                Accessor accessor = entry.getValue();
                Type accessedType = this.ctx.getTypeFactory().getType(accessor.getAccessedType());
                String targetPropertyName = entry.getKey();
                this.propertyMappings.add(((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)new PropertyMapping.JavaExpressionMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).javaExpression(accessedType.getNull()).existingVariableNames(this.existingVariableNames)).target(targetPropertyName, null, accessor)).dependsOn(java.util.Collections.emptySet())).mirror(null)).build());
            }
            this.unprocessedConstructorProperties.clear();
        }

        private void sortPropertyMappingsByDependencies() {
            GraphAnalyzer.GraphAnalyzerBuilder graphAnalyzerBuilder = GraphAnalyzer.builder();
            for (PropertyMapping propertyMapping2 : this.propertyMappings) {
                graphAnalyzerBuilder.withNode(propertyMapping2.getName(), propertyMapping2.getDependsOn());
            }
            GraphAnalyzer graphAnalyzer = graphAnalyzerBuilder.build();
            if (!graphAnalyzer.getCycles().isEmpty()) {
                HashSet<String> cycles = new HashSet<String>();
                for (List<String> cycle : graphAnalyzer.getCycles()) {
                    cycles.add(Strings.join(cycle, " -> "));
                }
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.BEANMAPPING_CYCLE_BETWEEN_PROPERTIES, Strings.join(cycles, ", "));
            } else {
                this.propertyMappings.sort(Comparator.comparingInt(propertyMapping -> graphAnalyzer.getTraversalSequence(propertyMapping.getName())));
            }
        }

        private Type getReturnTypeToConstructFromSelectionParameters(SelectionParameters selectionParams) {
            if (!(this.method instanceof ForgedMethod) && selectionParams != null && selectionParams.getResultType() != null) {
                return this.ctx.getTypeFactory().getType(selectionParams.getResultType());
            }
            return null;
        }

        private boolean canResultTypeFromBeanMappingBeConstructed(Type resultType) {
            boolean error = true;
            if (resultType.isAbstract()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), this.method.getOptions().getBeanMapping().getMirror(), Message.BEANMAPPING_ABSTRACT, resultType, this.method.getResultType());
                error = false;
            } else if (!resultType.isAssignableTo(this.method.getResultType())) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), this.method.getOptions().getBeanMapping().getMirror(), Message.BEANMAPPING_NOT_ASSIGNABLE, resultType, this.method.getResultType());
                error = false;
            } else if (!resultType.hasAccessibleConstructor()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), this.method.getOptions().getBeanMapping().getMirror(), Message.GENERAL_NO_SUITABLE_CONSTRUCTOR, resultType);
                error = false;
            }
            return error;
        }

        private boolean canReturnTypeBeConstructed(Type returnType) {
            boolean error = true;
            if (returnType.isAbstract()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.GENERAL_ABSTRACT_RETURN_TYPE, returnType);
                error = false;
            } else if (!returnType.hasAccessibleConstructor()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.GENERAL_NO_SUITABLE_CONSTRUCTOR, returnType);
                error = false;
            }
            return error;
        }

        private void initializeFactoryMethod(Type returnTypeImpl, SelectionParameters selectionParameters) {
            List<SelectedMethod<SourceMethod>> matchingFactoryMethods = ObjectFactoryMethodResolver.getMatchingFactoryMethods(this.method, returnTypeImpl, selectionParameters, this.ctx);
            if (matchingFactoryMethods.isEmpty()) {
                if (this.factoryMethod == null && this.returnTypeBuilder != null) {
                    this.factoryMethod = ObjectFactoryMethodResolver.getBuilderFactoryMethod(this.method, this.returnTypeBuilder);
                    this.hasFactoryMethod = this.factoryMethod != null;
                }
            } else if (matchingFactoryMethods.size() == 1) {
                this.factoryMethod = ObjectFactoryMethodResolver.getFactoryMethodReference(this.method, Collections.first(matchingFactoryMethods), this.ctx);
                this.hasFactoryMethod = true;
            } else {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.GENERAL_AMBIGIOUS_FACTORY_METHOD, returnTypeImpl, Strings.join(matchingFactoryMethods, ", "));
                this.hasFactoryMethod = true;
            }
        }

        /*
         * WARNING - void declaration
         */
        private ConstructorAccessor getConstructorAccessor(Type type) {
            LinkedHashMap<String, Accessor> constructorAccessors;
            void var7_19;
            if (type.isRecord()) {
                List<Element> recordComponents = type.getRecordComponents();
                ArrayList<ParameterBinding> parameterBindings2 = new ArrayList<ParameterBinding>(recordComponents.size());
                LinkedHashMap<String, Accessor> constructorAccessors2 = new LinkedHashMap<String, Accessor>();
                for (Element element : recordComponents) {
                    String string = element.getSimpleName().toString();
                    Accessor accessor = this.createConstructorAccessor(element, string);
                    constructorAccessors2.put(string, accessor);
                    parameterBindings2.add(ParameterBinding.fromTypeAndName(this.ctx.getTypeFactory().getType(element.asType()), accessor.getSimpleName()));
                }
                return new ConstructorAccessor(parameterBindings2, constructorAccessors2);
            }
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(type.getTypeElement().getEnclosedElements());
            ExecutableElement defaultConstructor = null;
            ArrayList<ExecutableElement> accessibleConstructors = new ArrayList<ExecutableElement>(constructors.size());
            for (ExecutableElement executableElement : constructors) {
                if (executableElement.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                if (executableElement.getParameters().isEmpty()) {
                    defaultConstructor = executableElement;
                    continue;
                }
                accessibleConstructors.add(executableElement);
            }
            if (defaultConstructor != null) {
                return null;
            }
            if (accessibleConstructors.isEmpty()) {
                return null;
            }
            ExecutableElement constructor = null;
            if (accessibleConstructors.size() > 1) {
                block2: for (ExecutableElement executableElement : accessibleConstructors) {
                    for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
                        if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals("Default")) continue;
                        constructor = executableElement;
                        continue block2;
                    }
                }
                if (constructor == null) {
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.GENERAL_AMBIGIOUS_CONSTRUCTORS, type, Strings.join(constructors, ", "));
                    return null;
                }
            } else {
                constructor = (ExecutableElement)accessibleConstructors.get(0);
            }
            List<Parameter> list = this.ctx.getTypeFactory().getParameters((DeclaredType)type.getTypeMirror(), constructor);
            Object var7_17 = null;
            block4: for (AnnotationMirror annotationMirror : constructor.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals("ConstructorProperties")) continue;
                for (Map.Entry entry : annotationMirror.getElementValues().entrySet()) {
                    if (!((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("value")) continue;
                    List<String> list2 = this.getArrayValues((AnnotationValue)entry.getValue());
                    break block4;
                }
            }
            if (var7_19 == null) {
                constructorAccessors = new LinkedHashMap<String, Accessor>();
                ArrayList<ParameterBinding> arrayList = new ArrayList<ParameterBinding>(list.size());
                for (Parameter parameter : list) {
                    String parameterName = parameter.getName();
                    Element parameterElement = parameter.getElement();
                    Accessor constructorAccessor = this.createConstructorAccessor(parameterElement, parameterName);
                    constructorAccessors.put(parameterName, constructorAccessor);
                    arrayList.add(ParameterBinding.fromTypeAndName(parameter.getType(), constructorAccessor.getSimpleName()));
                }
                return new ConstructorAccessor(arrayList, constructorAccessors);
            }
            if (var7_19.size() != list.size()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.GENERAL_CONSTRUCTOR_PROPERTIES_NOT_MATCHING_PARAMETERS, type);
                return null;
            }
            constructorAccessors = new LinkedHashMap();
            ArrayList<ParameterBinding> arrayList = new ArrayList<ParameterBinding>(var7_19.size());
            for (int i = 0; i < var7_19.size(); ++i) {
                String string = (String)var7_19.get(i);
                Parameter constructorParameter = list.get(i);
                Element parameterElement = constructorParameter.getElement();
                Accessor constructorAccessor = this.createConstructorAccessor(parameterElement, string);
                constructorAccessors.put(string, constructorAccessor);
                arrayList.add(ParameterBinding.fromTypeAndName(constructorParameter.getType(), constructorAccessor.getSimpleName()));
            }
            return new ConstructorAccessor(arrayList, constructorAccessors);
        }

        private Accessor createConstructorAccessor(Element element, String parameterName) {
            String safeParameterName = Strings.getSafeVariableName(parameterName, this.existingVariableNames);
            this.existingVariableNames.add(safeParameterName);
            return new ParameterElementAccessor(element, safeParameterName);
        }

        private List<String> getArrayValues(AnnotationValue av) {
            if (av.getValue() instanceof List) {
                ArrayList<String> result = new ArrayList<String>();
                for (AnnotationValue v : this.getValueAsList(av)) {
                    Object value = v.getValue();
                    if (value instanceof String) {
                        result.add((String)value);
                        continue;
                    }
                    return null;
                }
                return result;
            }
            return null;
        }

        private List<AnnotationValue> getValueAsList(AnnotationValue av) {
            return (List)av.getValue();
        }

        private boolean handleDefinedMappings(Type resultTypeToMap) {
            boolean errorOccurred = false;
            HashSet<String> handledTargets = new HashSet<String>();
            if (this.mappingReferences.hasNestedTargetReferences()) {
                errorOccurred = this.handleDefinedNestedTargetMapping(handledTargets, resultTypeToMap);
            }
            for (MappingReference mapping : this.mappingReferences.getMappingReferences()) {
                if (mapping.isValid()) {
                    String source;
                    String target = mapping.getTargetReference().getShallowestPropertyName();
                    if (!handledTargets.contains(target) && this.handleDefinedMapping(mapping, resultTypeToMap, handledTargets)) {
                        errorOccurred = true;
                    }
                    if (mapping.getSourceReference() == null || (source = mapping.getSourceReference().getShallowestPropertyName()) == null) continue;
                    this.unprocessedSourceProperties.remove(source);
                    continue;
                }
                errorOccurred = true;
            }
            for (String handledTarget : handledTargets) {
                this.unprocessedTargetProperties.remove(handledTarget);
                this.unprocessedConstructorProperties.remove(handledTarget);
                this.unprocessedDefinedTargets.remove(handledTarget);
            }
            return errorOccurred;
        }

        private boolean handleDefinedNestedTargetMapping(Set<String> handledTargets, Type resultTypeToMap) {
            NestedTargetPropertyMappingHolder holder = new NestedTargetPropertyMappingHolder.Builder().mappingContext(this.ctx).method(this.method).targetPropertiesWriteAccessors(this.unprocessedTargetProperties).targetPropertyType(resultTypeToMap).mappingReferences(this.mappingReferences).existingVariableNames(this.existingVariableNames).build();
            this.unprocessedSourceParameters.removeAll(holder.getProcessedSourceParameters());
            this.propertyMappings.addAll(holder.getPropertyMappings());
            handledTargets.addAll(holder.getHandledTargets());
            for (Map.Entry<String, Set<MappingReference>> entry : holder.getUnprocessedDefinedTarget().entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                this.unprocessedDefinedTargets.put(entry.getKey(), entry.getValue());
            }
            return holder.hasErrorOccurred();
        }

        private boolean handleDefinedMapping(MappingReference mappingRef, Type resultTypeToMap, Set<String> handledTargets) {
            boolean errorOccured = false;
            PropertyMapping propertyMapping = null;
            TargetReference targetRef = mappingRef.getTargetReference();
            MappingOptions mapping = mappingRef.getMapping();
            for (String dependency : mapping.getDependsOn()) {
                if (this.targetProperties.contains(dependency)) continue;
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), mapping.getMirror(), mapping.getDependsOnAnnotationValue(), Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_DEPENDS_ON, dependency);
                errorOccured = true;
            }
            String targetPropertyName = Collections.first(targetRef.getPropertyEntries());
            if (this.unprocessedDefinedTargets.containsKey(targetPropertyName)) {
                return false;
            }
            Accessor targetWriteAccessor = this.unprocessedTargetProperties.get(targetPropertyName);
            Accessor targetReadAccessor = resultTypeToMap.getPropertyReadAccessors().get(targetPropertyName);
            if (targetWriteAccessor == null) {
                if (targetReadAccessor == null) {
                    Object[] args;
                    Message msg;
                    Set<String> readAccessors = resultTypeToMap.getPropertyReadAccessors().keySet();
                    String mostSimilarProperty = Strings.getMostSimilarWord(targetPropertyName, readAccessors);
                    if (targetRef.getPathProperties().isEmpty()) {
                        msg = Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_RESULTTYPE;
                        args = new Object[]{targetPropertyName, resultTypeToMap, mostSimilarProperty};
                    } else {
                        ArrayList<String> pathProperties = new ArrayList<String>(targetRef.getPathProperties());
                        pathProperties.add(mostSimilarProperty);
                        msg = Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_TYPE;
                        args = new Object[]{targetPropertyName, resultTypeToMap, mapping.getTargetName(), Strings.join(pathProperties, ".")};
                    }
                    this.ctx.getMessager().printMessage(mapping.getElement(), mapping.getMirror(), mapping.getTargetAnnotationValue(), msg, args);
                    return true;
                }
                if (mapping.getInheritContext() != null && mapping.getInheritContext().isReversed()) {
                    return false;
                }
                if (!mapping.isIgnored()) {
                    Object[] args;
                    Message msg;
                    if (Objects.equals(targetPropertyName, mapping.getTargetName())) {
                        msg = Message.BEANMAPPING_PROPERTY_HAS_NO_WRITE_ACCESSOR_IN_RESULTTYPE;
                        args = new Object[]{mapping.getTargetName(), resultTypeToMap};
                    } else {
                        msg = Message.BEANMAPPING_PROPERTY_HAS_NO_WRITE_ACCESSOR_IN_TYPE;
                        args = new Object[]{targetPropertyName, resultTypeToMap, mapping.getTargetName()};
                    }
                    this.ctx.getMessager().printMessage(mapping.getElement(), mapping.getMirror(), mapping.getTargetAnnotationValue(), msg, args);
                    return true;
                }
            }
            if (mapping.isIgnored()) {
                if (targetWriteAccessor != null && targetWriteAccessor.getAccessorType() == AccessorType.PARAMETER) {
                    Type accessedType = this.ctx.getTypeFactory().getType(targetWriteAccessor.getAccessedType());
                    propertyMapping = ((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)new PropertyMapping.JavaExpressionMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).javaExpression(accessedType.getNull()).existingVariableNames(this.existingVariableNames)).target(targetPropertyName, targetReadAccessor, targetWriteAccessor)).dependsOn(mapping.getDependsOn())).mirror(mapping.getMirror())).build();
                }
                handledTargets.add(targetPropertyName);
            } else if (mapping.getConstant() != null) {
                propertyMapping = ((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)new PropertyMapping.ConstantMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).constantExpression(mapping.getConstant()).target(targetPropertyName, targetReadAccessor, targetWriteAccessor)).formattingParameters(mapping.getFormattingParameters()).selectionParameters(mapping.getSelectionParameters()).options(mapping).existingVariableNames(this.existingVariableNames)).dependsOn(mapping.getDependsOn())).mirror(mapping.getMirror())).build();
                handledTargets.add(targetPropertyName);
            } else if (mapping.getJavaExpression() != null) {
                propertyMapping = ((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)new PropertyMapping.JavaExpressionMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).javaExpression(mapping.getJavaExpression()).existingVariableNames(this.existingVariableNames)).target(targetPropertyName, targetReadAccessor, targetWriteAccessor)).dependsOn(mapping.getDependsOn())).mirror(mapping.getMirror())).build();
                handledTargets.add(targetPropertyName);
            } else {
                SourceReference sourceRef = mappingRef.getSourceReference();
                if (sourceRef == null && this.method.getSourceParameters().size() == 1) {
                    sourceRef = this.getSourceRef(this.method.getSourceParameters().get(0), targetPropertyName);
                }
                if (sourceRef != null) {
                    if (sourceRef.isValid()) {
                        propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).target(targetPropertyName, targetReadAccessor, targetWriteAccessor)).sourcePropertyName(mapping.getSourceName())).sourceReference(sourceRef).selectionParameters(mapping.getSelectionParameters()).formattingParameters(mapping.getFormattingParameters()).existingVariableNames(this.existingVariableNames)).dependsOn(mapping.getDependsOn())).defaultValue(mapping.getDefaultValue()).defaultJavaExpression(mapping.getDefaultJavaExpression()).mirror(mapping.getMirror())).options(mapping).build();
                        handledTargets.add(targetPropertyName);
                        this.unprocessedSourceParameters.remove(sourceRef.getParameter());
                    } else {
                        errorOccured = true;
                    }
                }
            }
            if (propertyMapping != null) {
                this.propertyMappings.add(propertyMapping);
            }
            return errorOccured;
        }

        private void applyTargetThisMapping() {
            HashSet handledTargetProperties = new HashSet();
            for (MappingReference targetThis : this.mappingReferences.getTargetThisReferences()) {
                List<SourceReference> sourceRefs = targetThis.getSourceReference().push(this.ctx.getTypeFactory(), this.ctx.getMessager(), this.method).stream().filter(sr -> this.unprocessedTargetProperties.containsKey(sr.getDeepestPropertyName()) || handledTargetProperties.contains(sr.getDeepestPropertyName())).collect(Collectors.toList());
                this.applyPropertyNameBasedMapping(sourceRefs);
                handledTargetProperties.addAll(sourceRefs.stream().map(AbstractReference::getDeepestPropertyName).collect(Collectors.toList()));
            }
        }

        private void applyPropertyNameBasedMapping() {
            ArrayList<SourceReference> sourceReferences = new ArrayList<SourceReference>();
            for (String targetPropertyName : this.unprocessedTargetProperties.keySet()) {
                for (Parameter sourceParameter : this.method.getSourceParameters()) {
                    SourceReference sourceRef = this.getSourceRef(sourceParameter, targetPropertyName);
                    if (sourceRef == null) continue;
                    sourceReferences.add(sourceRef);
                }
            }
            this.applyPropertyNameBasedMapping(sourceReferences);
        }

        private void applyPropertyNameBasedMapping(List<SourceReference> sourceReferences) {
            for (SourceReference sourceRef : sourceReferences) {
                String targetPropertyName = sourceRef.getDeepestPropertyName();
                Accessor targetPropertyWriteAccessor = this.unprocessedTargetProperties.remove(targetPropertyName);
                this.unprocessedConstructorProperties.remove(targetPropertyName);
                if (targetPropertyWriteAccessor == null) {
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.BEANMAPPING_SEVERAL_POSSIBLE_SOURCES, targetPropertyName);
                    continue;
                }
                Accessor targetPropertyReadAccessor = this.method.getResultType().getPropertyReadAccessors().get(targetPropertyName);
                MappingReferences mappingRefs = this.extractMappingReferences(targetPropertyName, false);
                PropertyMapping propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).target(targetPropertyName, targetPropertyReadAccessor, targetPropertyWriteAccessor)).sourceReference(sourceRef).existingVariableNames(this.existingVariableNames)).forgeMethodWithMappingReferences(mappingRefs).options(this.method.getOptions().getBeanMapping()).build();
                this.unprocessedSourceParameters.remove(sourceRef.getParameter());
                if (propertyMapping != null) {
                    this.propertyMappings.add(propertyMapping);
                }
                this.unprocessedDefinedTargets.remove(targetPropertyName);
                this.unprocessedSourceProperties.remove(targetPropertyName);
            }
        }

        private void applyParameterNameBasedMapping() {
            Iterator<Map.Entry<String, Accessor>> targetPropertyEntriesIterator = this.unprocessedTargetProperties.entrySet().iterator();
            while (targetPropertyEntriesIterator.hasNext()) {
                Map.Entry<String, Accessor> targetProperty = targetPropertyEntriesIterator.next();
                Iterator<Parameter> sourceParameters = this.unprocessedSourceParameters.iterator();
                while (sourceParameters.hasNext()) {
                    Parameter sourceParameter = sourceParameters.next();
                    if (!sourceParameter.getName().equals(targetProperty.getKey())) continue;
                    SourceReference sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(targetProperty.getKey()).build();
                    Accessor targetPropertyReadAccessor = this.method.getResultType().getPropertyReadAccessors().get(targetProperty.getKey());
                    MappingReferences mappingRefs = this.extractMappingReferences(targetProperty.getKey(), false);
                    PropertyMapping propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).target(targetProperty.getKey(), targetPropertyReadAccessor, targetProperty.getValue())).sourceReference(sourceRef).existingVariableNames(this.existingVariableNames)).forgeMethodWithMappingReferences(mappingRefs).options(this.method.getOptions().getBeanMapping()).build();
                    this.propertyMappings.add(propertyMapping);
                    targetPropertyEntriesIterator.remove();
                    sourceParameters.remove();
                    this.unprocessedDefinedTargets.remove(targetProperty.getKey());
                    this.unprocessedSourceProperties.remove(targetProperty.getKey());
                }
            }
        }

        private SourceReference getSourceRef(Parameter sourceParameter, String targetPropertyName) {
            SourceReference sourceRef = null;
            if (sourceParameter.getType().isPrimitive() || sourceParameter.getType().isArrayType()) {
                return sourceRef;
            }
            Accessor sourceReadAccessor = sourceParameter.getType().getPropertyReadAccessors().get(targetPropertyName);
            Accessor sourcePresenceChecker = sourceParameter.getType().getPropertyPresenceCheckers().get(targetPropertyName);
            if (sourceReadAccessor != null) {
                DeclaredType declaredSourceType = (DeclaredType)sourceParameter.getType().getTypeMirror();
                Type returnType = this.ctx.getTypeFactory().getReturnType(declaredSourceType, sourceReadAccessor);
                sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).type(returnType).readAccessor(sourceReadAccessor).presenceChecker(sourcePresenceChecker).name(targetPropertyName).build();
            }
            return sourceRef;
        }

        private MappingReferences extractMappingReferences(String targetProperty, boolean restrictToDefinedMappings) {
            if (this.unprocessedDefinedTargets.containsKey(targetProperty)) {
                Set<MappingReference> mappings = this.unprocessedDefinedTargets.get(targetProperty);
                return new MappingReferences(mappings, restrictToDefinedMappings);
            }
            return null;
        }

        private ReportingPolicyGem getUnmappedTargetPolicy() {
            if (this.mappingReferences.isForForgedMethods()) {
                return ReportingPolicyGem.IGNORE;
            }
            return this.method.getOptions().getMapper().unmappedTargetPolicy();
        }

        private void reportErrorForUnmappedTargetPropertiesIfRequired() {
            ReportingPolicyGem unmappedTargetPolicy = this.getUnmappedTargetPolicy();
            if (this.method instanceof ForgedMethod && this.targetProperties.isEmpty()) {
                ForgedMethod forgedMethod = (ForgedMethod)this.method;
                if (forgedMethod.getHistory() == null) {
                    Type sourceType = this.method.getParameters().get(0).getType();
                    Type targetType = this.method.getReturnType();
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_FORGED_MAPPING_NOT_FOUND, sourceType, targetType, targetType, sourceType);
                } else {
                    ForgedMethodHistory history = forgedMethod.getHistory();
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_FORGED_MAPPING_WITH_HISTORY_NOT_FOUND, history.createSourcePropertyErrorMessage(), history.getTargetType(), history.createTargetPropertyName(), history.getTargetType(), history.getSourceType());
                }
            } else if (!this.unprocessedTargetProperties.isEmpty() && unmappedTargetPolicy.requiresReport()) {
                if (!(this.method instanceof ForgedMethod)) {
                    Message msg = unmappedTargetPolicy.getDiagnosticKind() == Diagnostic.Kind.ERROR ? Message.BEANMAPPING_UNMAPPED_TARGETS_ERROR : Message.BEANMAPPING_UNMAPPED_TARGETS_WARNING;
                    Object[] args = new Object[]{MessageFormat.format("{0,choice,1#property|1<properties}: \"{1}\"", this.unprocessedTargetProperties.size(), Strings.join(this.unprocessedTargetProperties.keySet(), ", "))};
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), msg, args);
                } else if (!this.ctx.isErroneous()) {
                    Message msg = unmappedTargetPolicy.getDiagnosticKind() == Diagnostic.Kind.ERROR ? Message.BEANMAPPING_UNMAPPED_FORGED_TARGETS_ERROR : Message.BEANMAPPING_UNMAPPED_FORGED_TARGETS_WARNING;
                    String sourceErrorMessage = this.method.getParameters().get(0).getType().toString();
                    String targetErrorMessage = this.method.getReturnType().toString();
                    if (((ForgedMethod)this.method).getHistory() != null) {
                        ForgedMethodHistory history = ((ForgedMethod)this.method).getHistory();
                        sourceErrorMessage = history.createSourcePropertyErrorMessage();
                        targetErrorMessage = MessageFormat.format("\"{0} {1}\"", history.getTargetType(), history.createTargetPropertyName());
                    }
                    Object[] args = new Object[]{MessageFormat.format("{0,choice,1#property|1<properties}: \"{1}\"", this.unprocessedTargetProperties.size(), Strings.join(this.unprocessedTargetProperties.keySet(), ", ")), sourceErrorMessage, targetErrorMessage};
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), msg, args);
                }
            }
        }

        private ReportingPolicyGem getUnmappedSourcePolicy() {
            if (this.mappingReferences.isForForgedMethods()) {
                return ReportingPolicyGem.IGNORE;
            }
            return this.method.getOptions().getMapper().unmappedSourcePolicy();
        }

        private void reportErrorForUnmappedSourcePropertiesIfRequired() {
            ReportingPolicyGem unmappedSourcePolicy = this.getUnmappedSourcePolicy();
            if (!this.unprocessedSourceProperties.isEmpty() && unmappedSourcePolicy.requiresReport()) {
                Message msg = unmappedSourcePolicy.getDiagnosticKind() == Diagnostic.Kind.ERROR ? Message.BEANMAPPING_UNMAPPED_SOURCES_ERROR : Message.BEANMAPPING_UNMAPPED_SOURCES_WARNING;
                Object[] args = new Object[]{MessageFormat.format("{0,choice,1#property|1<properties}: \"{1}\"", this.unprocessedSourceProperties.size(), Strings.join(this.unprocessedSourceProperties.keySet(), ", "))};
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), msg, args);
            }
        }
    }
}

