/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.selector;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.gem.XmlElementDeclGem;
import org.mapstruct.ap.internal.gem.XmlElementRefGem;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.selector.MethodSelector;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;

public class XmlElementDeclSelector
implements MethodSelector {
    private final Types typeUtils;

    public XmlElementDeclSelector(Types typeUtils) {
        this.typeUtils = typeUtils;
    }

    @Override
    public <T extends Method> List<SelectedMethod<T>> getMatchingMethods(Method mappingMethod, List<SelectedMethod<T>> methods, List<Type> sourceTypes, Type targetType, SelectionCriteria criteria) {
        ArrayList<SelectedMethod<T>> nameMatches = new ArrayList<SelectedMethod<T>>();
        ArrayList<SelectedMethod<T>> scopeMatches = new ArrayList<SelectedMethod<T>>();
        ArrayList<SelectedMethod<T>> nameAndScopeMatches = new ArrayList<SelectedMethod<T>>();
        XmlElementRefInfo xmlElementRefInfo = this.findXmlElementRef(mappingMethod.getResultType(), criteria.getTargetPropertyName());
        for (SelectedMethod<T> candidate : methods) {
            boolean scopeIsSetAndMatches;
            SourceMethod candidateMethod;
            XmlElementDeclGem xmlElementDecl;
            if (!(candidate.getMethod() instanceof SourceMethod) || (xmlElementDecl = XmlElementDeclGem.instanceOn((candidateMethod = (SourceMethod)candidate.getMethod()).getExecutable())) == null) continue;
            String name = xmlElementDecl.name().get();
            TypeMirror scope = xmlElementDecl.scope().get();
            boolean nameIsSetAndMatches = name != null && name.equals(xmlElementRefInfo.nameValue());
            boolean bl = scopeIsSetAndMatches = scope != null && this.typeUtils.isSameType(scope, xmlElementRefInfo.sourceType());
            if (nameIsSetAndMatches) {
                if (scopeIsSetAndMatches) {
                    nameAndScopeMatches.add(candidate);
                    continue;
                }
                nameMatches.add(candidate);
                continue;
            }
            if (!scopeIsSetAndMatches) continue;
            scopeMatches.add(candidate);
        }
        if (!nameAndScopeMatches.isEmpty()) {
            return nameAndScopeMatches;
        }
        if (!scopeMatches.isEmpty()) {
            return scopeMatches;
        }
        if (!nameMatches.isEmpty()) {
            return nameMatches;
        }
        return methods;
    }

    private XmlElementRefInfo findXmlElementRef(Type resultType, String targetPropertyName) {
        TypeMirror startingMirror = resultType.getTypeMirror();
        XmlElementRefInfo defaultInfo = new XmlElementRefInfo(targetPropertyName, startingMirror);
        if (targetPropertyName == null) {
            return defaultInfo;
        }
        TypeMirror currentMirror = startingMirror;
        TypeElement currentElement = resultType.getTypeElement();
        while (currentElement != null) {
            for (Element element : currentElement.getEnclosedElements()) {
                XmlElementRefGem xmlElementRef;
                if (!element.getKind().equals((Object)ElementKind.FIELD) || !element.getSimpleName().contentEquals(targetPropertyName) || (xmlElementRef = XmlElementRefGem.instanceOn(element)) == null) continue;
                return new XmlElementRefInfo(xmlElementRef.name().get(), currentMirror);
            }
            currentMirror = currentElement.getSuperclass();
            currentElement = (TypeElement)this.typeUtils.asElement(currentMirror);
        }
        return defaultInfo;
    }

    private static class XmlElementRefInfo {
        private final String nameValue;
        private final TypeMirror sourceType;

        XmlElementRefInfo(String nameValue, TypeMirror sourceType) {
            this.nameValue = nameValue;
            this.sourceType = sourceType;
        }

        public String nameValue() {
            return this.nameValue;
        }

        public TypeMirror sourceType() {
            return this.sourceType;
        }
    }
}

