/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.AnnotationMapperReference;
import org.mapstruct.ap.internal.model.Constructor;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.NoArgumentConstructor;
import org.mapstruct.ap.internal.model.SupportingConstructorFragment;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Type;

public class AnnotatedConstructor
extends ModelElement
implements Constructor {
    private String name;
    private final List<AnnotationMapperReference> mapperReferences;
    private final List<Annotation> annotations;
    private final NoArgumentConstructor noArgumentConstructor;
    private final Set<SupportingConstructorFragment> fragments;

    public static AnnotatedConstructor forComponentModels(String name, List<AnnotationMapperReference> mapperReferences, List<Annotation> annotations, Constructor constructor, boolean includeNoArgConstructor) {
        NoArgumentConstructor noArgumentConstructor = null;
        if (constructor instanceof NoArgumentConstructor) {
            noArgumentConstructor = (NoArgumentConstructor)constructor;
        }
        NoArgumentConstructor noArgConstructorToInBecluded = null;
        Set<SupportingConstructorFragment> fragmentsToBeIncluded = Collections.emptySet();
        if (includeNoArgConstructor) {
            noArgConstructorToInBecluded = noArgumentConstructor != null ? noArgumentConstructor : new NoArgumentConstructor(name, fragmentsToBeIncluded);
        } else if (noArgumentConstructor != null) {
            fragmentsToBeIncluded = noArgumentConstructor.getFragments();
        }
        return new AnnotatedConstructor(name, mapperReferences, annotations, noArgConstructorToInBecluded, fragmentsToBeIncluded);
    }

    private AnnotatedConstructor(String name, List<AnnotationMapperReference> mapperReferences, List<Annotation> annotations, NoArgumentConstructor noArgumentConstructor, Set<SupportingConstructorFragment> fragments) {
        this.name = name;
        this.mapperReferences = mapperReferences;
        this.annotations = annotations;
        this.noArgumentConstructor = noArgumentConstructor;
        this.fragments = fragments;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> types = new HashSet<Type>();
        for (MapperReference mapperReference : this.mapperReferences) {
            types.addAll(mapperReference.getImportTypes());
        }
        for (Annotation annotation : this.annotations) {
            types.addAll(annotation.getImportTypes());
        }
        return types;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<AnnotationMapperReference> getMapperReferences() {
        return this.mapperReferences;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public NoArgumentConstructor getNoArgumentConstructor() {
        return this.noArgumentConstructor;
    }

    public Set<SupportingConstructorFragment> getFragments() {
        return this.fragments;
    }
}

