/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edi.unedifact.d05b.common;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.milyn.edisax.model.internal.DelimiterType;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.util.EDIUtils;
import org.milyn.smooks.edi.EDIWritable;

public class DirectoryIdentification
implements Serializable,
EDIWritable {
    private static final long serialVersionUID = 1L;
    private String versionIdentifier;
    private String releaseIdentifier;
    private String directoryStatusIdentifier;
    private String controllingAgencyIdentifier;
    private String languageNameCode;
    private String maintenanceOperationCode;

    public void write(Writer writer, Delimiters delimiters) throws IOException {
        StringWriter nodeWriter = new StringWriter();
        ArrayList<String> nodeTokens = new ArrayList<String>();
        if (this.versionIdentifier != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.versionIdentifier.toString()));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.releaseIdentifier != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.releaseIdentifier.toString()));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.directoryStatusIdentifier != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.directoryStatusIdentifier.toString()));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.controllingAgencyIdentifier != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.controllingAgencyIdentifier.toString()));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.languageNameCode != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.languageNameCode.toString()));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.maintenanceOperationCode != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.maintenanceOperationCode.toString()));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        nodeTokens.add(((Object)nodeWriter).toString());
        writer.write(EDIUtils.concatAndTruncate(nodeTokens, (DelimiterType)DelimiterType.FIELD, (Delimiters)delimiters));
        writer.write(delimiters.getSegmentDelimiter());
        writer.flush();
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public DirectoryIdentification setVersionIdentifier(String versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
        return this;
    }

    public String getReleaseIdentifier() {
        return this.releaseIdentifier;
    }

    public DirectoryIdentification setReleaseIdentifier(String releaseIdentifier) {
        this.releaseIdentifier = releaseIdentifier;
        return this;
    }

    public String getDirectoryStatusIdentifier() {
        return this.directoryStatusIdentifier;
    }

    public DirectoryIdentification setDirectoryStatusIdentifier(String directoryStatusIdentifier) {
        this.directoryStatusIdentifier = directoryStatusIdentifier;
        return this;
    }

    public String getControllingAgencyIdentifier() {
        return this.controllingAgencyIdentifier;
    }

    public DirectoryIdentification setControllingAgencyIdentifier(String controllingAgencyIdentifier) {
        this.controllingAgencyIdentifier = controllingAgencyIdentifier;
        return this;
    }

    public String getLanguageNameCode() {
        return this.languageNameCode;
    }

    public DirectoryIdentification setLanguageNameCode(String languageNameCode) {
        this.languageNameCode = languageNameCode;
        return this;
    }

    public String getMaintenanceOperationCode() {
        return this.maintenanceOperationCode;
    }

    public DirectoryIdentification setMaintenanceOperationCode(String maintenanceOperationCode) {
        this.maintenanceOperationCode = maintenanceOperationCode;
        return this;
    }
}

