/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edi.unedifact.d96a.common;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.milyn.edisax.model.internal.DelimiterType;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.util.EDIUtils;
import org.milyn.javabean.decoders.DABigDecimalDecoder;
import org.milyn.smooks.edi.EDIWritable;

public class DocumentMessageSummary
implements Serializable,
EDIWritable {
    private static final long serialVersionUID = 1L;
    private String documentMessageNumber;
    private String documentMessageNameCoded;
    private BigDecimal totalNumberOfItems;
    private DABigDecimalDecoder totalNumberOfItemsEncoder = new DABigDecimalDecoder();

    public void write(Writer writer, Delimiters delimiters) throws IOException {
        StringWriter nodeWriter = new StringWriter();
        ArrayList<String> nodeTokens = new ArrayList<String>();
        if (this.documentMessageNumber != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.documentMessageNumber.toString()));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.documentMessageNameCoded != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.documentMessageNameCoded.toString()));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.totalNumberOfItems != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.totalNumberOfItemsEncoder.encode((Object)this.totalNumberOfItems, delimiters)));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        nodeTokens.add(((Object)nodeWriter).toString());
        writer.write(EDIUtils.concatAndTruncate(nodeTokens, (DelimiterType)DelimiterType.FIELD, (Delimiters)delimiters));
        writer.write(delimiters.getSegmentDelimiter());
        writer.flush();
    }

    public String getDocumentMessageNumber() {
        return this.documentMessageNumber;
    }

    public DocumentMessageSummary setDocumentMessageNumber(String documentMessageNumber) {
        this.documentMessageNumber = documentMessageNumber;
        return this;
    }

    public String getDocumentMessageNameCoded() {
        return this.documentMessageNameCoded;
    }

    public DocumentMessageSummary setDocumentMessageNameCoded(String documentMessageNameCoded) {
        this.documentMessageNameCoded = documentMessageNameCoded;
        return this;
    }

    public BigDecimal getTotalNumberOfItems() {
        return this.totalNumberOfItems;
    }

    public DocumentMessageSummary setTotalNumberOfItems(BigDecimal totalNumberOfItems) {
        this.totalNumberOfItems = totalNumberOfItems;
        return this;
    }
}

