/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.data;

import java.time.zone.ZoneRulesProvider;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fortuna.ical4j.data.ContentHandler;
import net.fortuna.ical4j.data.ContentHandlerContext;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.CalendarException;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentBuilder;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterBuilder;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyBuilder;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.ZoneRulesProviderImpl;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.util.Constants;
import org.slf4j.LoggerFactory;

public class DefaultContentHandler
implements ContentHandler {
    private final ContentHandlerContext context;
    private final TimeZoneRegistry tzRegistry;
    private final Consumer<Calendar> consumer;
    protected PropertyBuilder propertyBuilder;
    protected final LinkedList<ComponentBuilder<Component>> components = new LinkedList();
    protected List<Property> calendarProperties;
    protected List<CalendarComponent> calendarComponents;

    public DefaultContentHandler(Consumer<Calendar> consumer, TimeZoneRegistry tzRegistry) {
        this(consumer, tzRegistry, new ContentHandlerContext());
    }

    @Deprecated
    public DefaultContentHandler(Consumer<Calendar> consumer, TimeZoneRegistry tzRegistry, Supplier<List<ParameterFactory<?>>> parameterFactorySupplier, Supplier<List<PropertyFactory<?>>> propertyFactorySupplier, Supplier<List<ComponentFactory<?>>> componentFactorySupplier) {
        this(consumer, tzRegistry, new ContentHandlerContext().withParameterFactorySupplier(parameterFactorySupplier).withPropertyFactorySupplier(propertyFactorySupplier).withComponentFactorySupplier(componentFactorySupplier));
    }

    public DefaultContentHandler(Consumer<Calendar> consumer, TimeZoneRegistry tzRegistry, ContentHandlerContext context) {
        this.consumer = consumer;
        this.tzRegistry = tzRegistry;
        this.context = context;
    }

    public ComponentBuilder<Component> getComponentBuilder() {
        if (this.components.isEmpty()) {
            return null;
        }
        return this.components.peek();
    }

    public void endComponent() {
        this.components.pop();
    }

    @Override
    public void startCalendar() {
        this.calendarProperties = new ArrayList<Property>();
        this.calendarComponents = new ArrayList<CalendarComponent>();
        this.components.clear();
    }

    @Override
    public void endCalendar() {
        ZoneRulesProvider.registerProvider(new ZoneRulesProviderImpl(this.tzRegistry));
        this.consumer.accept(new Calendar(new PropertyList(this.calendarProperties), new ComponentList<CalendarComponent>(this.calendarComponents)));
    }

    @Override
    public void startComponent(String name) {
        if (this.components.size() > 10) {
            throw new RuntimeException("Components nested too deep");
        }
        ComponentBuilder componentBuilder = new ComponentBuilder(this.context.getComponentFactorySupplier().get());
        componentBuilder.name(name);
        this.components.push(componentBuilder);
    }

    @Override
    public void endComponent(String name) {
        this.assertComponent(this.getComponentBuilder());
        ComponentBuilder<Component> componentBuilder = this.getComponentBuilder();
        this.endComponent();
        ComponentBuilder<Component> parent = this.getComponentBuilder();
        if (parent != null) {
            Component subComponent = componentBuilder.build();
            parent.subComponent(subComponent);
        } else {
            CalendarComponent component = (CalendarComponent)componentBuilder.build();
            this.calendarComponents.add(component);
            if (component instanceof VTimeZone && this.tzRegistry != null) {
                this.tzRegistry.register(new TimeZone((VTimeZone)component));
            }
        }
    }

    @Override
    public void startProperty(String name) {
        this.propertyBuilder = !this.context.getIgnoredPropertyNames().contains(name.toUpperCase()) ? new PropertyBuilder(this.context.getPropertyFactorySupplier().get()).name(name).timeZoneRegistry(this.tzRegistry) : null;
    }

    @Override
    public void propertyValue(String value) {
        if (this.propertyBuilder != null) {
            this.propertyBuilder.value(value);
        }
    }

    @Override
    public void endProperty(String name) {
        if (!this.context.getIgnoredPropertyNames().contains(name.toUpperCase())) {
            Property property;
            this.assertProperty(this.propertyBuilder);
            try {
                property = this.propertyBuilder.build();
            }
            catch (RuntimeException e) {
                if (this.context.isSuppressInvalidProperties()) {
                    LoggerFactory.getLogger(DefaultContentHandler.class).warn("Suppressing invalid property", (Throwable)e);
                    return;
                }
                throw e;
            }
            property = Constants.forProperty(property);
            if (this.getComponentBuilder() != null) {
                this.getComponentBuilder().property(property);
            } else if (this.calendarProperties != null) {
                this.calendarProperties.add(property);
            }
        }
    }

    @Override
    public void parameter(String name, String value) {
        if (this.propertyBuilder != null) {
            Parameter parameter = new ParameterBuilder(this.context.getParameterFactorySupplier().get()).name(name).value(value).build();
            if (parameter instanceof TzId && this.getComponentBuilder() != null && (this.getComponentBuilder().hasName("STANDARD") || this.getComponentBuilder().hasName("DAYLIGHT")) && this.propertyBuilder.hasName("DTSTART")) {
                return;
            }
            this.propertyBuilder.parameter(parameter);
        }
    }

    private void assertComponent(ComponentBuilder<?> component) {
        if (component == null) {
            throw new CalendarException("Expected component not initialised");
        }
    }

    private void assertProperty(PropertyBuilder property) {
        if (property == null) {
            throw new CalendarException("Expected property not initialised");
        }
    }
}

