/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;

public class AddressList
implements Serializable {
    private static final long serialVersionUID = 81383256078213569L;
    private final List<URI> addresses;

    public AddressList() {
        this.addresses = Collections.emptyList();
    }

    public AddressList(String aValue) throws URISyntaxException {
        this(aValue, CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed"));
    }

    public AddressList(String aValue, boolean allowInvalidAddress) throws URISyntaxException {
        ArrayList<URI> values = new ArrayList<URI>();
        for (String a : aValue.split("\\s*,\\s*")) {
            try {
                values.add(new URI(Uris.encode(Strings.unquote(a))));
            }
            catch (URISyntaxException use) {
                if (allowInvalidAddress) continue;
                throw use;
            }
        }
        this.addresses = Collections.unmodifiableList(values);
    }

    public AddressList(List<URI> addresses) {
        this.addresses = Collections.unmodifiableList(addresses);
    }

    public List<URI> getAddresses() {
        return this.addresses;
    }

    public final String toString() {
        return AddressList.toString(this.addresses);
    }

    public static String toString(List<URI> addresses) {
        return addresses.stream().map(Strings::quote).collect(Collectors.joining(","));
    }

    public final AddressList add(URI address) {
        ArrayList<URI> newlist = new ArrayList<URI>(this.addresses);
        newlist.add(address);
        return new AddressList(newlist);
    }

    public final AddressList remove(URI address) {
        ArrayList<URI> newlist = new ArrayList<URI>(this.addresses);
        if (newlist.remove(address)) {
            return new AddressList(newlist);
        }
        return this;
    }
}

